<?php
/*
class newmagaz_logo extends thesis_box {
private $ns = 'bts';
protected function translate() {
$this->title = $this->name = __('Newmagaz Logo Box', 'bts');
$this->name = $this->title;
}

protected function options() {
global $thesis;
return array(

'logo_class' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Html Class', 'bts'),
'tooltip' => __('Enter your own class name for Logo Box', 'bts'),
'placeholder' => __('Enter your Html class', 'bts')),

'logo_img' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Enter the logo image url', 'bts'),
'tooltip' => __('Enter the URL for your image.', 'bts')),

'logo_width' => array(
'type' => 'text',
'width' => 'tiny',
'label' => __('Set the width of the image', 'bts'),
'tooltip' => __('Enter the width of the image without "px". For eg: 200', 'bts')),

'logo_height' => array(
'type' => 'text',
'width' => 'tiny',
'label' => __('Set the height of the image', 'bts'),
'tooltip' => __('Enter the height of the image without "px". For eg: 60', 'bts')));
}

public function html($args = false) {
extract($args = is_array($args) ? $args : array());
$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
// Get the Default Values
$logo_class = !empty($this->options['logo_class']) ? $this->options['logo_class'] : 'newmagaz_logo';
$logo_img = !empty($this->options['logo_img']) ? $this->options['logo_img'] : '';
$logo_width = !empty($this->options['logo_width']) && is_numeric($this->options["logo_width"]) ? $this->options['logo_width'] : '';
$logo_height = !empty($this->options['logo_height']) && is_numeric($this->options["logo_height"]) ? $this->options['logo_height'] : '';

// Print section
echo "<div class=\"". $logo_class ."\">".
"<h1>".
"<a title=\"". get_bloginfo('name') ."\" href=\"". get_bloginfo('wpurl') ."\">".
"<img src=\"". $logo_img ."\" width=\"". $logo_width ."\" height=\"". $logo_height ."\" alt=\"". get_bloginfo('name') ."\"/>".
"</a>".
"</h1>".
"</div>";
}
}*/

class newmagaz_featured_image extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Featured Image', 'thesis');
$this->name = $this->title;
}

protected function construct() {
require_once('lib/aq_resizer.php'); 
}

public function options() {
global $thesis;
return array(
'class' => array(
'type' => 'text',
'width' => 'medium',
'code' => true,
'label' => $thesis->api->strings['html_class'],
'tooltip' => sprintf('%s %s', $thesis->api->strings['class_tooltip'], $thesis->api->strings['class_note']),
'placeholder' => __('featured_image', 'thesis')),

'resizer_width' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width of the Featured Image', 'thesis'),
'tooltip' => __('Set the width of the featured image', 'thesis'),
'placeholder' => __('284', 'thesis')),

'resizer_height' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height of the Featured Image.', 'thesis'),
'tooltip' => __('Set the height of the featured image', 'thesis'),
'placeholder' => __('238', 'thesis')));
}

public function html($args = false) {
extract($args = is_array($args) ? $args : array());
$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
// Defaults
$resizer_width = !empty($this->options['resizer_width']) && is_numeric($this->options["resizer_width"]) ? $this->options['resizer_width'] : '284';
$resizer_height = !empty($this->options['resizer_height']) && is_numeric($this->options["resizer_height"]) ? $this->options['resizer_height'] : '238';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';

// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );

// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );

if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";

elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";  
} 
   
}
}


class newmagaz_search extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz search Box', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'searchcheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Search Box', 'thesis'),
'tooltip' => __('Here to Enable Newmagaz Search Box', 'thesis'),
'options' => array(
'searchoptions' => __('Enable Newmagaz Search Box', 'thesis'),
)
),
				
'search' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Search Placeholder Text Here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Search Placeholder Text Here', 'thesis'),
'default' => 'Search here.'
),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['searchcheck']){?>
<div class='widget_search'>
<form method='get' action='<?php echo get_bloginfo('home'); ?>'>
<input type='text' placeholder='<?php echo $options['search']; ?>' name='s' id='s' />			
<button type='submit' class='btn btn-success'>
<i class='fa fa-search'></i>
</button>
</form>
</div>
<?php
}
}
}

class newmagaz_readmore extends thesis_box{
protected function translate() {
$this->title = __('Newmagaz Readmore', 'thesis');
}

protected function options() {
global $thesis;return array(
'readcheck' => array(
'type' => 'checkbox',
'label' => __('Disable Readmore Box', 'thesis'),
'tooltip' => __('Disable Readmore Box', 'thesis'),
'options' => array('readoptions' => __('Disable Readmore Box', 'thesis'),)),

'rtext' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Readmore Text here', 'thesis'),
'tooltip' => __('Here to change your Readmore Text', 'thesis'),
'default' => 'Read More'),);
}
public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if(!$options['readcheck']){
echo "<div class=\"newmagaz_readmore cl-effect-10 rm_center \">".
"<a href=\"". get_the_permalink() ."\" title=\"Continue Reading: ". get_the_title() ."\" rel=\"bookmark\" data-hover='". $options['rtext'] ."'><span class=\"read-more-blog-new  \">". $options['rtext'] ."</span></a>".
"</div>";
}}
}

class newmagaz_header_advertisement extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Header Advertisement Box', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'headercheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Header Advertisement Box', 'thesis'),
'tooltip' => __('Here to Enable Newmagaz Header Advertisement Box', 'thesis'),
'options' => array(
'searchoptions' => __('Enable Newmagaz Header Advertisement Box', 'thesis'),
)
),
				
'link' => array(
'type' => 'textarea',
'width' => 'medium',
'label' => __('Paste your Newmagaz Header Advertisement Image link here', 'thesis'),
'tooltip' =>__('Here to Paste your Newmagaz HeaderAdvertisement Image link', 'thesis'),
'default' => ''
),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['headercheck']){
echo "<div class='header_advertisement'>".
		"". $options['link'] ."".
	"</div>";
}
}
}

class newmagaz_breaking_news extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Breaking News', 'thesis');
}

protected function options() {
global $thesis;return array(
'tickercheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Breaking News Box', 'thesis'),
'tooltip' => __('Enable Newmagaz Breaking News Box', 'thesis'),
'options' => array('timeoptions' => __('Enable Newmagaz Breaking News Box', 'thesis'),)),

'ticker_title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Breaking News Title here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Breaking News Title here', 'thesis'),
'default' => 'TOP NEWS'
),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['tickercheck']){?>
<div class="news-ticker">
<div class="news-ticker_title">
<h3><?php echo $options['ticker_title']; ?></h3></div>
<div class="news-ticker_content">
<div id="nt-title-container">
<ul class="slide" id="nt-title">
<?php
$month = date('m');
query_posts('post_type=post&posts_per_page=10&orderby=comment_count&order=DESC&monthnum=' . $month);
while (have_posts()): the_post(); ?>
<li>
<?php 
echo "<h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>";
?>
</li>
<?php endwhile;
wp_reset_query(); ?>

</ul>
</div>
</div>
</div>
<?php
}}
}

class newmagaz_scripts extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Scripts', 'thesis');
}

protected function construct() {
require_once('lib/aq_resizer.php'); 
}

public function options() {
global $thesis;
return array(
'scriptscheck' => array(
'type' => 'checkbox',
'label' => __('Disable Newmagaz scripts', 'thesis'),
'tooltip' => __('Here to Disable Newmagaz scripts', 'thesis'),
'options' => array(
'scriptsoptions' => __('Disable Newmagaz scripts', 'thesis'),
)
),

'background_image' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Body Background Image Link here', 'thesis'),
'tooltip' => __('Here to Paste your Body Background Image Link', 'thesis'),
'default' => ''
),

);
}

public function preload() {
static $did = false;
if (!$did)
add_filter('thesis_footer_scripts', array($this, 'js'));
$did = true;
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);	
if(!$options['scriptscheck']){ 
?>
<div>
<style scoped="scoped"  type="text/css">
body{
background-image: url(<?php echo $options['background_image']; ?>);
background-position: center center;
  background-repeat: no-repeat;
  background-attachment: fixed;
  background-size: cover;
}
</style>
</div> 
<?php
 
}
}

public function js() {
		return array(
"<script type='text/javascript' src=\"". THESIS_USER_URL ."/skins/newmagaz/lib/owl.carousel.js\">\n"."</script>\n".
"<script type=\"text/javascript\" src=\"". THESIS_USER_URL ."/skins/newmagaz/lib/jquery.newsTicker.min.js\">\n"."</script>\n".
"<script type=\"text/javascript\" src=\"". THESIS_USER_URL ."/skins/newmagaz/lib/jquery.mCustomScrollbar.concat.min.js\">\n"."</script>\n".
"<script>".
 "var j=jQuery.noConflict();".
 "var nt_title = j('#nt-title').newsTicker({".
 "row_height: 40,".
 "max_rows: 1,".
 "duration: 3000,".
 " pauseOnHover: 1".
 "});".
 "</script>".

"<script type='text/javascript'>".
"var j=jQuery.noConflict();".
"j(document).ready(function() {".
"j('#owl-demo').owlCarousel({".
"items : 3,".
"lazyLoad : true,".
"navigation : true".
"}); ".
"});".
"</script>".

"<script>".
"(function($){".
"j(window).load(function(){".
"j('a[rel='load-content']').click(function(e){".
"e.preventDefault();".
"var url=$(this).attr('href');".
"j.get(url,function(data){".
"j('.content .mCSB_container').append(data); //load new content inside .mCSB_container".
"//scroll-to appended content". 
"j('.content').mCustomScrollbar('scrollTo','h2:last');".
"});".
"});".
"j('.content').delegate('a[href='top']','click',function(e){".
"e.preventDefault();".
"j('.content').mCustomScrollbar('scrollTo',j(this).attr('href'));".
"});".
"});".
"})(jQuery);".
"</script>".

"<script type=\"text/javascript\">".
"var j=jQuery.noConflict();".
"j(window).scroll(function() {".  
"var scroll = j(window).scrollTop();".
"if (scroll >= 50) {".
"j('.btm_header').addClass('scrolltop');".
"}".
"else {".
"j('.btm_header').removeClass('scrolltop');".
"}".
"});".
"</script>".

"<script type=\"text/javascript\">\n".
"(function(){\n".
"var classes = document.getElementsByClassName('menu_control');\n".
"for (i = 0; i < classes.length; i++) {\n".
"classes[i].onclick = function() {\n".
"var menu = this.nextElementSibling;\n".
"if (/show_menu/.test(menu.className))\n".
"menu.className = menu.className.replace('show_menu', '').trim();\n".
"else\n".
"menu.className += ' show_menu';\n".
"};\n".
"}\n".
"})();\n".
"</script>\n".

"<noscript><style type=\"text/css\" scoped>.menu { display: block; }</style></noscript>\n"
);
}
}


class newmagaz_latest_news extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Latest News Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'latnewscheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Latest News Box', 'thesis'),
'tooltip' =>__('Enable Newmagaz Latest News Box', 'thesis'),
'options' => array(
'latnewsoptions' => __('Enable Newmagaz Latest News Box', 'thesis'),
)
),	

'resizer_width' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Latest News Top Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Latest News Top Featured Image', 'thesis'),
'placeholder' => __('577', 'thesis')),

'resizer_height' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Latest News Top Featured Image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Latest News Top Featured Image', 'thesis'),
'placeholder' => __('230', 'thesis')),
		

'resizer_width1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Latest News Bottom Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Latest News Bottom Featured Image', 'thesis'),
'placeholder' => __('383', 'thesis')),

'resizer_height1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Latest News Bottom Featured Image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Latest News Bottom Featured Image', 'thesis'),
'placeholder' => __('215', 'thesis')),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['latnewscheck']){
echo "<div class='latest_news'>";
$i = 1;
query_posts( array('posts_per_page'=>5) );
while ( have_posts() ) : the_post();
if(($i == 1) || ($i == 2)){
$class = ( $i % 2 ) ? 'first_lat_news' : 'first_lat_news last';
echo "<div class='". $class ."'><div class='lat_img'>";

// Defaults
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width'] : '577';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height'] : '270';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='thumb_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='thumb_hover'></div></a>\n".
"</div>\n";  
} 
echo "</div>".
"<div class='lat_news_right'><div class='s_c_one_title'><h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4></div>".
"<div class='s_c_one_byline'>";
$category = get_the_category(); 
?>
<h4><a href='<?php echo get_category_link($category[0]->cat_ID) ?>'><?php echo $category[0]->cat_name; ?></a></h4>
<?php
echo "</div>";
echo "</div></div>";
}


else{

$additional_class = (++$j % 3 == 0) ? 'btm_lat_news last' : 'btm_lat_news';
echo "<div class='". $additional_class ."'><div class='lat_img'>";
// Defaults
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '383';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '215';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='thumb_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='thumb_hover'></div></a>\n".
"</div>\n";  
} 
echo "</div>".
"<div class='lat_news_right'><div class='s_c_one_title'><h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4></div>".
"<div class='s_c_one_byline'>";
$category = get_the_category(); 
?>
<h4><a href='<?php echo get_category_link($category[0]->cat_ID) ?>'><?php echo $category[0]->cat_name; ?></a></h4>
<?php
echo "</div>";
echo "</div></div>";
}
$i++;
endwhile;
wp_reset_query(); 
echo "</div>";
}
}
}

class newmagaz_sidebar_advertisement extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Sidebar Advertisement Box', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'headercheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Sidebar Advertisement Box', 'thesis'),
'tooltip' => __('Here to Enable Newmagaz Sidebar Advertisement Box', 'thesis'),
'options' => array(
'searchoptions' => __('Enable Newmagaz Sidebar Advertisement Box', 'thesis'),
)
),
				
'link' => array(
'type' => 'textarea',
'width' => 'medium',
'label' => __('Paste your Newmagaz Sidebar Advertisement Image Link here', 'thesis'),
'tooltip' =>__('Here to Paste your Newmagaz HeaderAdvertisement Image Link', 'thesis'),
'default' => ''
),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['headercheck']){
echo "<div class='sidebar_advertisement widget'>".
		"". $options['link'] ."".
	"</div>";
}
}
}

class newmagaz_landing_optin_with_video_box extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Landing Page Optin with Video Box ', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'firstcheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Landing Page Optin with Video Box', 'thesis'),
'tooltip' => __('Here to Enable Newmagaz Landing Page Optin with Video Box', 'thesis'),
'options' => array(
'popularoptions' => __('Enable Newmagaz Landing Page Optin with Video box', 'thesis'),
),
'default' => array(
'optinchecktext' => false,
'html'	=> ''
)
),

'optin_code' => array(
'type' => 'textarea',
'width' => 'long',
'label' => __('Paste your html code', 'thesis'),
'tooltip' => __('Here to paste your html code', 'thesis'),
'default' => ''
),

'optin_name' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Form name ', 'thesis'),
'tooltip' => __('Name will automatically fetch after putting html code', 'thesis'),
'default' => 'Enter your name'
),

'optin_email' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Form email ', 'thesis'),
'tooltip' => __('Email will automatically fetch after putting html code', 'thesis'),
'default' => 'Enter your Email'
),
	
'optin_url' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Form action url ', 'thesis'),
'tooltip' => __('Action url will automatically fetch after putting html code', 'thesis'),
'default' => '#'
),

'optin_hidden' => array(
'type' => 'textarea',
'width' => 'long',
'label' => __('Hidden fields', 'thesis'),
'tooltip' => __('Hidden fields will automatically fetch after putting html code)', 'thesis'),
'default' => ''
),

'name_text' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Change your Enter your name text here', 'thesis'),
'tooltip' => __('Here to Change your Enter your name text here', 'thesis'),
'default' => 'Enter your name'
),	
	
'email_text' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Change your Enter your email text here', 'thesis'),
'tooltip' => __('Here to Change your Enter your email text here', 'thesis'),
'default' => 'Enter your email'
),

'submit_text' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Change your Subscribe me button text', 'thesis'),
'tooltip' => __('Here to Change your Subscribe me button text', 'thesis'),
'default' => 'Subscribe me'
),

'ovb_link' => array(
'type' => 'textarea',
'width' => 'medium',
'label' => __('Paste your Newmagaz Landing Page Optin with Video Image URL Link here', 'thesis'),
'tooltip' => __('Here to Paste your Newmagaz Landing Page Optin with Video Image URL Link', 'thesis'),
'default' => ''
),

'ovb_title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Landing Page Optin with Video Box Title here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Landing Page Optin with Video Box Fitle', 'thesis'),
'default' => ''
),

'content' => array(
'type' => 'textarea',
'width' => 'long',
'label' => __('Change your Newmagaz Landing Page Optin with Video Box Content here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Landing Page Optin with Video Box Content', 'thesis'),
'default' => ''
),

);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['firstcheck']){

?>
<div class="optin_video_box">
<div class="optin_video_box_inner">

<div class="ovb_left">
<?php
echo "<div class='squeeze_video'>".
		"". $options['ovb_link'] ."".
	"</div>";
 ?>
</div>
<div class="ovb_right">
<?php
echo "<div class=\"right_newmagaz_optin\">".
"<h2>". "". $options['ovb_title'] ."". "</h2>".
"<p>".
"". $options['content'] ."".
"</p>".
"<form method=\"post\" class=\"form\" action=\"". stripslashes($options['optin_url']) ."\" target=\"_blank\">".
"<div class=\"names\"><input class=\"name\" type=\"text\" name=\"". stripslashes($options['optin_name']) ."\" placeholder=\"". stripslashes($options['name_text']) ."\"/><div class=\"admins\"></div></div>".
"<div class=\"names\"><input class=\"email\" type=\"text\" name=\"". stripslashes($options['optin_email']) ."\" placeholder=\"". stripslashes($options['email_text']) ."\"/><div class=\"mails\"></div></div>".
"". stripslashes($options['optin_hidden']) ."".
"<input name=\"submit\" class=\"submit\" type=\"submit\" value=\"". stripslashes($options['submit_text']) ."\"/>".
"</form>".
"</div>";
?>
</div>
</div>
</div>
<?php 
}
}
}

class newmagaz_landing_box_feature extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Landing Page Feature Box', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'firstlandingcheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Landing Page Feature Box', 'thesis'),
'tooltip' => __('Here to Enable Newmagaz Landing Page Feature Box', 'thesis'),
'options' => array(
'popularoptions' => __('Enable Newmagaz Landing Page Feature Box', 'thesis'),
)
),

'feature_title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Landing Page Features Title here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Landing Page Features Title here', 'thesis'),
'default' => 'Features'
),

'featureimg_link1' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your  Newmagaz Landing Page Features Image link1 here', 'thesis'),
'tooltip' => __('Here to Paste your Newmagaz Page Features Image link1', 'thesis'),
'default' => ''
),

'sub_title1' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Landing Page Features Subtitle1 here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Page Landing Features Subtitle1', 'thesis'),
'default' => ''
),


'feature_para1' => array(
'type' => 'textarea',
'width' => 'long',
'label' => __('Change your Newmagaz Landing Page Feature Content1 here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Landing Page Feature Content1 here', 'thesis'),
'default' => ''
),

'readmore1' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Paste your  Newmagaz Landing Page Features Readmore Text1 here', 'thesis'),
'tooltip' => __('Here to Paste your Newmagaz Page Features Readmore Text1', 'thesis'),
'default' => ''
),

'link1' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Newmagaz Landing Page Features Readmore Text1 url link here', 'thesis'),
'tooltip' => __('Here to Paste your Newmagaz Landing Page Features  Readmore Text1 url link', 'thesis'),
'default' => ''
),

'featureimg_link2' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your  Newmagaz Landing Page Features Image link2 here', 'thesis'),
'tooltip' => __('Here to Paste your Newmagaz Landing Page Features Image link2', 'thesis'),
'default' => ''
),

'sub_title2' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz landing Page Features Subtitle2 here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz landing Page Features  Subtitle2', 'thesis'),
'default' => ''
),

'feature_para2' => array(
'type' => 'textarea',
'width' => 'long',
'label' => __('Change your Newmagaz Landing Page Feature Content2 here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Landing Page Feature Content2 here', 'thesis'),
'default' => ''
),

'readmore2' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Paste your Newmagaz Landing Page Features Readmore Text2 here', 'thesis'),
'tooltip' => __('Here to Paste your Newmagaz Landing Page Features Readmore Text2', 'thesis'),
'default' => ''
),

'link2' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Newmagaz Landing Page Features Readmore Text2 url link here', 'thesis'),
'tooltip' => __('Here to Paste your Newmagaz Landing Page Features  Readmore Text2 url link', 'thesis'),
'default' => ''
),


'featureimg_link3' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Newmagaz Landing Page Features Image link3 here', 'thesis'),
'tooltip' => __('Here to Paste your Newmagaz Landing Page Features Image link3', 'thesis'),
'default' => ''
),

'sub_title3' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Landing Page Features Subtitle3 here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Landing Page Features Subtitle3', 'thesis'),
'default' => ''
),

'feature_para3' => array(
'type' => 'textarea',
'width' => 'long',
'label' => __('Change your Newmagaz Landing Page Feature Content3 here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Landing Page Feature Content3 here', 'thesis'),
'default' => ''
),

'readmore3' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Paste your Newmagaz Landing Page Features Readmore Text3 here', 'thesis'),
'tooltip' => __('Here to Paste Newmagaz Landing Page Features Readmore Text3', 'thesis'),
'default' => ''
),

'link3' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Newmagaz Landing Page Features Readmore Text3 url link here', 'thesis'),
'tooltip' => __('Here to Paste your Newmagaz Landing Page Features  Readmore Text3 url link', 'thesis'),
'default' => ''
),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['firstlandingcheck']){
?>

<div class="landing_feature_box">
<div class="inner_feature_box">
<div class="feature_box_header_para">
<h3><?php echo $options['feature_title']; ?></h3>
</div>
<div class="feature_box_content">
<div class="column_one">
<img alt='<?php echo $options['sub_title1']; ?>' src='<?php echo $options['featureimg_link1']; ?>'/>
<h4><a href='<?php echo $options['link1']; ?>'><?php echo $options['sub_title1']; ?></a></h4>
<p><?php echo $options['feature_para1']; ?></p>
<?php
echo "<div class='about_read cl-effect-10'><a href='". $options['link1'] ."' data-hover='". $options['readmore1'] ."'><span>". $options['readmore1'] ."</span></a></div>";
?>
</div>
					
<div class="column_one">
<img alt='<?php echo $options['sub_title2']; ?>' src='<?php echo $options['featureimg_link2']; ?>'/>
<h4><a href='<?php echo $options['link2']; ?>'><?php echo $options['sub_title2']; ?></a></h4>
<p><?php echo $options['feature_para2']; ?></p>
<?php
echo "<div class='about_read cl-effect-10'><a href='". $options['link2'] ."' data-hover='". $options['readmore2'] ."'><span>". $options['readmore2'] ."</span></a></div>";
?>
</div>
					
<div class="column_one ftr_last">
<img alt='<?php echo $options['sub_title3']; ?>' src='<?php echo $options['featureimg_link3']; ?>'/>
<h4><a href='<?php echo $options['link3']; ?>'><?php echo $options['sub_title3']; ?></a></h4>
<p><?php echo $options['feature_para3']; ?></p>
<?php
echo "<div class='about_read cl-effect-10'><a href='". $options['link3'] ."' data-hover='". $options['readmore3'] ."'><span>". $options['readmore3'] ."</span></a></div>";
?>
</div>
</div>
</div>
</div>

<?php 
}
}
}

class newmagaz_first_category extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz First Category Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'firstccheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz First Category Box', 'thesis'),
'tooltip' => __('Enable Newmagaz First Category Box', 'thesis'),
'options' => array(
'firstcoptions' => __('Enable Newmagaz First Category Box', 'thesis'),
)
),				

'afirstbox'=>array(
'type'=>'text',
'width'=>'medium',
'label'=>__('Change the Category ID','thesis'),
'tooltip'=>__('Here to change the Category ID','thesis'),
'default'=>'1'
),

'rdtext' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Readmore Text here', 'thesis'),
'tooltip' => __('Here to change your Readmore Text', 'thesis'),
'default' => 'Read More'),


'resizer_width1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz First Category Left Featured image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz First Category Left Featured image', 'thesis'),
'placeholder' => __('401', 'thesis')),

'resizer_height1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz First Category Left Featured image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz First Category Left Featured image', 'thesis'),
'placeholder' => __('231', 'thesis')),

'resizer_width2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz First Category Right Featured image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz First Category Right Featured image', 'thesis'),
'placeholder' => __('90', 'thesis')),

'resizer_height2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz First Category Right Featured image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz First Category Right Featured image', 'thesis'),
'placeholder' => __('60', 'thesis')),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['firstccheck']){
/*First Category Id*/
echo "<div class='first_category clearfix'>";
echo"<div class='block_title'>".
"<a title='";
$category=get_the_category_by_id($options['afirstbox']); echo $category;
echo "'".
" href='";
$category_link = get_category_link($options['afirstbox']);
echo esc_url( $category_link );
echo "'".
"><h3 class='title_clr'>";
$category=get_the_category_by_id($options['afirstbox']); echo $category;
echo "</h3></a>".
"</div>";
echo "<div class='first_category_inner'>";
/*left category section starts here*/
echo "<div class='first_cat'>";
query_posts( array('posts_per_page'=>1, cat=>$options['afirstbox']) );
while ( have_posts() ) : the_post();
echo "<div class='first_left_category'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '401';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '231';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "<h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class='author'>". get_the_author() ."</span>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
/*content starts here*/
echo "<p>";
$excerpt=get_the_excerpt();
echo limit_words($excerpt,20);
echo "</p>".
"<div class='permalink cl-effect-10'><a href='".get_permalink()."' data-hover='". $options['rdtext'] ."'><span>". $options['rdtext'] ."</span></a></div>";
/*content ends here*/
endwhile;
wp_reset_query(); 
echo "</div>";

?>
<div><section class='examples'>
<!-- content -->
<div class="content mCustomScrollbar">
<?php query_posts( array('posts_per_page'=>8, 'offset'=>1, cat=>$options['afirstbox']) );
while ( have_posts() ) : the_post();
echo "<div class='second_bottom_category btm_ctry'><div class='s_b_c_l'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '90';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '60';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "</div><div class='s_b_c_r'><h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
/*content starts here*/
/*content ends here*/
echo "</div>";
echo "</div>";
endwhile;
wp_reset_query(); 
				
?>
</div>	
</section>
</div>
<?php
/*Right category section ends here*/
echo "</div></div></div>";

}
}
}


class newmagaz_second_category extends thesis_box{ 
protected function translate() {
$this->title = __('Newmagaz Second Category Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'firstccheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Second Category Box', 'thesis'),
'tooltip' => __('Enable Newmagaz Second Category Box', 'thesis'),
'options' => array(
'firstcoptions' => __('Enable Newmagaz Second Category Box', 'thesis'),
)
),				

'asecondbox'=>array(
'type'=>'text',
'width'=>'medium',
'label'=>__('Change the Category ID here','thesis'),
'tooltip'=>__('Here to change the Category ID','thesis'),
'default'=>'1'
),

'rdtext' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Readmore Text here', 'thesis'),
'tooltip' => __('Here to change your Readmore Text', 'thesis'),
'default' => 'Read More'),

'resizer_width1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Second Category Top Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Second Category Top Featured Image', 'thesis'),
'placeholder' => __('397', 'thesis')),

'resizer_height1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Second Category Top Featured Image', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Second Category Top Featured Image', 'thesis'),
'placeholder' => __('229', 'thesis')),

'resizer_width2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Second Category Bottom Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Second Category Bottom Featured Image', 'thesis'),
'placeholder' => __('99', 'thesis')),

'resizer_height2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Second Category Bottom Featured Image', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Second Category Bottom Featured Image', 'thesis'),
'placeholder' => __('60', 'thesis')),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['firstccheck']){
/*Second Category Id*/

echo "<div class='second_category'>".
"<div class='block_title'>".
"<a title='";
$category=get_the_category_by_id($options['asecondbox']); echo $category;
echo "'".
" href='";
$category_link = get_category_link($options['asecondbox']);
echo esc_url( $category_link );
echo "'".
"><h3 class='title_clr'>";
$category=get_the_category_by_id($options['asecondbox']); echo $category;
echo "</h3></a>".
"</div>";
/*Top category section starts here*/
echo "<div class=''>";
query_posts( array('posts_per_page'=>1, cat=>$options['asecondbox']) );
while ( have_posts() ) : the_post();

echo "<div class='second_top_category'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '397';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '229';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "<h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class='author'>". get_the_author() ."</span>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
/*content starts here*/
echo "<p>";
$excerpt=get_the_excerpt();
echo limit_words($excerpt,20);
echo "</p><div class='permalink cl-effect-10'><a href='".get_permalink()."' data-hover='". $options['rdtext'] ."'><span>". $options['rdtext'] ."</span></a></div>";
/*content ends here*/
echo "</div>";

endwhile;
wp_reset_query(); 
echo "</div>";
?>
<div>
<section>
<!-- content -->
<div class="content mCustomScrollbar">
<?php query_posts( array('posts_per_page'=>8, 'offset'=>1, cat=>$options['asecondbox']) );
while ( have_posts() ) : the_post();
echo "<div class='second_bottom_category btm_ctry'><div class='s_b_c_l'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '99';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '60';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "</div><div class='s_b_c_r'><h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
/*content starts here*/
/*content ends here*/
echo "</div>";
echo "</div>";
endwhile;
wp_reset_query(); 
				
?>
</div>	
</section>
</div>
<?php
/*Bottom category section ends here*/
echo "</div>";

}
}
}


class newmagaz_third_category extends thesis_box{ 
protected function translate() {
$this->title = __('Newmagaz Third Category Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'firstccheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Third Category Box', 'thesis'),
'tooltip' => __('Enable Newmagaz Third Category Box', 'thesis'),
'options' => array(
'firstcoptions' => __('Enable Newmagaz Third Category Box', 'thesis'),
)
),				

'asecondbox'=>array(
'type'=>'text',
'width'=>'medium',
'label'=>__('Change the Category Id','thesis'),
'tooltip'=>__('Here to change the Category ID','thesis'),
'default'=>'1'
),

'rdtext' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Readmore Text here', 'thesis'),
'tooltip' => __('Here to change your Readmore Text', 'thesis'),
'default' => 'Read More'),

'resizer_width1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Third Category Top Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Third Category Top Featured Image', 'thesis'),
'placeholder' => __('397', 'thesis')),

'resizer_height1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Third Category Top Featured Image', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Third Category Top Featured Image', 'thesis'),
'placeholder' => __('229', 'thesis')),

'resizer_width2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Third Category Bottom Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Third Category Bottom Featured Image', 'thesis'),
'placeholder' => __('99', 'thesis')),

'resizer_height2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Third Category Bottom Featured Image', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Third Category Bottom Featured Image', 'thesis'),
'placeholder' => __('60', 'thesis')),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['firstccheck']){
/*Second Category Id*/

echo "<div class='second_category righty'>".
"<div class='block_title'>".
"<a title='";
$category=get_the_category_by_id($options['asecondbox']); echo $category;
echo "'".
" href='";
$category_link = get_category_link($options['asecondbox']);
echo esc_url( $category_link );
echo "'".
"><h3 class='title_clr'>";
$category=get_the_category_by_id($options['asecondbox']); echo $category;
echo "</h3></a>".
"</div>";
/*Top category section starts here*/
echo "<div class=''>";
query_posts( array('posts_per_page'=>1, cat=>$options['asecondbox']) );
while ( have_posts() ) : the_post();

echo "<div class='second_top_category'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '397';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '229';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "<h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class='author'>". get_the_author() ."</span>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
/*content starts here*/
echo "<p>";
$excerpt=get_the_excerpt();
echo limit_words($excerpt,20);
echo "</p><div class='permalink cl-effect-10'><a href='".get_permalink()."' data-hover='". $options['rdtext'] ."'><span>". $options['rdtext'] ."</span></a></div>";
/*content ends here*/
echo "</div>";

endwhile;
wp_reset_query(); 
echo "</div>";
?>
<div>
<section>
<!-- content -->
<div class='content mCustomScrollbar'>
<?php query_posts( array('posts_per_page'=>8, 'offset'=>1, cat=>$options['asecondbox']) );
while ( have_posts() ) : the_post();
echo "<div class='second_bottom_category btm_ctry'><div class='s_b_c_l'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '99';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '60';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "</div><div class='s_b_c_r'><h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
/*content starts here*/
/*content ends here*/
echo "</div>";
echo "</div>";
endwhile;
wp_reset_query(); 
				
?>
</div>	
</section>
</div>
<?php
/*Bottom category section ends here*/
echo "</div>";

}
}
}

class newmagaz_content_advertisement extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Content Advertisement Box', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'headercheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Content Advertisement Box', 'thesis'),
'tooltip' => __('Here to Enable Newmagaz Content Advertisement Box', 'thesis'),
'options' => array(
'searchoptions' => __('Enable Newmagaz Content Advertisement Box', 'thesis'),
)
),
				
'link' => array(
'type' => 'textarea',
'width' => 'medium',
'label' => __('Paste your Newmagaz Content Advertisement Image link here', 'thesis'),
'tooltip' =>__('Here to Paste your Newmagaz Content Advertisement Image link', 'thesis'),
'default' => ''
),


);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['headercheck']){
echo "<div class='content_advertisement'>".
		"". $options['link'] ."".
	"</div>";
}
}
}

class newmagaz_fourth_category extends thesis_box{ 
protected function translate() {
$this->title = __('Newmagaz Fourth Category Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'firstccheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Fourth Category Box', 'thesis'),
'tooltip' => __('Enable Newmagaz Fourth Category Box', 'thesis'),
'options' => array(
'firstcoptions' => __('Enable Newmagaz Fourth Category Box', 'thesis'),
)
),				

'afourthbox'=>array(
'type'=>'text',
'width'=>'medium',
'label'=>__('Change the Category ID','thesis'),
'tooltip'=>__('Here to change the Category ID','thesis'),
'default'=>'1'
),

'rdtext' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Readmore Text here', 'thesis'),
'tooltip' => __('Here to change your Readmore Text', 'thesis'),
'default' => 'Read More'),

'resizer_width1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Fourth Category Top Featured image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Fourth Category Top Featured image', 'thesis'),
'placeholder' => __('350', 'thesis')),

'resizer_height1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Fourth Category Top Featured image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Fourth Category Top Featured image', 'thesis'),
'placeholder' => __('202', 'thesis')),

'resizer_width2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Fourth Category Bottom Featured image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Fourth Category Bottom Featured image', 'thesis'),
'placeholder' => __('105', 'thesis')),

'resizer_height2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Fourth Category Bottom Featured image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Fourth Category Bottom Featured image', 'thesis'),
'placeholder' => __('78', 'thesis')),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['firstccheck']){
/*Second Category Id*/

echo "<div class='fourth_category'>".
"<div class='block_title'>".
"<a title='";
$category=get_the_category_by_id($options['afourthbox']); echo $category;
echo "'".
" href='";
$category_link = get_category_link($options['afourthbox']);
echo esc_url( $category_link );
echo "'".
"><h3 class='title_clr'>";
$category=get_the_category_by_id($options['afourthbox']); echo $category;
echo "</h3></a>".
"</div>";
/*Top category section starts here*/
$i = 1;
query_posts( array('posts_per_page'=>5, cat=>$options['afourthbox']) );
while ( have_posts() ) : the_post();
if($i == 1){
echo "<div class='fourth_top_category'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '350';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '202';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "<h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class='author'>". get_the_author() ."</span>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
/*content starts here*/
echo "<p>";
$excerpt=get_the_excerpt();
echo limit_words($excerpt,15);
echo "</p><div class='permalink cl-effect-10'><a href='".get_permalink()."' data-hover='". $options['rdtext'] ."'><span>". $options['rdtext'] ."</span></a></div>";
/*content ends here*/
echo "</div><div class='fourth_btm_content'>";
}

/*Top category section ends here*/

/*Bottom category section starts here*/

else{
$j++;
$class = ( $j % 2 ) ? 'fourth_bottom_category' : 'fourth_bottom_category last'; 
echo "<div class='". $class ."'><div class='s_b_c_l'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width2']) && is_numeric($this->options["resizer_width2"]) ? $this->options['resizer_width2'] : '105';
$resizer_height = !empty($this->options['resizer_height2']) && is_numeric($this->options["resizer_height2"]) ? $this->options['resizer_height2'] : '78';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "</div><div class='s_b_c_r'><h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class='author'>". get_the_author() ."</span>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
echo "</div></div>";
}
$i++;
endwhile;
wp_reset_query(); 
/*Bottom category section ends here*/
echo "</div></div>";

}
}
}

class newmagaz_fifth_category extends thesis_box{ 
protected function translate() {
$this->title = __('Newmagaz Fifth Category Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'firstccheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Fifth Category Box', 'thesis'),
'tooltip' => __('Enable Newmagaz Fifth Category Box', 'thesis'),
'options' => array(
'firstcoptions' => __('Enable Newmagaz Fifth Category Box', 'thesis'),
)
),				

'afourthbox'=>array(
'type'=>'text',
'width'=>'medium',
'label'=>__('Change the Category ID','thesis'),
'tooltip'=>__('Here to change the Category ID','thesis'),
'default'=>'1'
),

'rdtext' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Readmore Text here', 'thesis'),
'tooltip' => __('Here to change your Readmore Text', 'thesis'),
'default' => 'Read More'),

'resizer_width1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Fifth Category Top Featured image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Fifth Category Top Featured image', 'thesis'),
'placeholder' => __('350', 'thesis')),

'resizer_height1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Fifth Category Top Featured image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Fifth Category Top Featured image', 'thesis'),
'placeholder' => __('202', 'thesis')),

'resizer_width2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Fifth Category Bottom Featured image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Fifth Category Bottom Featured image', 'thesis'),
'placeholder' => __('105', 'thesis')),

'resizer_height2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Fifth Category Bottom Featured image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Fifth Category Bottom Featured image', 'thesis'),
'placeholder' => __('78', 'thesis')),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['firstccheck']){
/*Second Category Id*/

echo "<div class='fifth_category'>".
"<div class='block_title'>".
"<a title='";
$category=get_the_category_by_id($options['afourthbox']); echo $category;
echo "'".
" href='";
$category_link = get_category_link($options['afourthbox']);
echo esc_url( $category_link );
echo "'".
"><h3 class='title_clr'>";
$category=get_the_category_by_id($options['afourthbox']); echo $category;
echo "</h3></a>".
"</div>";
/*Top category section starts here*/
$i = 1;
query_posts( array('posts_per_page'=>5, cat=>$options['afourthbox']) );
while ( have_posts() ) : the_post();
if($i == 1){
echo "<div class='fourth_top_category'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '350';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '202';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "<h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class='author'>". get_the_author() ."</span>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
/*content starts here*/
echo "<p>";
$excerpt=get_the_excerpt();
echo limit_words($excerpt,15);
echo "</p><div class='permalink cl-effect-10'><a href='".get_permalink()."' data-hover='". $options['rdtext'] ."'><span>". $options['rdtext'] ."</span></a></div>";
/*content ends here*/
echo "</div><div class='fourth_btm_content'>";
}

/*Top category section ends here*/

/*Bottom category section starts here*/

else{
$j++;
$class = ( $j % 2 ) ? 'fourth_bottom_category' : 'fourth_bottom_category last'; 
echo "<div class='". $class ."'><div class='s_b_c_l'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width2']) && is_numeric($this->options["resizer_width2"]) ? $this->options['resizer_width2'] : '105';
$resizer_height = !empty($this->options['resizer_height2']) && is_numeric($this->options["resizer_height2"]) ? $this->options['resizer_height2'] : '78';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "</div><div class='s_b_c_r'><h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class='author'>". get_the_author() ."</span>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/
echo "</div></div>";
}
$i++;
endwhile;
wp_reset_query(); 
/*Bottom category section ends here*/
echo "</div></div>";

}
}
}

class newmagaz_sixth_category extends thesis_box{ 
protected function translate() {
$this->title = __('Newmagaz Sixth Category Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'firstccheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Sixth Category Box', 'thesis'),
'tooltip' => __('Enable Newmagaz Sixth Category Box', 'thesis'),
'options' => array(
'firstcoptions' => __('Enable Newmagaz Sixth Category Box', 'thesis'),
)
),				

'asixthbox'=>array(
'type'=>'text',
'width'=>'medium',
'label'=>__('Change the Category ID','thesis'),
'tooltip'=>__('Here to change the Category ID','thesis'),
'default'=>'1'
),

'rdtext' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Readmore Text here', 'thesis'),
'tooltip' => __('Here to change your Readmore Text', 'thesis'),
'default' => 'Read More'),

'resizer_width1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Sixth Category Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Sixth Category Featured Image', 'thesis'),
'placeholder' => __('244', 'thesis')),

'resizer_height1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Sixth Category Featured Image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Sixth Category Featured Image', 'thesis'),
'placeholder' => __('141', 'thesis')),

);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['firstccheck']){
/*Second Category Id*/

echo "<div class='sixth_category'>".
"<div class='block_title'>".
"<a title='";
$category=get_the_category_by_id($options['asixthbox']); echo $category;
echo "'".
" href='";
$category_link = get_category_link($options['asixthbox']);
echo esc_url( $category_link );
echo "'".
"><h3 class='title_clr'>";
$category=get_the_category_by_id($options['asixthbox']); echo $category;
echo "</h3></a>".
"</div>";
echo"<div class='sixth_category_inner'>";
/*Top category section starts here*/
$i = 1;
query_posts( array('posts_per_page'=>3, cat=>$options['asixthbox']) );
while ( have_posts() ) : the_post();
if($i++){
$class = ( $i % 3 ) ? 'sixth_top_category' : 'sixth_top_category last'; 
echo "<div class='". $class ."'>";
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '244';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '141';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/ 
/*Heading Starts here*/
echo "<h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>".
/*Heading ends here*/
/*Byline starts here*/
"<div class='byline'>".
"<span class='author'>". get_the_author() ."</span>".
"<span class=date>". get_the_time('M jS, Y') ."</span>";?>
<div class="info-comment"><i class="fa fa-comment"></i>
<a  href="<?php the_permalink(); ?>#comments" title="<?php comments_number(__('0','fb'),__('1 ','periodic'),__('% ','fb')); ?>"><?php comments_number(__('0','periodic'),__('1 ','periodic'),__('%','fb')); ?></a>
</div><?php
echo"</div>";
/*Byline ends here*/

echo "</div>";
}
$i++;
endwhile;
wp_reset_query(); 
/*Top category section ends here*/
echo "</div></div>";
}
}
}

class newmagaz_seventh_category extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Seventh Category Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'firstccheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Seventh Category Box', 'thesis'),
'tooltip' =>(__('Enable Newmagaz Seventh Category Box', 'thesis')),
'options' => array(
'firstcoptions' => __('Enable Newmagaz Seventh Category Box', 'thesis'),
)
),				

'cfirstbox'=>array(
'type'=>'text',
'width'=>'medium',
'label'=>__('Change the Category ID','thesis'),
'tooltip'=>__('Here to change the Category ID','thesis'),
'default'=>'1'
),

'resizer_width1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Seventh Category Left Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Seventh Category Left Featured Image', 'thesis'),
'placeholder' => __('470', 'thesis')),

'resizer_height1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Seventh Category Left Featured Image', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Seventh Category Left Featured Image', 'thesis'),
'placeholder' => __('326', 'thesis')),

'resizer_width2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Seventh Category Right Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Seventh Category Right Featured Image', 'thesis'),
'placeholder' => __('324', 'thesis')),

'resizer_height2' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Seventh Category Right Featured Image', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Seventh Category Right Featured Image', 'thesis'),
'placeholder' => __('156', 'thesis')),

);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['firstccheck']){
/*First Category Id*/
echo "<div class='seventh_category'>".
"<div class='category_seven'>";
$i=1;
query_posts( array('posts_per_page'=>3, cat=>$options['cfirstbox']) );
while ( have_posts() ) : the_post();
if($i == 1){
echo "<div class='catseven_left cat_seven'><div class='category_first_img'>";

// Defaults
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '470';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '326';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";  
} 
echo "</div>".
"<div class='category_seven_left_cont'>".
"<div class='contentss'>".
"<div class='cblock_title'>".
"<a title='";
$category=get_the_category_by_id($options['cfirstbox']); echo $category;
echo "'".
" href='";
$category_link = get_category_link($options['cfirstbox']);
echo esc_url( $category_link );
echo "'".
"><h3>";
$category=get_the_category_by_id($options['cfirstbox']); echo $category;
echo "</h3></a>".
"</div>".
"<div class='category_seven_title'><h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4></div>".
"<div class='cat_byline '>".
"</div>".
" </div></div></div>";
}


else {

echo "<div class='c_right_top c_right cat_seven'><div class='category_first_img'>";

// Defaults
$resizer_width = !empty($this->options['resizer_width2']) && is_numeric($this->options["resizer_width2"]) ? $this->options['resizer_width2'] : '324';
$resizer_height = !empty($this->options['resizer_height2']) && is_numeric($this->options["resizer_height2"]) ? $this->options['resizer_height2'] : '156';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";  
} 
echo "</div>".
"<div class='category_seven_top_cont linebg'>".
"<div class='contentss'>".
"<div class='cblock_title'>".
"<a title='";
$category=get_the_category_by_id($options['cfirstbox']); echo $category;
echo "'".
" href='";
$category_link = get_category_link($options['cfirstbox']);
echo esc_url( $category_link );
echo "'".
"><h3>";
$category=get_the_category_by_id($options['cfirstbox']); echo $category;
echo "</h3></a>".
"</div>".
"<div class='category_seven_title'><h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4></div>";

echo "</div></div></div>";
}

$i++;
endwhile;
wp_reset_query(); 
echo "</div>".
"</div>";
}
}
}

class newmagaz_random_box extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Random Post Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'randomcheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Random Post Box', 'thesis'),
'tooltip' => __('Enable Newmagaz Random Post Box', 'thesis'),
'options' => array(
'randomoptions' => __('Enable Newmagaz Random Post Box', 'thesis'),
)
),				

);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['randomcheck']){?>

<div class='demo_container'>
<div class='block_title'><h3 class='title_clr'>Random Post</h3></div>
<div id='owl-demo' class='owl-carousel'>

<?Php
query_posts( array('posts_per_page' => 10, 'post_status'=>"publish",'post_type'=>"post",'orderby'=>"rand",'order'=>"desc") );
while ( have_posts() ) : the_post();
?>
<div class="item">
<?php
// Defaults Feature image starts here
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '377';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '301';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"><div class='image_hover'></div></a>\n".
"</div>\n";  
}
/*featured image ends here*/
?>

<?php
$category = get_the_category(); 
?>
<h5 class='cat_title'><a href='<?php echo get_category_link($category[0]->cat_ID) ?>'><?php echo $category[0]->cat_name; ?></a></h5>

<?php
echo "<h4><a href='". get_permalink() ."'>".
get_the_title() ."".
"</a></h4>";
?>
</div>

<?php
endwhile;
wp_reset_query();
?>                
</div>
</div>
<?php
}
}
}

class newmagaz_popular_posts extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Popular Posts Box', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'popularcheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Popular Posts Box', 'thesis'),
'tooltip' => __('Here to Enable Newmagaz Popular Posts Box', 'thesis'),
'options' => array(
'popularoptions' => __('Enable Newmagaz Popular Posts Box', 'thesis'),
)
),

'title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Popular Post Title here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Popular Post Title', 'thesis'),
'default' => 'Popular Posts'
),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['popularcheck']){?>
<div class='popular_posts widget'>
<div class='block_title'>
<h3 class='widget_title title_clr'><?php echo $options['title']; ?></h3>
</div>
<?php
query_posts('post_type=post&posts_per_page=4&orderby=comment_count&order=DESC');
while (have_posts()): the_post(); 
$i++;
$class = ( $i % 4 ) ? 'popular' : 'popular last'; 
?>
<div class='<?php echo $class; //Output the start class?>'><?php
// Defaults
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '100';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '80';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";  
} ?>
<?php
$category = get_the_category(); 
?>
<div class='inner_popular'>
<h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
<div class='byline'>
<span><?php the_time('M jS, Y'); ?></span>

</div>

</div>
</div>
<?php
endwhile;
wp_reset_query();
?>
</div>
<?php
}
}
}

class newmagaz_recently_updated_posts extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Recently Updated Post Box', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'popularcheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Recently Updated Post Box', 'thesis'),
'tooltip' => __('Here to Enable Newmagaz Recently Updated Post Box', 'thesis'),
'options' => array(
'popularoptions' => __('Enable Newmagaz Recently Updated Post Box', 'thesis'),
)
),

'title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Recently Updated Post Title here', 'thesis'),
'tooltip' => __('Here to change your Recently Updated Post Title', 'thesis'),
'default' => 'Recently Updated Posts'
),

);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['popularcheck']){?>
<div class='recently_updated_posts widget'>
<div class='block_title'>
<h3 class='widget_title title_clr'><?php echo $options['title']; ?></h3>
</div>
<?php
function wpb_lastupdated_posts() { 
// Query Arguments
$lastupdated_args = array(
'orderby' => 'modified',

);

//Loop to display 5 recently updated posts
$lastupdated_loop = new WP_Query( $lastupdated_args );
$counter = 1;
echo '<ul>';
while( $lastupdated_loop->have_posts() && $counter <= 5 ) : $lastupdated_loop->the_post();
echo '<li><a href="' . get_permalink( $lastupdated_loop->post->ID ) . '"> ' .get_the_title( $lastupdated_loop->post->ID ) . '</a> ( '. get_the_modified_date() .') </li>';
$counter++;
endwhile; 
echo '</ul>';
wp_reset_postdata(); 
}

if (function_exists(wpb_lastupdated_posts)) : 
wpb_lastupdated_posts();
endif;

?>
</div>
<?php
}
}
}

class newmagaz_social_follow extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Social Follow', 'thesis');
}

protected function options() {
global $thesis;
return array(
'fb' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Facebook URL Link', 'thesis'),
'tooltip' => __('Here to paste your Facebook Page URL Link', 'thesis'),
'default' => ''
),
'twitter' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Twitter URL Link', 'thesis'),
'tooltip' =>__('Here to paste your Twitter Page URL Link', 'thesis'),
'default' => ''
),
'rss' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your RSS feed URL Link', 'thesis'),
'tooltip' => __('Here to paste your RSS feed Page URL Link', 'thesis'),
'default' => ''
),
'linkedin' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Linkedin URL Link', 'thesis'),
'tooltip' => __('Here to paste your Linkedin page URL Link', 'thesis'),
'default' => ''
),
'youtube' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Youtube URL Link', 'thesis'),
'tooltip' => __('Here to paste your Youtube Page URL Link', 'thesis'),
'default' => ''
),
'pinterest' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Pinterest URL Link', 'thesis'),
'tooltip' =>__('Here to paste your Pinterest Page URL Link', 'thesis'),
'default' => ''
),
'google' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Google Plus URL Link', 'thesis'),
'tooltip' => __('Here to paste your Google Plus Page URL Link', 'thesis'),
'default' => ''
),	

'vimeo' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Vimeo-Square URL Link', 'thesis'),
'tooltip' => __('Here to paste your Vimeo-Square Page URL Link', 'thesis'),
'default' => ''
),

'tumblr' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Tumblr URL Link', 'thesis'),
'tooltip' => __('Here to paste your Tumblr Page URL Link', 'thesis'),
'default' => ''
),

'dribbble' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Dribbble URL Link', 'thesis'),
'tooltip' => __('Here to paste your Dribbble Page URL Link', 'thesis'),
'default' => ''
),


'flickr' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Paste your Flickr URL link', 'thesis'),
'tooltip' => __('Here to paste your Flickr Page URL Link', 'thesis'),
'default' => ''
),
	
'scheck' => array(
'type' => 'checkbox',
'label' => __('Disable Social Share Icons ', 'thesis'),
'tooltip' => __('If you want to remove Social Follow Icons please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Social Share Icon', 'thesis'),
)
),
'f1check' => array(
'type' => 'checkbox',
'label' => __('Disable Facebook Icons  ', 'thesis'),
'tooltip' =>__('If you want to remove Facebook Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Facebook Icon', 'thesis'),
)
),
't1check' => array(
'type' => 'checkbox',
'label' => __('Disable Twitter Icons  ', 'thesis'),
'tooltip' => __('If you want to remove Twitter Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Twitter Icon', 'thesis'),
)
),
'r1check' => array(
'type' => 'checkbox',
'label' => __('Disable Rss Feed Icons  ', 'thesis'),
'tooltip' => __('If you want to remove Rss Feed Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Rss Feed Icon', 'thesis'),
)
),
'l1check' => array(
'type' => 'checkbox',
'label' => __('Disable Linkedin Icons  ', 'thesis'),
'tooltip' => __('If you want to remove Linkedin Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Linkedin Icon', 'thesis'),
)
),
'y1check' => array(
'type' => 'checkbox',
'label' => __('Disable Youtube Icons  ', 'thesis'),
'tooltip' => __('If you want to remove Youtube Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Youtube Icon', 'thesis'),
)
),
'p1check' => array(
'type' => 'checkbox',
'label' => __('Disable Pinterest Icons  ', 'thesis'),
'tooltip' =>__('If you want to remove Pinterest Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Pinterest Icon', 'thesis'),
)
),
'g1check' => array(
'type' => 'checkbox',
'label' => __('Disable Google Plus Icons  ', 'thesis'),
'tooltip' => __('If you want to remove Google Plus Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Google Plus Icon', 'thesis'),
)
),	

'v1check' => array(
'type' => 'checkbox',
'label' => __('Disable Vimeo-Square  Icons  ', 'thesis'),
'tooltip' => __('If you want to remove Vimeo-Square Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Vimeo-Square Icon', 'thesis'),
)
),

'tum1check' => array(
'type' => 'checkbox',
'label' => __('Disable Tumblr Icons  ', 'thesis'),
'tooltip' => __('If you want to remove Tumblr Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Iumblr Icon', 'thesis'),
)
),

'drb1check' => array(
'type' => 'checkbox',
'label' => __('Disable Dribbble Icons  ', 'thesis'),
'tooltip' => __('If you want to remove Dribbble Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Dribbble Icon', 'thesis'),
)
),

'flic1check' => array(
'type' => 'checkbox',
'label' => __('Disable Flickr  Icons  ', 'thesis'),
'tooltip' => __('If you want to remove Flickr Icon please select this checkbox', 'thesis'),
'options' => array(
'soption' => __('Disable Flickr Icon', 'thesis'),
)
),
	
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);	
if(!$options['scheck']){
echo "<div class='social_widgets widget'>";
echo "<div class='block_title'>".
"<h3 class='widget_title title_clr'>Social Follow</h3>".
"</div>";
if(!$options['f1check']){
echo "<div class='social_follow' id='facebook'>
<a title='Facebook' href='". $options['fb'] ."' target='_blank'>
<i class='fa fa-facebook'></i>
</a>
</div>";
}
if(!$options['t1check']){
echo "<div class='social_follow' id='twitter'>
<a title='Twitter' href='". $options['twitter'] ."' target='_blank'>
<i class='fa fa-twitter'></i>
</a>
</div>";
}
if(!$options['r1check']){
echo "<div class='social_follow' id='rss'>
<a title='Rss Feed' href='". $options['rss'] ."' target='_blank'>
<i class='fa fa-rss'></i>
</a>
</div>";
}
if(!$options['l1check']){
echo "<div class='social_follow' id='linkedin'>
<a title='Linkedin' href='". $options['linkedin'] ."' target='_blank'>
<i class='fa fa-linkedin'></i>
</a>
</div>";
}
if(!$options['y1check']){
echo "<div class='social_follow' id='youtube'>
<a title='Youtube' href='". $options['youtube'] ."' target='_blank'>
<i class='fa fa-youtube'></i>
</a>
</div>";
}
if(!$options['p1check']){
echo "<div class='social_follow' id='pinterest'>
<a title='Pinterest' href='". $options['pinterest'] ."' target='_blank'>
<i class='fa fa-pinterest'></i>
</a>
</div>";
}
if(!$options['g1check']){
echo "<div class='social_follow' id='google'>
<a title='Google Plus' href='". $options['google'] ."' target='_blank'>
<i class='fa fa-google-plus'></i>
</a>
</div>";
}

if(!$options['v1check']){
echo "<div class='social_follow' id='vimeo-square'>
<a title='vimeo-square ' href='". $options['vimeo'] ."' target='_blank'>
<i class='fa fa-vimeo'></i>
</a>
</div>";
}

if(!$options['tum1check']){
echo "<div class='social_follow' id='tumblr'>
<a title='tumblr' href='". $options['tumblr'] ."' target='_blank'>
<i class='fa fa-tumblr'></i>
</a>
</div>";
}

if(!$options['drb1check']){
echo "<div class='social_follow' id='dribbble'>
<a title='dribbble' href='". $options['dribbble'] ."' target='_blank'>
<i class='fa fa-dribbble'></i>
</a>
</div>";
}

if(!$options['flic1check']){
echo "<div class='social_follow' id='flickr'>
<a title='flickr' href='". $options['flickr'] ."' target='_blank'>
<i class='fa fa-flickr'></i>
</a>
</div>";
}

echo "</div>";
}
}
}

class newmagaz_recent_comments_box extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Recent Comments Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'recentcheck' => array(
'type' => 'checkbox',
'label' => __('Enable Recent Comments Box', 'thesis'),
'tooltip' => __('Enable Recent Comments Box', 'thesis'),
'options' => array(
'recentoptions' => __('Enable Recent Comments Box', 'thesis'),
)
),

'width' => array(
'type' => 'text',
'width' => 'short',
'label' => __('Change the Width of Comments Avatar Image', 'thesis'),
'tooltip' => __('Here to change the Width of Comments Avatar Image', 'thesis'),
'default' => '50'
),				
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['recentcheck']){
global $wpdb;
$query = "SELECT * from $wpdb->comments WHERE comment_approved= '1'
ORDER BY comment_date DESC LIMIT 0 ,5";
$comments = $wpdb->get_results($query);

if ($comments) {
echo '<div class="recent_comments widget"><div class="block_title"><h3 class="widget_title title_clr">Recent Comments</h3></div>';
foreach ($comments as $comment) {
$url = '<a href="'. get_permalink($comment->comment_post_ID).'#comment-'.$comment->comment_ID .'" title="'.$comment->comment_author .' | '.get_the_title($comment->comment_post_ID).'">';
$img_w=''. $options['width'] .'';
echo '<div class="avt_rec">';
echo '<div class="avt_img">';
echo $url;
echo get_avatar( $comment->comment_author_email, $img_w);
echo '</a></div>';

echo '<div class="rec_aut">';
echo $url;
echo $comment->comment_author;
echo '<br>';
echo get_the_title($comment->comment_post_ID);
echo '</a></div>';
echo '</div>';
}
echo '</div>';
}

}
}
}

class newmagaz_photostream_box extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Photo Stream Box', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'popularcheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Photo Stream Box', 'thesis'),
'tooltip' => __('Here to Enable Newmagaz Photo Stream Box', 'thesis'),
'options' => array(
'popularoptions' => __('Enable Newmagaz Photo Stream Box', 'thesis'),
)
),

'title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Photo Stream Title here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Photo Stream Title', 'thesis'),
'default' => 'Newsimg Posts'
),

'resizer_width1'=>array(
'type'=>'medium',
'width'=>'long',
'label'=>__('You can change the width size if you increase/decrease the layout','thesis'),
'tooltip'=>__('Here You can change the width size if you increase/decrease the layout','thesis'),
'default'=>'104'
),

'resizer_height1'=>array(
'type'=>'medium',
'width'=>'long',
'label'=>__('You can change the width size if you increase/decrease the layout','thesis'),
'tooltip'=>__('Here You can change the width size if you increase/decrease the layout','thesis'),
'default'=>'76'
),
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['popularcheck']){?>
<div class='newsimg_posts widget'>
<div class='block_title'>
<h3 class='widget_title title_clr'><?php echo $options['title']; ?></h3>
</div>
<?php
query_posts( array('posts_per_page'=>9) );
while ( have_posts() ) : the_post();
$i++;
$class = ( $i % 3 ) ? 'newsimg' : 'newsimg last'; 
?>
<div class='<?php echo $class; //Output the start class?>'><?php
// Defaults
$resizer_width = !empty($this->options['resizer_width1']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '104';
$resizer_height = !empty($this->options['resizer_height1']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '76';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';
// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );
// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );
if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";
elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";  
} ?>
<?php
$category = get_the_category(); 
?>

</div>
<?php
endwhile;
wp_reset_query();
?>
</div>
<?php
}
}
}

class newmagaz_sidebar_optin_box extends thesis_box {	
protected function translate() {
$this->title = __('Newmagaz Sidebar Optin box', 'thesis');
}

protected function construct() {
wp_enqueue_script('newmagaz_sidebar-optin', THESIS_USER_URL . "/skins/newmagaz/lib/script.js", array('thesis-options'), $thesis->version, true);
}
	
protected function options() {
global $thesis;
return array(
'optincheck' => array(
'type' => 'checkbox',
'label' => __('Display Newmagaz Sidebar Optin Box', 'thesis'),
'options' => array(
'optinchecktext' => __('Click here to enable Newmagaz Sidebar Optin Box', 'thesis'),
),
'default' => array(
'optinchecktext' => false,
'html'	=> ''
)
),

'optin_code' => array(
'type' => 'textarea',
'width' => 'long',
'label' => __('Paste your HTML Code', 'thesis'),
'tooltip' => __('Here to paste your HTML Code', 'thesis'),
'default' => ''
),

'optin_name' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Form name ', 'thesis'),
'tooltip' => __('Name will automatically fetch after putting html code', 'thesis'),
'default' => 'Enter your name'
),

'optin_email' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Form email ', 'thesis'),
'tooltip' => __('Email will automatically fetch after putting html code', 'thesis'),
'default' => 'Enter your Email'
),
	
'optin_url' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Form action url ', 'thesis'),
'tooltip' => __('Action url will automatically fetch after putting html code', 'thesis'),
'default' => '#'
),

'optin_hidden' => array(
'type' => 'textarea',
'width' => 'long',
'label' => __('Hidden fields', 'thesis'),
'tooltip' => __('Hidden fields will automatically fetch after putting html code)', 'thesis'),
'default' => ''
),

'optin_header' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Enter your Optin Header Text', 'thesis'),
'tooltip' => __('Here to enter your Optin Header Text', 'thesis'),
'placeholder' => 'Subscribe Me'
),

'name_text' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Change your Enter your Name Text here', 'thesis'),
'tooltip' => __('Here to Change your Enter your Name Text', 'thesis'),
'placeholder' => 'Enter your name'
),
				
'email_text' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Change your Enter your Email Text here', 'thesis'),
'tooltip' => __('Here to Change your Enter your Email Text', 'thesis'),
'placeholder' => 'Enter your email'
),

'submit_text' => array(
'type' => 'text',
'width' => 'long',
'label' => __('Change your Subscribe Me Button Text', 'thesis'),
'tooltip' => __('Here to Change your Subscribe Me Button Text', 'thesis'),
'default' => 'Subscribe me'
),
			
);
}

public function html() {
global $thesis;
// get options
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['optincheck']){
echo "<div class=\"newmagaz_sb_optin_box widget\">".
"<div class=\"sb_newmagaz_optin\">".
"<div class=\"block_title\"><h3 class=\"widget_title title_clr\">". $options['optin_header'] ."</h3></div>".	
"<form method=\"post\" class=\"form\" action=\"". stripslashes($options['optin_url']) ."\" target=\"_blank\">".
"<div class=\"names\"><input class=\"name\" type=\"text\" name=\"". stripslashes($options['optin_name']) ."\" placeholder=\"". stripslashes($options['name_text']) ."\"/><div class=\"admins\"></div></div>".
"<div class=\"names\"><input class=\"email\" type=\"text\" name=\"". stripslashes($options['optin_email']) ."\" placeholder=\"". stripslashes($options['email_text']) ."\"/><div class=\"mails\"></div></div>".
"". stripslashes($options['optin_hidden']) ."".
"<input name=\"submit\" class=\"submit\" type=\"submit\" value=\"". stripslashes($options['submit_text']) ."\"/>".
"</form>".
"</div>".
"</div>";
}
}
}

class newmagaz_social_sharing_box extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Single Page Social Sharing Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'sharecheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Single Page Social Sharing Box', 'thesis'),
'tooltip' => __('Here to enable Newmagaz Single Page Social Sharing Box', 'thesis'),
'options' => array(
'socialcheckoptions' => __('Enable Newmagaz Single Page Social Sharing Box', 'thesis'),
)
),

'title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Single Page Social Sharing Title here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Single Page Social Sharing Title', 'thesis'),
'default' => 'Sharings'
),

);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if($options['sharecheck']){?>
<div class="social_sharing">
<div class='block_title'>
<h3 class='widget_title title_clr'><?php echo $options['title']; ?></h3>
</div>

<ul>
<li class="sharing share_tweet">
<a href="http://twitter.com/share?text=<?php echo htmlspecialchars(urlencode(html_entity_decode(get_the_title(), ENT_COMPAT, 'UTF-8')), ENT_COMPAT, 'UTF-8'); ?>&amp;url=<?php the_permalink(); ?>" target="_blank">
<i class="icon-twitter"></i>
<span>Twitter</span>
</a>
</li>
<li class="sharing share_fb">
<a href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>&amp;t=<?php echo htmlspecialchars(urlencode(html_entity_decode(get_the_title(), ENT_COMPAT, 'UTF-8')), ENT_COMPAT, 'UTF-8'); ?>" target="_blank">
<i class="icon-facebook"></i>
<span>Facebook</span>
</a>
</li>
<li class="sharing share_plus">
<a href="https://plus.google.com/share?url=<?php the_permalink(); ?>" target="_blank" title="Click to share">
<i class="icon-googleplus"></i>
<span>Google+</span>
</a>
</li>
<li class="sharing share_linkedin">
<a target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php the_permalink(); ?>">
<i class="icon-linkedin"></i>
<span>Linkedin</span>
</a>
</li>
<li class="sharing share_stumble">
<a target="_blank" href="http://www.stumbleupon.com/submit?url=<?php the_permalink(); ?>">
<i class="icon-stumbleupon"></i>
<span>Stumbleupon</span>
</a>
</li>
<li class="sharing share_reddit">
<a target="_blank" href="http://www.reddit.com/submit?url=<?php the_permalink(); ?>&amp;title=<?php echo htmlspecialchars(urlencode(html_entity_decode(get_the_title(), ENT_COMPAT, 'UTF-8')), ENT_COMPAT, 'UTF-8'); ?>">
<i class="icon-reddit"></i>
<span>Reddit</span>
</a>
</li>
</ul>
</div>
<?php
}
}
}


class newmagaz_page_navigation extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Page Navigation', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'paginationcheck' => array(
'type' => 'checkbox',
'label' => __('Display Page Navigation', 'thesis'),
'options' => array(
'nav1rchecktext' => __('Click here to Enable Page Navigation', 'thesis'),
),
'default' => array(
'paginationchecktext' => false,
'html'	=> ''
)
),			
);
}
	
public function html() {
global $thesis, $paged, $wp_query;
$range = 2;
$showitems = ($range * 2)+1; 
if(empty($paged)) $paged = 1;
if($pages == '')
{
$pages = $wp_query->max_num_pages;
if(!$pages)
{
$pages = 1;
}
}  
if(1 != $pages)
{
echo "<div class=\"newpagination\">";		 
if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>Older &laquo; First</a>";
if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo; Previous</a>";
for ($i=1; $i <= $pages; $i++)
{
if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
{
echo ($paged == $i)? "<span class=\"current\">".$i."</span>":"<a href='".get_pagenum_link($i)."' class=\"inactive\">".$i."</a>";
}
}
if ($paged < $pages && $showitems < $pages) echo "<a href=\"".get_pagenum_link($paged + 1)."\">Newer &rsaquo;</a>"; 
if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>Last &raquo;</a>";
echo "</div>\n";
}
}
}


class newmagaz_related_box extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz Related Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'relatedcheck' => array(
'type' => 'checkbox',
'label' => __('Enable Newmagaz Related Post Box  ', 'thesis'),
'tooltip' => __('If you want to enable Newmagaz Related Post Box please select the checkbox', 'thesis'),
'options' => array(
'soption' => __('Enable Newmagaz Related Post Box', 'thesis'),
)
),

'title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz Related Post  Title here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz Related Post Title', 'thesis'),
'default' => 'Related Posts'
),

'resizer_width1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Width for Newmagaz Related Post Featured Image', 'thesis'),
'tooltip' => __('Set the width for Newmagaz Related Post Featured Image', 'thesis'),
'placeholder' => __('256', 'thesis')),

'resizer_height1' => array (
'type' => 'text',
'width' => 'medium',
'label' => __('Height for Newmagaz Related Post Featured Image.', 'thesis'),
'tooltip' => __('Set the height for Newmagaz Related Post Featured Image', 'thesis'),
'placeholder' => __('148', 'thesis')),
);
}
	
public function html() {
global $thesis;
global $post;
$options = $thesis->api->get_options($this->options(), $this->options);
$ads .= '<div class="thesis_related">';
if ( $options['relatedcheck'] ) {
if(!is_archive()){
$tags = get_the_tags($post->ID);
if ($tags) {
$tag_ids = array();
foreach($tags as $individual_tag) $tag_ids[] = $individual_tag->term_id;
$args=array(
'tag__in' => $tag_ids,
'post__not_in' => array($post->ID),
'showposts'=>3,  // Number of related posts that will be shown.
'caller_get_posts'=>1
);
$my_query = new wp_query($args);
if( $my_query->have_posts() ) {
echo '<div class="main_related_posts">'.
'<div class="block_title">'.
'<h3 class="widget_title title_clr"> '. $options["title"] .' </h3>'.
'</div>';
echo '<div class="newmagaz_related_box">';
while ($my_query->have_posts()) {
$i++;
$class = ( $i % 3 ) ? 'related_posts' : 'related_posts  last';
$my_query->the_post(); ?>
<div class='<?php echo $class; //Output the start class?>'><?php
echo '<div class="thumbnail">';
// Defaults
$resizer_width = !empty($this->options['resizer_width']) && is_numeric($this->options["resizer_width1"]) ? $this->options['resizer_width1'] : '256';
$resizer_height = !empty($this->options['resizer_height']) && is_numeric($this->options["resizer_height1"]) ? $this->options['resizer_height1'] : '148';
$class = !empty($this->options['class']) ? $this->options['class'] : 'featured_image';

// Auto feature image defaults
$thumb = get_post_thumbnail_id(); 
$img_url = wp_get_attachment_url( $thumb,'full' ); 
$image = aq_resize( $img_url, $resizer_width, $resizer_height, true );

// Catch the Image defaults
$catch_img_url = catch_that_image( $thumb,'full' );
$catch_image = aq_resize( $catch_img_url, $resizer_width, $resizer_height, true );

if(has_post_thumbnail())
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";

elseif (catch_that_image()){ 
echo
"<div class=\"" . esc_attr($class) . "\">\n".
"<a class=\"featured_image_link\" href=\"" . get_permalink() . "\" title=\"" . get_the_title() . "\"><img src=\"" . $catch_image . "\" width=\"" . $resizer_width . "\" height=\"" . $resizer_height . "\" alt=\"" . get_the_title() . "\"></a>\n".
"</div>\n";  
} 
echo '<div class="related_posts_title">'.
'<h4><a href="'. get_the_permalink() .'">'. get_the_title() .'</a></h4>'.
'</div>';?>
<div class="byline">
<span><?php the_time('M jS, Y'); ?></span>

</div><?php
echo'</div>'.
'</div>';
}			
echo '</div></div>';
}
}
$post = $backup;
wp_reset_query();
echo '<div class="clear"></div>';
}}
if ( $options['html'] ) {
$ads .= stripslashes ($options['html']);
}
$ads .= '</div>';
echo $ads;
}
}


class newmagaz_404_errorpage extends thesis_box {
protected function translate() {
$this->title = __('Newmagaz 404 Error Page', 'thesis');
}
	
protected function options() {
global $thesis;
return array(
'headercheck' => array(
'type' => 'checkbox',
'label' => __('Disable Newmagaz 404 Error Page', 'thesis'),
'tooltip' => __('Here to Disable Newmagaz 404 Error Page', 'thesis'),
'options' => array(
'searchoptions' => __('Disable Newmagaz 404 Error Page', 'thesis'),
)
),
'error_title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz 404 Error Title here', 'thesis'),
'tooltip' => __('Here to change your Newmagaz 404 Error Title', 'thesis'),
'default' => 'ERROR! PAGE NOT FOUND'
),	
'content' => array(
'type' => 'textarea',
'width' => 'long',
'label' => __('Change your Newmagaz 404 Error Content here', 'thesis'),
'tooltip' => __('Here to Change your Newmagaz 404 Error Content ', 'thesis'),
'default' => ''
),

'home_title' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Change your Newmagaz 404 Error Home Title here', 'thesis'),
'tooltip' => __('Here to Change your Newmagaz 404 Error Home Title ', 'thesis'),
'default' => ''
),
			
);
}

public function html() {
global $thesis;
$options = $thesis->api->get_options($this->options(), $this->options);
if(!$options['headercheck']){
echo "<div class='error_page'>".
"<h2>". "". $options['error_title'] ."". "</h2>".
"<p>". "". $options['content'] .""."</p>".
"<a title='". get_bloginfo('name') ."' href='". get_bloginfo('wpurl') ."'>".
"". $options['home_title'] ."".
"</a>";
echo "</div>";
}
}
}

class newmagaz_breadcrumbs extends thesis_box{
protected function translate() {
$this->title = __('Newmagaz Breadcrumbs Box', 'thesis');
}

protected function options() {
global $thesis;
return array(
'home' => array(
'type' => 'text',
'width' => 'medium',
'label' => __('Text of the Home link', 'thesis'),
'tooltip' => __('Enter text of the Home link you would like to show', 'thesis'),
'default' => 'Home'
),
);
}

public function html() {
global $thesis, $post;
// Options
$options = $thesis->api->get_options($this->options(), $this->options);
$home = !empty($this->options['home']) ? $this->options['home'] : 'Home'; // text for the 'Home' link     
$before = !empty($this->options['before']) ? $this->options['before'] : '<span class="current">'; // tag before the current crumb
$after = !empty($this->options['after']) ? $this->options['after'] : '</span>'; // tag after the current crumb
	   
$showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
$showOnHome = 1; // 1 - show breadcrumbs on the homepage, 0 - don't show
$homeLink = get_bloginfo('url');
 
if (is_home() || is_front_page()) {
if ($showOnHome == 1) echo '<div class="breadcrumbs"><a class="active" href="' . $homeLink . '">' . $home . '</a></div>';
} else {
echo '<div class="breadcrumbs"><a class="active" href="' . $homeLink . '">' . $home . '</a> ';
	 
if ( is_category() ) {
$thisCat = get_category(get_query_var('cat'), false);
if ($thisCat->parent != 0) echo get_category_parents($thisCat->parent, TRUE, ' ');
 echo $before . '' . single_cat_title('', false) . '' . $after;
} elseif ( is_search() ) {
echo $before . 'Search results for "' . get_search_query() . '"' . $after;
} elseif ( is_day() ) {
echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ';
echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ';
echo $before . get_the_time('d') . $after;
} elseif ( is_month() ) {
 echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ';
echo $before . get_the_time('F') . $after;
} elseif ( is_year() ) {
echo $before . get_the_time('Y') . $after;
} elseif ( is_single() && !is_attachment() ) {
if ( get_post_type() != 'post' ) {
$post_type = get_post_type_object(get_post_type());
$slug = $post_type->rewrite;
echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a>';
if ($showCurrent == 1) echo ' ' . $before . get_the_title() . $after;
} else {
$cat = get_the_category(); $cat = $cat[0];
$cats = get_category_parents($cat, TRUE, ' ');
if ($showCurrent == 0) $cats = preg_replace("#^(.+)\s$#", "$1", $cats);
echo $cats;
if ($showCurrent == 1) echo $before . get_the_title() . $after;
}
} elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
$post_type = get_post_type_object(get_post_type());
echo $before . $post_type->labels->singular_name . $after;
} elseif ( is_attachment() ) {
$parent = get_post($post->post_parent);
$cat = get_the_category($parent->ID); $cat = $cat[0];
echo get_category_parents($cat, TRUE, ' ');
echo '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a>';
if ($showCurrent == 1) echo ' ' . $before . get_the_title() . $after;
} elseif ( is_page() && !$post->post_parent ) {
if ($showCurrent == 1) echo $before . get_the_title() . $after;
} elseif ( is_page() && $post->post_parent ) {
$parent_id  = $post->post_parent;
$breadcrumbs = array();
while ($parent_id) {
$page = get_page($parent_id);
$breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
$parent_id  = $page->post_parent;
}
$breadcrumbs = array_reverse($breadcrumbs);
for ($i = 0; $i < count($breadcrumbs); $i++) {
echo $breadcrumbs[$i];
if ($i != count($breadcrumbs)-1) echo ' ';
}
if ($showCurrent == 1) echo ' ' . $before . get_the_title() . $after;
} elseif ( is_tag() ) {
echo $before . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;
} elseif ( is_author() ) {
global $author;
$userdata = get_userdata($author);
echo $before . 'Articles posted by ' . $userdata->display_name . $after;
} elseif ( is_404() ) {
echo $before . 'Error 404' . $after;
}
if ( get_query_var('paged') ) {
if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
echo __('Page') . ' ' . get_query_var('paged');
if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
}
echo '</div>';
}
}
}



class bts_author_box extends thesis_box{
public $type = 'rotator';
public $dependents = array(
'bts_author_box_title',
'bts_author_avatar',
'bts_author_description',
'bts_author_read_more',
           'bts_author_website_link',
           'bts_author_username',
           'bts_rss_feed',
           'bts_linkedin',
           'bts_pinterest',
           'bts_twitter_id',
           'bts_facebook',
           'bts_gplus',
           'bts_instagram',
           'bts_youtube');
	
	public $children = array(
	   'bts_author_box_title',
	   'bts_author_avatar',
	   'bts_author_username',
           'bts_author_description',
           'bts_twitter_id',
           'bts_facebook',
           'bts_gplus');
	
	
	protected function translate() {
	   $this->title = __('Author Box', 'bts');
	}
	
	protected function options() {
        global $thesis;
        return array(
           'class' => array(
             'type' => 'text',
             'width' => 'medium',
             'code' => true,
             'label' => $thesis->api->strings['html_class'],
             'tooltip' => sprintf('%s %s', $thesis->api->strings['class_tooltip'], $thesis->api->strings['class_note'])));
}
	

	public function html($args = false) {
        extract($args = is_array($args) ? $args : array());
        $tab = str_repeat("\t", !empty($depth) ? $depth : 0);
        $class = !empty($this->options['class']) ? trim(stripslashes($this->options['class'])) : 'author_box';
	
	echo "$tab<div class=" . $class . ">\n";
	$this->rotator($depth + 1);
	echo "$tab</div>\n";
	}
}

class bts_author_box_title extends thesis_box {
	
	protected function translate() {
		$this->title = __('Author Box Title', 'bts');
	}
	
        protected function options() {
        global $thesis;
        return array(
           'class' => array(
             'type' => 'text',
             'width' => 'medium',
             'code' => true,
             'label' => $thesis->api->strings['html_class'],
             'tooltip' => sprintf('%s %s', $thesis->api->strings['class_tooltip'], $thesis->api->strings['class_note'])),
           'ab_title' => array(
             'type' => 'text',
             'width' => 'long',
             'label' => __('Author Box Title', 'bts'),
             'tooltip' => __('Enter the text to display before the Authors name to link to the authors post archives.', 'bts')),
           'author_name' => array(
             'type' => 'checkbox',
			'options' => array(
				'enable' => __('Display the Authors Name in the Title', 'bts'))));
}
	
	public function html($args = false) {
	extract($args = is_array($args) ? $args : array());
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
	$author_id = $post->post_author;
        $class = !empty($this->options['class']) ? $this->options['class'] : 'author_box';
        $ab_title = !empty($this->options['ab_title']) ? $this->options['ab_title'] : 'This Article Was Written By';
        $authors_name = !isset($this->options['author_name']['enable']) ? '' : "$tab<span class=\"" . esc_attr($class) . "_author\">" . ucfirst(get_the_author_meta( 'display_name', $author_id )) . "</span>\n";
	
	echo
            "$tab<div class='block_title'><h3 class=\"" . esc_attr($class) . "_title widget_title title_clr\">" . esc_attr($ab_title) . " " . $authors_name . "</h3></div>\n";
        }
}

class bts_author_description extends thesis_box {
	
	protected function translate() {
		$this->title = __('Author Description', 'bts');
	}
	
        protected function options() {
        global $thesis;
        return array(
           'class' => array(
             'type' => 'text',
             'width' => 'medium',
             'code' => true,
             'label' => $thesis->api->strings['html_class'],
             'tooltip' => sprintf('%s %s', $thesis->api->strings['class_tooltip'], $thesis->api->strings['class_note'])));
}
	
	public function html($args = false) {
	global $thesis, $post;
        $author_id = $post->post_author;
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
        $class = !empty($this->options['class']) ? $this->options['class'] : 'author_box';
	
	echo
            "$tab<div class=\"" . esc_attr($class) . "_desc\">\n".
            "$tab<p>" . get_the_author_meta('description', $author_id) . "</p>\n".
            "$tab</div>\n";
        }
}

class bts_author_avatar extends thesis_box {
	
	protected function translate() {
		$this->title = __('Author Avatar', 'bts');
	}
	
	protected function options() {
        global $thesis;
        return array(
           'dimensions' => array(
             'type' => 'text',
             'width' => 'tiny',
             'label' => __('Gravatar Dimensions', 'bts'),
             'tooltip' => __('Enter the Dimensions of the Gravatar, just digits no letters!.', 'bts'),
             'placeholder' => '80'),
           'align' => array(
             'type' => 'select',
             'label' => __('Align', 'bts'),
             'tooltip' => __('Align the gravatar left or right.', 'bts'),
                'options' => array(
                    'left' => 'left',
		    'right' => 'right',
		    'none' => 'none')));
}
	
	public function html($args = false) {
        extract($args = is_array($args) ? $args : array());
        $tab = str_repeat("\t", !empty($depth) ? $depth : 0);
        global $thesis, $post;
        $author_id = $post->post_author;
	$class = !empty($this->options['class']) ? $this->options['class'] : 'author_box';
	$author_name = !empty($this->options['author_name']) ? $this->options['author_name'] : 'author';
	$dimensions= !empty($this->options['dimensions']) ? $this->options['dimensions'] : '80';
	$align = !empty($this->options['align']) ? $this->options['align'] : 'left';
	$custom_avatar = get_the_author_meta('custom_avatar', $author_id);
       
        if ($custom_avatar)
        echo 
            "<div class=\"" . esc_attr($class) . "_gravitar\" style=\"float:" . $align . ";\"><a href=\"" . get_author_posts_url(get_the_author_meta('ID', $author_id)) . "\"><img alt=\"".esc_attr($author_name)."\" src=\"" . esc_url($custom_avatar) . "\" width=\"" . esc_attr($dimensions) . "\" height=\"" . esc_attr($dimensions) . "\"/></a></div>";
        else
        echo
            "<div class=\"" . esc_attr($class) . "_gravitar\" style=\"float:" . $align . ";\"><a href=\"" . get_author_posts_url(get_the_author_meta('ID', $author_id)) . "\">" .  get_avatar( get_the_author_meta('ID', $author_id), esc_attr($dimensions)) . "</a></div>";
        }
}

class bts_author_username extends thesis_box {
	
	protected function translate() {
		$this->title = __('Author Username & Occupation', 'bts');
	}
	
        protected function options() {
        global $thesis;
        return array(
           'class' => array(
             'type' => 'text',
             'width' => 'medium',
             'code' => true,
             'label' => $thesis->api->strings['html_class'],
             'tooltip' => sprintf('%s %s', $thesis->api->strings['class_tooltip'], $thesis->api->strings['class_note'])),
           'occupations' => array(
             'type' => 'checkbox',
			'options' => array(
				'enable' => __('Display the Authors Occupation', 'bts'))));
}
	
	public function html($args = false) {
	extract($args = is_array($args) ? $args : array());
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $class = !empty($this->options['class']) ? $this->options['class'] : 'author';
        $author_name = ucfirst(get_the_author_meta( 'display_name', $author_id ));
        $enable = "$tab<span class=\"". $class . "_occupation\">" . get_the_author_meta('occupation', $author_id) . "</span>\n";
	
	echo
            "$tab<span class=\"". $class . "_name\">" . $author_name . "</span>\n";
            if (isset($this->options['occupations']['enable']))
            echo "-" . $enable;
        }
}




class bts_author_read_more extends thesis_box {
	
	protected function translate() {
		$this->title = __('Author Post Archives Link', 'bts');
	}
	
        protected function options() {
        global $thesis;
        return array(
           'class' => array(
             'type' => 'text',
             'width' => 'medium',
             'code' => true,
             'label' => $thesis->api->strings['html_class'],
             'tooltip' => sprintf('%s %s', $thesis->api->strings['class_tooltip'], $thesis->api->strings['class_note']),
           'rm_before' => array(
             'type' => 'text',
             'width' => 'medium',
             'label' => __('Before Author Name', 'bts'),
             'tooltip' => __('Enter the text to display before the Authors name to link to the authors post archives.', 'bts')),
           'rm_after' => array(
             'type' => 'text',
             'width' => 'medium',
             'label' => __('After Author Name', 'bts'),
             'tooltip' => __('Enter the text to display after the Authors name to link to the authors post archives.', 'bts'))));
}
	
	public function html($args = false) {
	extract($args = is_array($args) ? $args : array());
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $class = !empty($this->options['class']) ? $this->options['class'] : 'read_more';
        $rm_before = !empty($this->options['rm_before']) ? $this->options['rm_before'] : 'Read more from';
        $rm_after = !empty($this->options['rm_after']) ? $this->options['rm_after'] : '';
	
	echo
            "$tab<div class=\"" . esc_attr($class) . "\">\n".
            "$tab<a href=\"" . get_author_posts_url(get_the_author_meta('ID', $author_id)) . "\">" . esc_attr($rm_before) . " " . get_the_author_meta('display_name', $author_id) . " " . esc_attr($rm_after) . "</a>\n".
            "$tab</div>\n";
        }
}

class bts_author_website_link extends thesis_box {
	
	protected function translate() {
		$this->title = __('Author Website URL', 'bts');
	}
	
        protected function options() {
        global $thesis;
        return array(
           'class' => array(
             'type' => 'text',
             'width' => 'medium',
             'code' => true,
             'label' => $thesis->api->strings['html_class'],
             'tooltip' => sprintf('%s %s', $thesis->api->strings['class_tooltip'], $thesis->api->strings['class_note'])));
}
	
	public function html($args = false) {
	extract($args = is_array($args) ? $args : array());
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $class = !empty($this->options['class']) ? $this->options['class'] : 'author_website';
	
	echo
            "$tab<span class=\"" . esc_attr($class) . "\"><a href=\"" . get_the_author_meta('user_url', $author_id) . "\">" . get_the_author_meta('user_url', $author_id) . "</a></span>\n";
        }
}

class bts_rss_feed extends thesis_box {
	
	protected function translate() {
		$this->title = __('Author Feed', 'bts');
	}
	
	protected function options() {
        global $thesis;
        return array(
           'feed_text' => array(
             'type' => 'text',
             'width' => 'medium',
             'label' => __('Authors Feed Title', 'bts'),
             'tooltip' => __('Enter the feed title which will be displayed to users. Example: "Subscribe to my Feed"', 'bts'),
             'placeholder' => 'Subscribe to Feed'));
}
	
	public function html($args = false) { 
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $rssfeed = get_author_feed_link( $author_id);
        $feed_text = !empty($this->options['feed_text']) ? $this->options['feed_text'] : 'Subscribe to Feed';
	
        echo
	   "<span class=\"author_feed\"><a href=\"" . $rssfeed . "\">" . esc_attr($feed_text) . " " . ucfirst(get_the_author_meta( 'display_name', $author_id )) . "</a></span>";
        } 
}

//Social Media Boxes Begin here

class bts_twitter_id extends thesis_box {
	
	protected function translate() {
		$this->title = __('Twitter ID', 'bts');
	}

	public function html($args = false) { 
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $twitter = get_the_author_meta('twitter', $author_id );
        $twitter_name = get_the_author_meta('display_name', $author_id);
	
	if (!empty($twitter_name))
        echo
             "<div class=\"bts_twitter s_aut\"><a href=\"https://twitter.com/intent/user?screen_name=" .$twitter. "\" onclick=\"window.open(this.href, 'mywin',
'left=20,top=20,width=500,height=500,toolbar=1,resizable=0'); return false;\"><span class=\"author_twitter a_s_m\"></span></a></div>";
        } 
}

class bts_facebook extends thesis_box {
	
	protected function translate() {
		$this->title = __('Facebook', 'bts');
	}
	
	public function html($args = false) { 
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $facebook_id = get_the_author_meta('facebook', $author_id);
	
	if (!empty($facebook_id))
        echo
	   "<div class=\"bts_facebook s_aut\"><a href=\"http://www.facebook.com/" . $facebook_id . "\" target=\"_blank\" rel=\"external me\"><span class=\"author_facebook a_s_m\"></span></a></div>";
        } 
}

class bts_gplus extends thesis_box {
	
	protected function translate() {
		$this->title = __('Google Plus', 'bts');
	}
	
	public function html($args = false) { 
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $google_id = get_the_author_meta('googleplus', $author_id);
	
	if (!empty($google_id))
        echo
          "<div class=\"bts_gplus s_aut\"><a rel=\"author\" href=\"https://plus.google.com/" . $google_id . "\" target=\"_blank\"><span class=\"author_google a_s_m\"></span></a></div>";
        } 
}

class bts_linkedin extends thesis_box {
	
	protected function translate() {
		$this->title = __('Linked In', 'bts');
	}
	
	public function html($args = false) { 
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $linkedin_id = get_the_author_meta('linkedin', $author_id);
        
	if (!empty($linkedin_id))
        echo
          "<div class=\"bts_linkedin s_aut\"><a href=\"http://www.linkedin.com/in/" . $linkedin_id . "\" target=\"_blank\" rel=\"external me\"><span class=\"author_linkedin a_s_m\"></span></a></div>";
        } 
}

class bts_pinterest extends thesis_box {
	
	protected function translate() {
		$this->title = __('Pinterest', 'bts');
	}
	
	public function html($args = false) { 
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $pinterest_id = get_the_author_meta('pinterest', $author_id);
	
        echo
          "<div class=\"bts_pinterest s_aut\"><a href=\"http://pinterest.com/" . $pinterest_id . "\" target=\"_blank\" rel=\"external me\"><span class=\"author_pinterest a_s_m\"></span></a></div>";
        } 
}

class bts_instagram extends thesis_box {
	
	protected function translate() {
		$this->title = __('Instagram', 'bts');
	}
	
	public function html($args = false) { 
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $instagram_id = get_the_author_meta('instagram', $author_id);
	
        echo
          "<div class=\"bts_instagram s_aut\"><a href=\"http://instagram.com/" . $instagram_id . "\" target=\"_blank\" rel=\"external me\"><span class=\"author_instagram a_s_m\"></span></a></div>";
        } 
}

class bts_youtube extends thesis_box {
	
	protected function translate() {
		$this->title = __('Youtube', 'bts');
	}
	
	public function html($args = false) { 
	$tab = str_repeat("\t", !empty($depth) ? $depth : 0);
	global $thesis, $post;
        $author_id = $post->post_author;
        $youtube_id = get_the_author_meta('youtube', $author_id);
	
	if (!empty($youtube_id))
        echo
          "<div class=\"bts_youtube s_aut\"><a href=\"http://www.youtube.com/" . $youtube_id . "\" target=\"_blank\" rel=\"external me\"><span class=\"author_youtube a_s_m\"></span></a></div>";
        } 
}

add_filter('user_contactmethods','bts_contact_methods',10,1);
function bts_contact_methods( $user_contactmethods ) {
	unset($user_contactmethods['yim']);  
	unset($user_contactmethods['aim']);  
	unset($user_contactmethods['jabber']);  
	$user_contactmethods['occupation'] = 'Occupation'; 
	$user_contactmethods['custom_avatar'] = 'Custom Avatar'; 
	$user_contactmethods['twitter'] = 'Twitter Username'; 
	$user_contactmethods['facebook'] = 'Facebook Username'; 
	$user_contactmethods['googleplus'] = 'Google Plus ID';   
	$user_contactmethods['linkedin'] = 'LinkedIn Username'; 
	$user_contactmethods['pinterest'] = 'Pinterest Username'; 
	$user_contactmethods['instagram'] = 'Instagram Username';
	$user_contactmethods['youtube'] = 'Youtube Username';
	return $user_contactmethods; 
}
