<?php

function newmagaz_defaults() {
	return array (
  'css' => '/*---:[ layout structure ]:---*/
body {
	font-family: $font;
	font-size: $f_text;
	line-height: $h_text;
	color: $text2;
	background-color: $body_bg;
}

*,*:after,*:before{
box-sizing:border-box;
-webkit-box-sizing:border-box;
-moz-box-sizing:border-box;		
}

h1,h2,h3,h4,h5,h6{
font-family: \\\'Roboto Slab\\\', serif;
}

@font-face {
	font-family: \\\'icomoon\\\';
	src:url(\\\'font/icomoon.eot?ymmurg\\\');
	src:url(\\\'font/icomoon.eot?#iefixymmurg\\\') format(\\\'embedded-opentype\\\'),
		url(\\\'font/icomoon.woff?ymmurg\\\') format(\\\'woff\\\'),
		url(\\\'font/icomoon.ttf?ymmurg\\\') format(\\\'truetype\\\'),
		url(\\\'font/icomoon.svg?ymmurg#icomoon\\\') format(\\\'svg\\\');
	font-weight: normal;
	font-style: normal;
}
.fa{
	font-family: \\\'icomoon\\\';
	font-style:normal;	
}


/*---:[ links ]:---*/
a {
	color: $text2;
	text-decoration: none;	
	transition: ease-in-out .4s;
	-webkit-transition: ease-in-out .4s;
	-moz-transition: ease-in-out .4s;	
}

 a:hover {
	color: $links;
	text-decoration: none;
}

.btm_header.scrolltop {
    position: fixed;
    top: 0;
	width: 100%;
    z-index: 999999;
    height:60px;
    -webkit-transition: all .3s ease-in-out;
    transition: all .3s ease-in-out;
}

.btm_header {
     height: 60px;
    position: relative;
    -webkit-box-shadow: 0 5px 1px -4px rgba(0,0,0,0.3);
    -moz-box-shadow: 0 5px 1px -4px rgba(0,0,0,0.3);
    box-shadow: 0 5px 1px -4px rgba(0,0,0,0.3);
    z-index: 999;
    background-color: $tb_header_bg;
    border-bottom: 5px solid $links;
	border-top:1px solid $tb_header_bg;
   }

/*---:[ nav menu ]:---*/
.menu {
	position: relative;
	z-index: 50;
	list-style: none;
}

.menu:after{
	content:\\\'\\\';	
	display:table;
	clear:both;
}

.menu li {
	position: relative;
	float: left;
}
.menu .sub-menu {
	margin: 20px 0 0 0;
	opacity: 0;
	visibility: hidden;
	position: absolute;
	top: 58px;
	left: 0;
	z-index: 9999;
	background-color: $tb_header_bg;
	 -moz-border-radius: 3px;
	-webkit-border-radius: 3px;
	border-radius: 3px;
	-webkit-transition: all .3s ease-in-out;
	-moz-transition: all .3s ease-in-out;
	-ms-transition: all .3s ease-in-out;
	-o-transition: all .3s ease-in-out;
	transition: all .3s ease-in-out;
}

.menu li:hover > .sub-menu {
	opacity: 1;
	visibility: visible;
	margin: 0;
}

.menu .sub-menu li{
	width: $submenu;
	clear: both;	
	list-style:none;	
	border-bottom: 1px solid $color4;	
}

.menu .sub-menu .sub-menu {
	top: 0;
	left: $submenu;
	margin: 0 0 0 -1px;
}

.menu a, .menu_control {
	display: block;
	$menu
	line-height: 1em;
	text-transform: uppercase;
	letter-spacing: 1px;
	color: $color2;
    padding: 20px 20px;
    font-weight: bold;
}
.menu a:hover {
	background-color: $ctr_hdr_bg;
}
.menu_control {
	display: none;
}
.menu .sub-menu a {
   padding: 10px 15px;
    line-height: 25px;
}
.menu, .menu a, .menu .sub-menu {
	
}
.menu .current-menu-item > a {
	background-color:$ctr_hdr_bg;
	color:$color2;
	cursor: text;
}
.menu .sub-menu .current-menu-item > a {
	}

.menu .menu-item-has-children > a:after {
  content: \\\'\\\\f107\\\';
  font-family: \\\'icomoon\\\';
  padding-left: 7px;
  font-size: 13px;
}
/*mean ends*/

h1 {
font-size: 36px;
line-height: 50px;	
}
h2 {
font-size: 32px;
line-height: 45px;	
}
h3 {
font-size: 28px;
line-height: 40px;		
}
h4 {
font-size: 24px;
line-height: 35px;		
}
h5 {
font-size: 20px;
line-height: 30px;		
}
h6 {
font-size: 16px;
line-height: 25px;			
}

/*---:[ golden ratio typography with spaced paragraphs ]:---*/
.grt h1, .grt h2, .grt h3, .grt h4, .grt h5, .grt h6 {
  margin-bottom: 27px;
}

.grt h1.headline {
	$headline
	color: $headline_color;
	margin:0 0 10px 0;
}
.page .single_header h1.headline {
margin:0 0 15px 0;	
}

.grt h2.headline a{
color:$subhead_color;
}
.grt h2.headline a:hover{
color:$links;	
}

.grt h2.headline{
	$subhead
	margin-bottom: 0px;
}
.grt .small, .grt .caption {
	font-size: $f_aux;
	line-height: $h_aux;
}
.grt .drop_cap {
	font-size: $x_double;
	line-height: 1em;
	margin-right: 0.15em;
	float: left;
}
.grt p, .grt ul, .grt ol, .grt blockquote, .grt pre, .grt dl, .grt dd, .grt .center, .grt .block, .grt .caption, .post_box .aligncenter, .post_box .alignnone, .post_box .post_image, .post_box .post_image_box, .post_box .wp-caption, .post_box .wp-post-image, .post_box .alert, .post_box .note, .headline_area {
	margin-bottom: $x_single;
}
.grt ul, .grt ol, .grt .stack {
	margin-left: $x_single;
}
.grt ul ul, .grt ul ol, .grt ol ul, .grt ol ol, .wp-caption p, .post_box .alert p:last-child, .post_box .note p:last-child, .post_content blockquote.right p, .post_content blockquote.left p {
	margin-bottom: 0;
}
.grt .left, .post_box .alignleft, .post_box .ad_left {
	margin-bottom: $x_single;
	margin-right: $x_single;
}
.grt .right, .post_box .alignright, .post_box .ad {
	margin-bottom: $x_single;
	margin-left: $x_single;
}
.grt .caption {
	margin-top: -$x_half;
	color: $text2;
}
/*---:[ golden ratio pullquotes ]:---*/
.grt blockquote.right, .grt blockquote.left {
	$pullquote
	width: 45%;
	margin-bottom: $x_half;
}
.grt blockquote.right, .grt blockquote.left { 
	padding-left: 0;
	border: 0;
}
/*---:[ post box styles ]:---*/

.post_box .headline, .headline a {
	color: $headline_color;
}
.headline a:hover {
	color: $links;
}
.byline, .byline a {
	color: $text2;
}

.byline a, .post_author, .post_date {
/*	text-transform: uppercase;*/
	letter-spacing: 1px;
}
.byline a:hover, .num_comments {
	color: $text1;
}
.byline .post_edit {
	margin-left: $x_half;
}
.byline .post_edit:first-child {
	margin-left: 0;
}

.single_postbox .post_tags a{
color: $text2;
    background-color: $links;
    font-size: 14px;
    padding: 3px 10px;
    line-height: 25px;
    margin-left: 2px;	
}

.single_postbox .post_tags a:hover{
color: $links;
    background-color: $text2;	
}

.post_author_intro, .post_date_intro, .byline .post_cats_intro {
	font-style: italic;
}

.post_box blockquote {
	$blockquote
color: $text2;
  margin-left: 14px;
  border-top: 2px solid #E23129;
  border-bottom: 1px solid $sb_border;
  padding: 20px 0 0;
  padding-left: 63px;
}

.post_box blockquote:before {
  display: inline-block;
  font-family: \\\'icomoon\\\';
  font-style: normal;
  font-weight: normal;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  -moz-osx-font-smoothing: grayscale;
  content: \\"\\\\f10d\\";
  font-size: 48px;
  float: left;
  margin-left: -70px;
  margin-top: 5px;
  color: $color3;
}

.post_box code {
	$code
}
.post_box pre {
	$pre
	background-color: $color3;
	padding: $x_half;
	-webkit-tab-size: 4;
	-moz-tab-size: 4;
	tab-size: 4;
}
.post_content li a {
	text-decoration: underline;
}
.post_content li a:hover {
	text-decoration: none;
}
.post_box .frame, .post_box .post_image_box, .post_box .wp-caption {
	border: 1px solid $color1;
	background-color: $color2;
	padding: $x_half;
}
.post_box .wp-caption img, .post_box .post_image_box .post_image, .post_box .thumb {
	margin-bottom: $x_half;
}
.wp-caption.aligncenter img {
	margin-right: auto;
	margin-left: auto;
}
.wp-caption .wp-caption-text .wp-smiley {
	display: inline;
	margin-bottom: 0;
}
.post_box .wp-caption p {
	font-size: $f_aux;
	line-height: $h_aux;
}
.post_box .author_description {
	border-top: 1px dotted $color1;
	padding-top: $x_single;
}
.post_box .author_description_intro {
	font-weight: bold;
}
.post_box .avatar {
	$avatar
	float: right;
	clear: both;
	margin-left: $x_half;
}
.post_box .author_description .avatar {
	$bio_avatar
	float: left;
	margin-right: $x_half;
	margin-left: 0;
}
.post_box .post_cats{
	display:inline-block;
	margin-bottom: 0;
	margin-right:8px;
}
.post_box .alert, .post_box .note {
	padding: $x_half;
}
.post_box .alert {
	background-color: #ff9;
	border: 1px solid $sb_border;
}
.post_box .note {
	background-color: $color2;
	border: 1px solid $color1;
}
.landing .headline_area {
	text-align: center;
}

.featured_image {
    overflow: hidden;
    position: relative;
}

.featured_image .image_hover, .featured_image .thumb_hover{
	position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
position: absolute;
	box-shadow: inset 0 0 54px rgba(0,0,0,.8);
    -moz-box-shadow: inset 0 0 54px rgba(0,0,0,.8);
    -webkit-box-shadow: inset 0 0 54px rgba(0,0,0,.8);
}

.featured_image img{
position:relative;	
}

.block_title:after {
    content: \\\'\\\';
    position: absolute;
    background: $color5;
    width: 2px;
    margin: 8px 0px 6px 5px;
    height: 31px;
    top: -8px;
    left: -5px
}

.block_title a, .sidebar .block_title h3{
margin-left: 5px;	
}

.righty .block_title:after{
    left: -5px;
	}

/*blog page starts*/
.hme_pst_bx:after{
display:table;
clear:both;
content:\\\'\\\';	
}

.post_box {
    margin-left: 20px;
    margin-bottom: 35px;
}

.hme_pst_bx {
padding-bottom: 10px;
    margin-bottom: 10px;
    border-bottom: 1px dotted#ddd;	
}

.post_left{
float: left;
    width: 40%;
	padding: 20px;
}	

.post_right{
overflow: hidden;
    padding: 14px 20px 14px 10px;	
}

.post_right .post_cats{
margin-bottom: 0px;
    font-size: 13px;
    line-height: 27px;
    text-transform: uppercase;
    font-weight: bold;	
}

.post_right .post_cats a{
color: $text1;	
}
.hme_byline{
font-size: 13px;
    color: $text1;
    margin: 5px 0;	
}

.hme_byline .post_author{
margin-right: 10px;	
}

.hme_byline .post_author:before{
font-family: \\\'icomoon\\\';
    content: \\\'\\\\f007\\\';
    padding-right: 4px;	
}

.hme_pst_bx .post_content p {
font-size: 17px;
    line-height: 30px;
    margin-bottom: 20px;
}

.num_comments_link:before, .info-comment:before{
font-family: \\\'icomoon\\\';
    content: \\\'\\\\e600\\\';
    padding-right: 4px;		
}

.hme_pst_bx .num_comments_link {
	float: right;
}

.hmepost_btm:after{
display:table;
clear:both;
content:\\\'\\\';	
}

.newmagaz_readmore {
float:left;	
}

.cl-effect-10  {
	position: relative;
	z-index: 1;
}

.cl-effect-10 a {
	overflow: hidden;
}

.first_left_category .cl-effect-10 a, .second_category .cl-effect-10 a, .fourth_category .cl-effect-10 a, .fifth_category .cl-effect-10 a, .sixth_category .cl-effect-10 a {
text-transform: none;
}

.permalink.cl-effect-10 a span {
    padding: 1px 8px;
}

.permalink.cl-effect-10 a::before {
padding: 1px 8px;	
}

.cl-effect-10 a span {
	display: block;
	padding: 4px 10px;
    font-size: 13px;
	background: $links;
	color: $color5;
	-webkit-transition: -webkit-transform 0.3s;
	-moz-transition: -moz-transform 0.3s;
	transition: transform 0.3s;
}

.cl-effect-10 a:before {
	position: absolute;
	content:\\"Read More\\";
	top: 0;
	left: 0;
	z-index: -1;
	padding: 4px 10px;
    font-size: 13px;
	width: 100%;
	height: 100%;
	background: $color5;
	color:$links;
	-webkit-transition: -webkit-transform 0.3s;
	-moz-transition: -moz-transform 0.3s;
	transition: transform 0.3s;
	-webkit-transform: translateX(-25%);
}

.cl-effect-10 a:hover span,
.cl-effect-10 a:focus span {
	-webkit-transform: translateX(100%);
	-moz-transform: translateX(100%);
	transform: translateX(100%);
}

.cl-effect-10 a:hover::before,
.cl-effect-10 a:focus::before {
	-webkit-transform: translateX(0%);
	-moz-transform: translateX(0%);
	transform: translateX(0%);
}

.cl-effect-10 a {
	position: relative;
	display: inline-block;
	outline: none;
	color: $color2;
	text-decoration: none;
	text-transform: uppercase;
	letter-spacing: 1px;
	font-weight: 400;
	text-shadow: 0 0 1px rgba(255,255,255,0.3);
}

.cl-effect-10 a:hover,
.cl-effect-10 a:focus {
	outline: none;
}

/*blog page ends*/

.single_postbox  .post_date, .single_postbox .post_author, .single_postbox .num_comments_link{
margin-right:8px;	
}

.single_byline{
display: inline;
    padding: 11px 40px;
    background-color: $color3;
}

.single_postbox .sidebar .widget{
padding-right: 10px;	
}

.archive_title {
margin-left: 35px;
    margin-bottom: 8px;
    font-size: 24px;
    line-height: 40px;
    text-transform: uppercase;	
}
/*---:[ other post box styles ]:---*/
.num_comments_link {
	display: inline-block;
	text-decoration: none;
}

/*---:[ misc. content elements ]:---*/
.archive_intro {
	border-width: 0px 0px 1px 0px;
	border-style: solid;
	border-color: $color1;
}
.archive_intro .headline {
	margin-bottom: $x_single;
}

/*---:[ comments ]:---*/
#comments {
	margin-top: $x_double;
}
.comments_intro {
	color: $text2;
	margin-bottom: $x_half;
	padding: 0 $x_single;
}
.comments_closed {
	font-size: $f_aux;
	line-height: $h_aux;
	color: $text2;
	margin: 0 $x_single $x_single $x_single;
}
.comment_list {
	list-style-type: none;
	margin-left: 0!important;
    margin-bottom: 20px!important;
	border-top: 1px dotted $color1;
}
.comment {
	border-bottom: 1px dotted $color1;
	padding: 24px 0;
}
.children .comment {
	list-style-type: none;
	margin-top: $x_single;
	border-left: 1px solid $color1;
	border-bottom: 0;
	padding: 0 0 0 $x_single;
}
.children .bypostauthor {
	background-color: transparent;
	border-color: $color1;
}
.comment .comment_head {
	margin-bottom: $x_half;
}
.children .comment_head {
	margin-bottom: 0;
}

.comment .avatar img {
  padding: 0px;
  border-radius:50px;
  -webkit-border-radius: 50px;
  -moz-border-radius: 50px; 
  box-shadow: 0 0 3px $color1;
  -moz-box-shadow: 0 0 3px $color1;
  -webkit-box-shadow: 0 0 3px $color1;
}
.cmt_cont:after {
  content: \\"\\";
  display: table;  
  clear: both;
}
.comment .comment_author {
  font-size: $x_half;
	color:$text1;
}
.comment_date {
	color:$text1;
	font-size: $f_aux;
	padding-right:8px;
}
.comment_footer a {
	font-size: $f_aux;
	line-height: $h_aux;
	color: $text2;
	text-transform: uppercase;
	letter-spacing: 1px;
	margin-left: $x_half;
}
.comment_head a:hover, .comment_footer a:hover, .comment_nav a:hover {
	text-decoration: underline;
}
.comment_footer a:first-child {
	margin-left: 0;
}
.comment .avatar {
	$comment_avatar
	float: left;
  margin-right: 15px;
  margin-left: 0;
}

.comment_text p{
margin-bottom:5px;	
}

.right_cmt_cnt{
float: right;
  width: 90%;	
}

.right_cmt_cnt .comment-reply-link{
  background-color: $color5;
  color: $color2;
  padding: 8px 17px;
  border-radius: 15px;
  -webkit-border-radius: 15px;
  -moz-border-radius: 15px;
  font-size: 13px;	
}

.right_cmt_cnt .comment-reply-link:hover{
	color: $color5;
    background: $links;
}

.comment_edit{
padding-left: 10px;	
color:$text1;	
}

.comment_nav {
	font-size: $f_aux;
	line-height: $h_aux;
	text-transform: uppercase;
	letter-spacing: 1px;
	border-style: dotted;
	border-color: $color1;
	padding: $x_half $x_single;
}
.comment_nav_top {
	border-width: 1px 0 0 0;
}
.comment_nav_bottom {
	margin: -$x_double 0 $x_double 0;
	border-width: 0 0 1px 0;
}
.next_comments {
	float: right;
}

.comment_text{
padding:8px 0;	
}
/*---:[ inputs ]:---*/
.input_text {
	font-size: inherit;
	line-height: 1em;
	font-family: inherit;
	font-weight: inherit;
	color: $text1;
	border: 1px solid $color1;
	background-color: $color2;
	padding: 23px;
	-webkit-box-sizing: border-box;
	-moz-box-sizing: border-box;
	box-sizing: border-box;
}
.input_text:focus {
	border-color: $color2;
	background-color: $color3;
}
textarea.input_text {
	line-height: $h_text;
}
.comments .input_submit {
 text-transform: uppercase;
    font-size: 14px;
    letter-spacing: 1px;
    line-height: 1em;
    font-family: inherit;
  outline:none;
    padding: 14px 15px 11px 15px;
    cursor: pointer;
    border-radius: 4px;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
    overflow: visible;
    color:$color5;
    background:$links;
    border: none;
  transition: ease-in-out .4s;
  -webkit-transition: ease-in-out .4s;
  -moz-transition: ease-in-out .4s;
}

.comments .input_submit:hover {
  color:$links;
    background: $color5;
}
/*---:[ comment form ]:---*/
.comment_form_title {
  font-family: \\\'Roboto Condensed\\\', sans-serif;
}

#commentform {
	margin: 30px 0;
}
.comment #commentform {
	margin-top: 0;
	padding-right: 0;
	padding-left: 0;
}
.comment_form_title {
	$subhead
	color: $subhead_color;
}
#commentform label {
	display: block;
}
#commentform p {
	margin-bottom: $x_half;
}
#commentform p .required {
	color: #d00;
}
.comment_moderated {
	font-weight: bold;
}
#commentform .input_text {
	width: 50%;
}

#commentform .block_title {
    margin-bottom: 0px;
}

#commentform textarea.input_text {
	width: 100%;
}
#cancel-comment-reply-link {
	float: right;
	font-size: $f_aux;
	line-height: inherit;
	text-transform: uppercase;
	letter-spacing: 1px;
	color: $links;
}
#cancel-comment-reply-link:hover {
	text-decoration: underline;
}
.login_alert {
	font-weight: bold;
	border: 1px solid $color1;
	background-color: $color2;
}
/*---:[ sidebar ]:---*/

.sidebar .headline, .sidebar .sidebar_heading, .sidebar .widget_title {
	$sidebar_heading
}
.sidebar .sidebar_heading, .sidebar .widget_title {
	font-variant: small-caps;
	letter-spacing: 1px;
}
.sidebar .input_submit {
	font-size: inherit;
}
.sidebar p, .sidebar ul, .sidebar ol, .sidebar blockquote, .sidebar pre, .sidebar dl, .sidebar dd, .sidebar .left, .sidebar .alignleft, .sidebar .ad_left, .sidebar .right, .sidebar .alignright, .sidebar .ad, .sidebar .center, .sidebar .aligncenter, .sidebar .block, .sidebar .alignnone {
	margin-bottom: $s_x_single;
}
.sidebar .left, .sidebar .alignleft, .sidebar .ad_left {
	margin-right: $s_x_single;
}
.sidebar ul ul, .sidebar ul ol, .sidebar ol ul, .sidebar ol ol, .sidebar .right, .sidebar .alignright, .sidebar .ad, .sidebar .stack {
	margin-left: $s_x_single;
}
.sidebar ul ul, .sidebar ul ol, .sidebar ol ul, .sidebar ol ol, .wp-caption p, .sidebar .post_excerpt p {
	margin-bottom: 0;
}
.widget, .sidebar .text_box, .sidebar .thesis_email_form, .sidebar .query_box {
	margin-bottom: $s_x_single;
}
.sidebar .thesis_email_form .input_text, .widget li {
	margin-bottom: $s_x_half;
}
.sidebar .search-form .input_text, .sidebar .thesis_email_form .input_text {
	width: 100%;
}
.sidebar .query_box .post_author, .sidebar .query_box .post_date {
	color: $text2;
}
.sidebar .post_content, .widget li ul, .widget li ol {
	margin-top: $s_x_half;
}
.widget ul {
	list-style-type: none;
}
.widget li a:hover {
	text-decoration: underline;
}

/*singlepage starts*/

.single_postbox{
margin-left:0px;	
}

.single_postbox .post_cats a{
margin-left: 30px;
    text-transform: uppercase;
    font-size: 12px;
    display: inline;
    padding: 6px 12px;
    background-color: $links;
    color: $text2;	
}

.single_postbox .post_cats a:hover{
    background-color: $text2;
    color: $links;	
}

.single_postbox:after{
display:table;
clear:both;
content:\\\'\\\';	
}

.single_cont_left{
padding-left:30px!important;	
}

.single_cont_left .post_tags{
margin-bottom: 20px;	
}

.single_header{
padding: 5px 30px 28px 30px;
    border-bottom: 1px solid $color1;
    margin-bottom: 23px;
	text-align:center;
}

.single_header .post_tags{
margin-bottom: 0;
    margin-top: -32px;	
}

.post_tags_intro{
background-color: $text2;
    font-size: 12px;
    color: $links;
    padding: 4px 8px;	
}

.newpagination{
  margin-left: 20px;
}

.newpagination .current{
padding: 8px 15px;
background:$links;
color:$color5;
margin-right: 7px;
}

.newpagination a:hover{
background:$links;
color: $color5;
}

.newpagination a{
border: 1px solid $color1;
color:$links;
padding: 2px 15px;
display: inline-block;
margin-right: 6px;
margin-bottom: 8px;
font-weight: 700;
background:$color5;
}

.post_author:before, .comment_author:before, .byline .author:before{
font-family: \\\'icomoon\\\';
    content: \\\'\\\\f007\\\';
padding-right:8px;	
}

.byline span{
padding-right:8px!important;	
}

/*breadcrumbs starts*/
.breadcrumbs{
  overflow: hidden;
  font-size: 13px;
  margin: auto auto 10px;
	margin-left:20px;
}
.breadcrumbs a {
color: $text2;
  text-decoration: none;
  padding: 6px 3px;
  font-size: 13px;
  line-height: 20px;
  position: relative;
  display: block;
  float: left;
  transition: 0.2s ease-in-out;
  -webkit-transition: 0.2s ease-in-out;
  -moz-transition: 0.2s ease-in-out;
}

.breadcrumbs a:after {
  content: \\">>\\";
  padding-left: 7px;
  color: $color4;
  font-size: 11px;
}

.breadcrumbs .current{
  padding: 0px 0 0px 11px;
  margin-top: 3px;
  float: left;
  font-size: 13px;
}

/*breadcrumbs ends*/

/*social sharing*/

.social_sharing ul{
margin-left: 0px!important;	
}

.social_sharing ul li{
display:inline-block;
margin-bottom:15px;	
}

.social_sharing ul li a {
  padding: 0px 10px 0 0;
  display: block;
  font-size: 12px;
	color:$color2;
}
.share_tweet a{
background:#00aced;
}

.share_fb a{
background:#3b5998;
}

.share_plus a{
background:#dd4b39;
}

.share_linkedin a{
background:#007bb6;
}

.share_stumble a{
background:#EB4823;
}

.share_reddit a{
background:#88BAEC;
}

[class^=\\"icon-\\"], [class*=\\" icon-\\"] {
	padding: 10px;
	font-family: \\\'icomoon\\\';
	speak: none;
	font-style: normal;
	font-weight: normal;
	font-variant: normal;
	text-transform: none;
	line-height: 1;
	font-size: 13px;
	margin-right: 3px;
	/* Better Font Rendering =========== */
	-webkit-font-smoothing: antialiased;
	-moz-osx-font-smoothing: grayscale;
}

.icon-googleplus:before {
	content: \\"\\\\e601\\";
}
.icon-facebook:before {
	content: \\"\\\\e60c\\";
}
.icon-twitter:before {
	content: \\"\\\\e60d\\";
}
.icon-reddit:before {
	content: \\"\\\\e611\\";
}
.icon-linkedin:before {
	content: \\"\\\\e608\\";
}
.icon-stumbleupon:before {
	content: \\"\\\\e60a\\";
}
/*social sharing ends*/

.prev_next {
clear: both;
	border-top: 1px solid $color1;
border-bottom: 1px solid $color1;
width: 100%;
color: $text1;
}

.prev_next:after{
  display: table;
  content: \\"\\";
  clear: both;	
}
.previous_post a{
position:relative;	
}
.previous_post a:before {
  content: \\"Previous Story:\\";
  display: block;
  font-size: 12px;
  font-weight: bold;
  text-transform: uppercase;
  color:$text1;
  letter-spacing: .5px;
}

.previous_post a, .next_post a {
  display: block;
  font-size: 19px;
    color: $text1;	
  line-height: 1.4em;
padding:20px 30px;	
 }
.previous_post a:hover, .next_post a:hover{
 color: $links;	
	background:$color3;
}

.next_post {
	width: 50%;
	float:right;
  text-align: center;
}

.previous_post {
  float: left;
  width: 50%;
	text-align:center;
	border-right: 1px solid $color1;
}

.next_post a:before {
  content: \\"Next Story:\\";
  display: block;
  font-size: 12px;
  font-weight: bold;
  text-transform: uppercase;
  color:$text1;
  letter-spacing: .5px;
}

.author_box_gravitar img{
 border: 1px solid $color3;
  background: $color2;
  float: left;
  margin: 0 10px 5px 0;
  border-radius: 50%;
	-webkit-border-radius: 50%;
	-moz-border-radius: 50%;
  box-shadow: 0 0 3px 0 #B5B5B5;
  -moz-box-shadow: 0 0 3px 0 #b5b5b5;
  -webkit-box-shadow: 0 0 3px 0 #B5B5B5;	
}

.author_box{
display:block;
width:100%;
overflow:hidden;
margin:10px 0 30px 0;	
overflow:hidden;
}

 .comment_form_title{
	display:inline-block;
font-weight: bold;
    letter-spacing: 1px;
    text-transform: uppercase;
    font-size: 13px;
    position: relative;
    background-color: $color5;
    color:$links;
    padding: 7px 14px 7px 15px;
    margin: 0;
    line-height: 1.5;
    height: 33px;	
}

.author_right{
float: right;
width: 86%;	
margin-left:5px;	
}

.author_box_desc p{
	margin-bottom:10px!important;
	font-size: 14px;
}

.s_aut{
display:inline-block;
}

.s_aut a{
border: 1px solid $color3;
  padding: 2px 6px;
  margin-right: 5px;
	color:$color2;
}

.author_name{
margin-right: 5px;
font-size: 14px;	
color:$text2;	
}

.author_name_media{
	float:left;
	width:93%;
}

.a_s_m{
	font-family: \\\'icomoon\\\';
	font-size:12px;
	font-style:normal;
	}
.bts_twitter a{
background:#00A0D1;	
}
.author_twitter:before{
content:\\\'\\\\e60d\\\';
}

.bts_facebook a{
background:#3B5998;		
}
.author_facebook:before{
content:\\\'\\\\e60c\\\';
}

.bts_gplus  a{
background:#C63D2D;		
}
.author_google:before{
content:\\\'\\\\e601\\\';
}

.bts_linkedin  a{
background:#4875B4;		
}

.author_linkedin:before{
content:\\\'\\\\e608\\\';
}

.bts_pinterest a{
background:#910101;			
}
.author_pinterest:before{
content:\\\'\\\\e609\\\';
}


.bts_instagram a{
background:#4E433C;	
}

.author_instagram:before{
content:\\\'\\\\e60b\\\';
}


.bts_youtube a{
background:#C4302B;	
}

.author_youtube:before{
content:\\\'\\\\e603\\\';
}

.newmagaz_related_box:after{
display:table;
clear:both;
content:\\"\\";	
}

.related_posts{
float: left;
  width: 32%;
  margin-right: 15px;
}

.newmagaz_related_box .last{
float:right;
margin-right:0px;		
}

.related_posts_title h4{
font-size: 18px;
  line-height: 23px;
padding: 10px 0 5px 0;
margin-bottom: 0;	
}

.related_posts .byline span{
font-size: 14px;
  color: $text1;	
}

/*single page ends here*/

/*header starts here*/
.container{
width: $w_total;
margin: 0 auto;	
}

.top_header {
padding-left:20px;
    background-color: $tb_header_bg;
}

.top_header:after, .center_header{
display:table;
clear:both;
content:\\"\\";	
}

.top_left{
float:left;	
}

.top_right{
	float:right;
	height:40px;
}

.widget_search{
	height: 40px;
    overflow: hidden;
    float: none;
	display: inline-block;
    margin-left: 5px;
    position: relative;	
}

.widget_search:after {
    content: \\" \\";
    display: block;
    width: 0;
    height: 0;
    position: absolute;
    top: 15px;
    z-index: 2;
    right: 30px;
    border: 6px solid transparent;
    border-right-color:$links;
}

.widget_search input[type=\\\'text\\\']{
	background: $search_bg;
    font-size: 13px;
     padding: 9px 36px 8px 12px;
    width: 100%;
    height: 40px;
    color: $color2;
    border: none;
    border: 1px solid $color4;
    border-width: 0 0 0 1px;
    -webkit-border-radius: 0;
    -moz-border-radius: 0;
    border-radius: 0;
    outline: none;
} 

.btn-success{
background:$links;
    cursor: pointer;
	position:absolute;
     right: 0;
    height: 40px;
    width: 30px;
    top: 1%;
    display: block;
    border: 0 none;
    box-shadow: none!important;
	-webkit-box-shadow:none!important;
    -moz-box-shadow: none!important;
    padding: 0;
    -webkit-border-radius: 0;
    -moz-border-radius: 0;
    border-radius: 0;	
}

.fa-search:before {
    content: \\\'\\\\f002\\\';
    font-size: 13px;
	color:$color2;
}

.center_header {
background-color: $ctr_hdr_bg;
    padding: 20px;	
}

.newmagaz_logo{
float: left;
margin-top:15px;	
}

.header_advertisement{
	float:right;
}

#nt-title-container ul li h4{
	font-size: 18px;
	line-height: 40px;
}

#nt-title-container ul{
	height:40px;
overflow:hidden;	
}

#nt-title-container ul li a{
	color:$color2;
	font-size:12px;
	line-height:41px;
	text-transform:uppercase;
	letter-spacing:1px;
	display:block;
	
}

#nt-title-container ul li a:before{
	font-family: \\\'icomoon\\\';
	content: \\\'\\\\f100\\\';
    font-size: 13px;
    color: $color1;
	padding-right:10px;	
}

#nt-title-container ul li a:hover{
	color: $links;
}

#nt-title-container ul li{
	list-style:none;

}
.news-ticker_content{
	min-height:41px;	
}

.news-ticker:after{
	display:table;
	clear:both;
	content:\\\'\\\';	
}
.news-ticker_title{
	float: left;	
}
.news-ticker_title h3{
	font-size: 13px;
	color: $color1;
    font-weight: bold;
    letter-spacing: 1px;	
}

.news-ticker_content{
overflow: hidden;
    padding-left: 15px;	
}
/*header ends here*/

/*content starts here*/
.container_one{
	padding:20px 0 0 0;	
}

.template-home .container_one{
	padding:35px 0 0 0;	
}

.inner_content{
	background-color:$color2;
}

.latest_news{
	padding:20px;	
}

.first_lat_news{
	float: left;
    width: 49.75%;
    margin-right: 5px;
    margin-bottom: 6px;
    position: relative;
	overflow:hidden;
}
.s_c_one_byline{
	position:absolute;
	top: 0;
}

.s_c_one_byline h4{
	font-size: 12px;
    line-height: 24px;
    text-transform: uppercase;
}

.s_c_one_byline h4 a{
	background-color: $links;
    color: $color5;
    padding: 4px 15px;
	letter-spacing: 1px;
}

.latest_news .last{
	float:right;
	margin-right:0;	
}

.s_c_one_title h4{
    font-size: 15px;
	line-height: 22px;	
}

.s_c_one_title h4 a{
	position: absolute;
    left: 0;
    bottom: 0px;
    visibility: visible;
    width: 100%;
    display: block;
    background-color: rgba(0,0,0,0.75);
    color: rgba(255,255,255,1.00);
    padding:10px 20px;
	-webkit-transition: all .4s ease-in-out;
    -moz-transition: all .4s ease-in-out;
    -ms-transition: all .4s ease-in-out;
    -o-transition: all .4s ease-in-out;
    transition: all .4s ease-in-out;
}

.first_lat_news:hover .s_c_one_title h4 a{
	 padding:20px 20px;
}

.btm_lat_news:hover .s_c_one_title h4 a,.cat_seven:hover .category_seven_title h4 a{
	 padding:20px 20px;
}


.latest_news:after{
    clear: both;
    display: table;
    content: \\\'\\\';	
}

.btm_lat_news:after{
    clear: both;
    display: table;
    content: \\\'\\\';
}

.btm_lat_news{
    float: left;
    width: 33%;
	margin-right: 5px;
    position: relative;
	overflow:hidden;
}

.featured_image {
    overflow: hidden;
}

.featured_image img {
    width: 100%;
}

.featured_image img:hover {
    -webkit-transform: scale(1.2) rotate(5deg);
    -moz-transform: scale(1.2) rotate(5deg);
    -ms-transform: scale(1.2) rotate(5deg);
    -o-transform: scale(1.2) rotate(5deg);
    transform: scale(1.2) rotate(5deg);
}

.post_left .featured_image img:hover {
     transform: none;
}

.featured_image img {
    transition: all 4s ease-in-out;
    -webkit-transition: all 4s ease-in-out;
    -moz-transition: all 4s ease-in-out;
    position: relative;
}

.container_one:after{
	display:table;
	content:\\\'\\\';
	clear:both;	
}

.content_left{
	$column1
	width: $w_content;
}

.sidebar{
	$sidebar	
	$column2	
}

.first_category, .fourth_category, .fifth_category, .sixth_category, .seventh_category{
	padding-left:20px;	
	margin-bottom:30px;	
}

.first_category_inner:after, .first_right_category:after{
	display:table;
	clear:both;
	content:\\\'\\\';	
}

.first_category_inner{
    overflow: hidden;	
}

.first_left_category{
	float: left;
    width: 49.5%;
    margin-right: 13px;
}

.first_right_category {
    float: right;
    width: 48.8%;
    margin-bottom: 10px;
}

.first_left_category h4, .second_top_category h4{
   font-size: 20px;
    line-height: 28px;
    padding-top: 15px;
}
.second_top_category p,.fourth_top_category p{
	font-size: 16px;
    line-height: 27px;
}
.sixth_top_category h4{
    font-size: 17px;
    line-height: 26px;
    padding-top: 15px;
}

.sixth_category .byline {
    margin-top: 5px;
    margin-bottom: 5px;
}

.fourth_top_category h4{
   font-size: 20px;
    line-height: 28px;	
}

.first_category .byline, .second_category .byline, .fourth_category .byline, .fifth_category .byline, .sixth_category .byline{
    margin-top: 3px;
    margin-bottom: 3px;
    font-size: 14px;
	color:$text1;
}

.first_left_category p {
  font-size: 17px;
    line-height: 24px;
    color: $text2;
}

.first_left_category .permalink, .second_top_category .permalink, .fourth_top_category .permalink{
    padding-top: 10px;
}

 .permalink a {
  font-size: 13px;
    position: relative;
}

.f_r_c_l {
    float: left;
    margin-right: 10px;
    width: 31%;
}

.f_r_c_r h4, .s_b_c_r h4{
    font-size: 16px;
    line-height: 22px;
}

.btm_ctry .s_b_c_r h4 a{
	color:$color2;
}

.btm_ctry .s_b_c_r h4 a:hover, .fourth_bottom_category .s_b_c_r h4 a:hover, .sixth_top_category h4 a:hover, .category_seven_title h4 a:hover, .first_left_category h4 a:hover, .second_top_category h4 a:hover{
color:$links;	
}

.fourth_bottom_category .s_b_c_r h4 a{
	color:$color2;
}

.byline h5{
display: inline-block;
    font-size: 13px;
padding-right: 5px;	
}

.byline .author {
    padding-right: 5px;
}

.info-comment {
    display: inline-block;
    font-size: 12px;
}

.block_title .title_clr{
    letter-spacing: 1px;
    text-transform: uppercase;
    font-size: 13px;
    position: static;
    display: inline-block;
    background-color: $color5;
    color: $color2;
    padding: 7px 14px 7px 15px;
    line-height: 1.5;
    height: 33px;	
	margin-bottom:0px;
}

.block_title{
position: relative;
margin-bottom: $x_single;	
}

.block_title:before {
    width: 100%;
    height: 2px;
    left: 0;
    top: 31px;
    background-color: rgba(0,0,0,1.00);
    content: \\\'\\\';
    position: absolute;
}

.sec_third_category{
padding-left:20px;	
}


.sec_third_category:after{
display:table;
content:\\"\\";
clear:both;	
}
.second_category {
    width: 49%;
    float: left;
    margin-right: 10px;
}

.second_category.righty {
    float: right;
    margin-right: 0;
}

.second_top_category {
  margin-bottom: 14px;
    border-bottom: 1px solid $color3;
    padding-bottom: 8px;
}

.second_bottom_category {
 margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 1px dotted $color4;
}

.second_bottom_category:after{
display:table;
content:\\"\\";
clear:both;	
}

.s_b_c_l {
    float: left;
    width: 28%;
}

.s_b_c_r {
    float: right;
    width: 68%;
}

.first_category .block_title .title_clr, .first_category .block_title:before, .first_category .block_title:after {
background-color: $blk_title1;	
}

.first_category .cl-effect-10 a span{
color:$color2;	
background-color: $blk_title1;			
}


.second_category .block_title .title_clr, .second_category .block_title:before, .second_category .block_title:after{
background-color: $blk_title2;	
}

.second_category .cl-effect-10 a span{
color:$color2;	
background-color: $blk_title2;		
}

.righty .block_title .title_clr, .righty .block_title:before, .righty .block_title:after{
background-color: $blk_title3;	
}

.righty  .cl-effect-10 a span{
color:$color2;	
background-color: $blk_title3;		
}

.fourth_category .block_title .title_clr, .fourth_category .block_title:before,  .fourth_category .block_title:after{
background-color: $blk_title4;	
}

.fourth_category .cl-effect-10 a span{
color:$color2;	
background-color: $blk_title4;		
}

.fifth_category .block_title .title_clr, .fifth_category .block_title:before, .fifth_category .block_title:after{
background-color: $blk_title5;		
}

.fifth_category .cl-effect-10 a span{
color:$color2;	
background-color: $blk_title5;		
}

.sixth_category .block_title .title_clr, .sixth_category .block_title:before, .sixth_category .block_title:after{
background-color: $blk_title6;		
}

.sixth_category .cl-effect-10 a span{
color:$color2;	
background-color: $blk_title6;			
}

.content_advertisement img{
margin: 0 auto;
    padding: 30px 0;	
}

.fourth_top_category{
margin-bottom: 10px;
  border-bottom: 1px solid $color3;
  padding-bottom: 10px;	
}

.fourth_top_category:after{
display:table;
content:\\"\\";
clear:both;	
}
.fourth_btm_content:after{
display:table;
content:\\"\\";
clear:both;	
}

.fourth_top_category .featured_image{
float: left;
  margin-right: 15px;	
}
.fourth_bottom_category{
float: left;
  margin-right: 10px;
  width: 48.5%;
  margin-bottom: 10px;
  border-bottom: 1px dotted $color4;
  padding-bottom: 10px;
}

.fourth_btm_content .last{
float: right;
}

.sixth_category_inner:after{
display:table;
clear:both;
content:\\"\\";	
}

.sixth_category_inner, .fourth_btm_content{
padding:20px;
background:$color5;	
}

.sixth_top_category .featured_image{
border:1px solid $color4;	
}

.sixth_top_category h4 a{
color:$color2;	
}

.sixth_top_category{
    float: left;
    width: 32%;
    margin-right: 15px;
}

.sixth_category .last{
float:right;
margin-right:0;	
}

.category_seven:after{
display:table;
clear:both;
content:\\\'\\\';	
}

.catseven_left{
float: left;
    width: 58%;
    position: relative;
    margin-right: 15px;	
}

.c_right {
	float:right;
	width:40%;
	position: relative;	
	margin-bottom: 15px;	
}

.c_right_bot {
	width:20%;	
}

.category_seven h4 a{
	color:$color2;	
}

.cblock_title h3{
	font-size: 13px;
    line-height: 20px;
    background-color:$links;
	color:$color5;
    display: inline;
    padding: 5px 10px;
}

.cblock_title {
    position: absolute;
    top: 0px;
}

.category_seven_title h4 {
    font-size: 15px;
    line-height: 22px;
}

.category_seven_title h4 a {
position: absolute;
    left: 0;
    bottom: 0px;
    visibility: visible;
    width: 100%;
    display: block;
    background-color: rgba(0,0,0,0.75);
    color: rgba(255,255,255,1.00);
    padding:10px 20px;	
}

/*content ends here*/

/*slider1starts*/
/* stylesheet for demo and examples */


hr{
	background-color: transparent;
	height: 0;
	border: none;
	border-bottom: 1px solid rgba(255,255,255,0.08);
	border-top: 1px solid rgba(0,0,0,0.9);
	margin: 0;
	clear: both;
}
 #demo{
	overflow:hidden;
	position: relative;
}

#demo{ line-height: 20px; }

nav ul, .callbacks ul, .disable-destroy ul, .show-hide ul, #sortable ul, .dialog ul, .all-themes-switch ul, .scrollTo ul{
	overflow: hidden;
	margin: 0;
	padding: 0;
	list-style: none;
}
#info p{
	font-size: 12px;
	color: $social_flw_bg;
	padding: 6px 15px;
}

.callbacks, .callbacks + p, #examples, .content, .disable-destroy, .show-hide, .dialog, .all-themes-switch, .scrollTo{ -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; }

nav, .callbacks, .disable-destroy, .show-hide, .dialog, .all-themes-switch, .scrollTo{ background: #111; }

nav ul li, .callbacks ul li, .disable-destroy ul li, .show-hide ul li, .dialog ul li, .all-themes-switch ul li, .scrollTo ul li{
	float: left;
	margin: 3px 6px 3px 0;
}

.callbacks ul li.off{ opacity: 0.4; }

.callbacks ul li a, .disable-destroy ul li a, .show-hide ul li a, .dialog ul li a, .all-themes-switch ul li a, .scrollTo ul li a{
	display: block;
	padding: 3px 15px;
	text-decoration: none;
	color: #ccc;
}

.callbacks + p{
	color: $social_flw_bg;
	font-size: 12px;
}

.callbacks + p span{ display: inline-block; }

.callbacks + p span span{
	color: #eee;
	min-width: 40px;
}

.callbacks a span{
	display: inline-block;
	vertical-align: middle;
	width: 14px;
	height: 14px;
	background: $text2;
	margin-right: 3px;
	-webkit-border-radius: 15px; -moz-border-radius: 15px; border-radius: 15px;
}

.callbacks a span.on{ background: #eb3755; }

.callback-offset, .callback-offset-back{
	width: 100%;
	position: absolute;
}

.callback-offset-back{
	top: 0;
	height: 50px;
	border-bottom: 1px dashed #ffed0d;
}

.callback-offset{
	bottom: 0;
	height: 60px;
	border-top: 1px dashed #ffed0d;
}

code{
	color: #caaee1;
	font-family: monospace;
}

.examples{
	overflow: hidden;
}

.examples > hr{ margin: 20px 10px; }

.content{
	overflow: auto;
	position: relative;
	padding: 10px 2px 10px 10px;
	background: $text2;
	width: 740px;
	max-width:100%;
	height: 400px;
	-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box;
}

.content.hidden{ display: none; }

.content.light{
	background-color: $color1;
	color: $text2;
}

.content hr{
	margin-bottom: -10px;
	border-top: 1px solid rgba(0,0,0,0.7);
}

.content.light hr{
	border-bottom: 1px solid rgba(255,255,255,0.6);
	border-top: 1px solid rgba(0,0,0,0.1);
}

.content p{ margin: 30px 0; }

.content p:last-child{ margin-bottom: 5px; }

.content p:nth-child(odd), .content.light p:nth-child(odd){
	background: $color4;
	background: rgba(255,255,255,0.1);
	padding: 5px 10px;
	-webkit-border-radius: 3px; -moz-border-radius: 3px; border-radius: 3px;
}

.content p:nth-child(3n+3){
	color: $social_flw_bg;
	background: none;
	padding: 0;
}

.content.light p:nth-child(odd){
	background: $color2;
	background: rgba(255,255,255,0.8);
}

.content.light p:nth-child(3n+3){ color: #666; }

.content p.full:nth-child(odd), .content p.half:nth-child(odd), 
.content p.full:nth-child(3n+3), .content p.half:nth-child(3n+3){
	background: none;
	padding: 0;
}

.content h2{
	font-size: 200%;
	line-height: 130%;
}

.content h2:first-child{ margin-top: 5px; }

.content:nth-child(odd) h2{
	font-weight: 300;
	font-style: normal;
}

hr + .content:nth-child(odd) h2{
	font-weight: 700;
	font-style: italic;
}

.content.light h2{ color: inherit; }

.content img{
	margin: 0;
	-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box;
	padding: 3px;
	background: rgba(0,0,0,0.2);
}

.content.light img{ background: rgba(255,255,255,0.4); }

.content input[type=\\\'text\\\'], .content textarea{
	border: none;
	background: transparent;
	background-color: $social_flw_bg;
	background-color: rgba(255,255,255,0.6);
	min-height: 20px;
	padding: 5px;
	-moz-box-shadow: inset -1px -1px 1px rgba(255,255,255,0.6), inset 3px 3px 20px rgba(0,0,0,0.5);
	-webkit-box-shadow: inset -1px -1px 1px rgba(255,255,255,0.6), inset 3px 3px 20px rgba(0,0,0,0.5);
	box-shadow: inset -1px -1px 1px rgba(255,255,255,0.6), inset 3px 3px 20px rgba(0,0,0,0.5);
	-webkit-border-radius: 3px; -moz-border-radius: 3px; border-radius: 3px;
	width: 50%;
	font-size: inherit;
	font-family: inherit;
	color: $color5;
}

.content textarea{
	min-height: 80px;
	width: 70%;
}

.content .half img{
	max-width: 48%;
	margin: 0 0 2% 2%;
}

.content .half img:nth-child(odd){ margin: 0 2% 2% 0; }

#demo.showcase{ min-width: 740px; }

.showcase .content{
	float: left;
	width: 340px;
	height: 300px;
}

.showcase .horizontal-images.content{
	height: 140px;
	width: 700px;
	max-width: 97%;
	padding: 5px 5px 0 5px;
}

.showcase .horizontal-images.content h2, .showcase .horizontal-images.content li img{ height: 119px; }

.showcase .horizontal-images.content h2{
	color: $color2;
	background-color: #eb3755;
	padding: 10px 20px;
	margin: 0;
	-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box;
	font-size: 165%;
}

.horizontal-images.content ul, .vertical-images.content ul{
	margin: 0;
	padding: 0;
	list-style: none;
	overflow: hidden;
}

.horizontal-images.content li{
	margin: 0 3px;
	float: left;
}

.vertical-images.content li{ margin: 3px 0; }

.horizontal-images.content li:first-child{ margin-left: 0; }

.vertical-images.content li:first-child{
	margin-bottom: 3px;
	margin-top: 0;
}

.horizontal-images.content li:last-child{ margin-right: 0; }

.vertical-images.content li:last-child{ margin-bottom: 0; }

.horizontal-images.content li img{
	width: auto;
	padding: 0;
}

.showcase #content-1.content{ height: 620px; }

.showcase #content-2.content{ height: 620px; }

.showcase #content-2.content h2{ color: $text2; }

.showcase #content-3.content{
	background-color: #412626;
	background-image: url(\\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAYAAAAGCAYAAADgzO9IAAAAJ0lEQVQIW2NkwA7+M2IR/w8UY0SXAAuCFCNLwAWRJVAEYRIYgiAJALsgBgYbCawOAAAAAElFTkSuQmCC\\");
	margin-right: 40px;
	width: 310px;
}

.showcase #content-3.content h2{ color: #eb3755; }

.showcase #content-4.content{ background-color: #1C383F; }

.showcase #content-4.content h2{ color: #ddd; }

.showcase #content-6.horizontal-images.content{
	padding: 10px 0 5px 0;
	background-color: $color4;
	background-image: url(\\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAAECAYAAACp8Z5+AAAAG0lEQVQIW2NkYGA4A8QmQAwGjDAGNgGwSgwVAFVOAgV/1mwxAAAAAElFTkSuQmCC\\");
}

.showcase #content-6.horizontal-images.content .mCSB_scrollTools{
	margin-left: 10px;
	margin-right: 10px;
}

.showcase #content-6.horizontal-images.content ul{
	margin-left: 10px;
	margin-right: 10px;
}

.showcase #content-6.horizontal-images.content h2{
	color: #222;
	background-color: #c2beb2;
}

.showcase #content-6.horizontal-images.content h2, .showcase #content-6.horizontal-images.content li img{ height: 105px; }

.showcase #content-7.content{ height: 620px; }

.showcase #content-8.content{
	width: 670px;
	height: 580px;
	padding: 0;
	background-color: #151515;
	background-image: url(\\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAYAAAAGCAYAAADgzO9IAAAAK0lEQVQIW2NkwAL+//9vzIguDhZkZDyLIgETBCmGSyALwiXQBcES2ARBEgCUVxc3f8oLcQAAAABJRU5ErkJggg==\\");
	border: 5px solid rgba(0,0,0,0.5);
	margin-right: 40px;
	margin-bottom: 50px;
}

.showcase #content-8.content h2{
	margin-top: 20px;
	margin-left: 20px;
	margin-right: 20px;
}

.showcase #content-8.content p{
	width: 710px;
	float: left;
	margin: 15px 20px;
}

.showcase #content-8.content hr + p{ margin-top: 30px; }

.showcase #content-8.content p:nth-child(3n+1){
	width: 1460px;
	clear: both;
}

.showcase #content-9.content{
	height: 620px;
	background-color: #c2beb2;
	padding: 5px;
}

.showcase #content-9.content .mCSB_container{ margin-right: 21px; }

.showcase #content-9.content h2{
	height: 85px;
	padding: 10px;
	margin-bottom: 0;
	margin-top: 15px;
	font-size: 180%;
	color: $text2;
}

.showcase #content-9.content img{
	padding: 0;
	vertical-align: bottom;
}

#iframe-container{
	width: 90%;
	max-width: 1110px;
	background: $color5;
	overflow: hidden;
}

#iframe-container iframe{ vertical-align: bottom; }

#infinite-scroll .offset{
	display: block;
	width: 100%;
	height: auto;
	color: #ffed0d;
	-webkit-border-radius: 3px; -moz-border-radius: 3px; border-radius: 3px;
}

#infinite-scroll .offset p{
	margin-bottom: 60px;
}

#infinite-scroll .offset .indicator{
	display: block;
	width: 100%;
	height: 100px;
	background: #ffed0d;
	-webkit-border-radius: 3px; -moz-border-radius: 3px; border-radius: 3px;
}

#examples.resizable{ 
	background:$color4; 
	padding-bottom: 30px; 
}

#resizable.content{
	overflow: hidden;
	width: 640px;
	max-width: 80%;
	-webkit-box-sizing: content-box; -moz-box-sizing: content-box; box-sizing: content-box; /* jquery ui resizable bug: http://bugs.jqueryui.com/ticket/8932 */
}

#resizable.content h2{ color: $color4; }

#resizable.content p{ width: 1000px }

.content.fluid{
	width: 90%;
	max-width: 1680px;
}

.content.fluid h2{
	color: #eb3755;
	font-family: \\"Lobster Two\\", \\"Georgia\\", serif;
	font-weight: 700;
	font-style: italic;
}

.content.nested{ height: 600px; }

.content.nested .nested{
	margin: 0 auto;
	background-color: rgba(0,0,0,0.1);
	height: 400px;
}

#content-1.content.nested{ margin-bottom: 40px; }

#content-1.content.nested p{ width: 1000px; }

#content-1.content.nested .nested{
	margin: 20px;
	width: 600px;
	height: 300px;
}

.content.zero-height{ height: 0; }

.content.zero-width{ width: 0; }

.init-hidden #examples{ min-height: 420px; }

.full-page .content{ height: 800px; }

.full-page-alt #mCSB_1_container{
	width: 97% !important; /* override plugin property */
	min-width: 480px;
}

.full-page-alt #mCSB_1_scrollbar_vertical{
	position: fixed;
	margin-right: 30px;
	margin-top: 16px;
	margin-bottom: 16px;
}

.full-page-alt #mCSB_1_scrollbar_horizontal{
	position: fixed;
	margin-bottom: 30px;
	margin-left: 16px;
	margin-right: 16px;
}

.full-page-alt .outer.content{ width: 960px; }

.full-page-alt .horizontal-images.content{
	height: 275px;
	width: 100%;
	margin: 20px auto 10px auto;
}

.full-page-alt .horizontal-images.content img{ height: 200px; }

.content table{
	width: 100%;
	border-collapse: collapse;
	border-top: 1px dashed #666;
	border-left: 1px dashed #666;
	border-right: 1px dashed #666;
	background: rgba(0,0,0,0.1);
}

.content table tr{ border-bottom: 1px dashed #666; }

.content table td{ padding: 10px 20px 9px 20px; }

.sortable{ min-width: 800px; }

#sortable ul{
	margin-top: 20px;
	margin-bottom: 10px;
}

#sortable li{
	margin: 10px 40px;
	background: $color4;
	padding: 5px 10px;
	color: $color2;
	-webkit-border-radius: 3px; -moz-border-radius: 3px; border-radius: 3px;
}

#sortable li:active, #sortable .ui-sortable-helper{ background: #eb3755; }

#examples.tabs, #examples.accordion, #examples.autocomplete{	
	padding: 5px 20px 20px 20px;
	background-color: $text2;
}

#examples.tabs h3, #examples.accordion h3{
	color: $color5;
	font-family: inherit;
	font-style: inherit;
}

#tabs, #tabs-2, #accordion{ 
	width: 600px; 
	max-width:95%; 
}

#examples.tabs .ui-widget-content{ background-image: none; }

#autocomplete{
	border: none;
	background: $color2;
	min-height: 20px;
	padding: 5px 8px;
	font-size: inherit;
	font-family: inherit;
	color: $color5;
	margin-top: 15px;
}

#autocomplete:focus{ outline: none; }

.ui-menu a{
	-webkit-transition: none; 
	-moz-transition: none; 
	-o-transition: none; 
	transition: none;
}

.ui-menu .mCSB_container{ padding: 2px; }

.ui-menu .mCSB_scrollTools{ 
	right: 5px;
	margin-top: 5px;
	margin-bottom: 5px;
}

.bootstrap #examples{ background: transparent; }

.bootstrap #myModal-2 .modal-body{
	max-height: 340px;
	-webkit-box-sizing: content-box; -moz-box-sizing: content-box; box-sizing: content-box;
	margin-bottom: -15px;
}

.bootstrap #myTab{ max-width: 600px; }

.bootstrap #myTab .tab-pane{ padding: 15px 5px 15px 15px; }

body.colorbox-demo #cboxContent, body.colorbox-demo #cboxContent p, body.colorbox-demo #cboxContent a:hover{ color: $text2; }

.all-themes #examples{ padding: 15px 0 0 15px; }

.all-themes .content{
	width: 310px;
	height: 500px;
	margin: 0 20px 20px 0;
	float: left;
}

.all-themes .content h2, .all-themes .content p, .all-themes .content hr{ 
	width: 240px;
	-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box; 
}

.all-themes #content-m h2, .all-themes #content-m p, .all-themes #content-m hr, 
.all-themes #content-md h2, .all-themes #content-md p, .all-themes #content-md hr{ width: 270px; }

.all-themes .content.expanded-content h2, .all-themes .content.expanded-content p, .all-themes .content.expanded-content hr, 
.all-themes #content-m.expanded-content h2, .all-themes #content-m.expanded-content p, .all-themes #content-m.expanded-content hr, 
.all-themes #content-md.expanded-content h2, .all-themes #content-md.expanded-content p, .all-themes #content-md.expanded-content hr{ width: 540px; }

.max-height-example .content{
	height: auto;
	max-height: 400px;
}

.max-width-example{ min-width: 620px; }

.max-width-example .content{ 
	height: auto;
	width: auto;
	max-width: 50%;
	min-width: 600px;
	display: inline-block;
	vertical-align: bottom;
}

.max-width-example .content ul{
	max-height: 135px;
	overflow-y: hidden;
}

.max-width-example .content img, .max-width-example .content ul li > a{
	height: 130px;
	border: 3px solid $color4;
}

.max-width-example .content ul li > a{
	display: block;
	padding: 20px;
	-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box; 
	background: rgba(0,0,0,0.3);
}

.snap-scrolling-example .content{ 
	height: auto; 
	width: 853px;
}

.snap-scrolling-example .content img{ height: 160px; }

.textarea-example .content{ width: 360px; }

.textarea-example .content form{ margin: 25px 0 15px 0; }

.textarea-example .content textarea, .textarea-example .textarea-clone{
	width: 300px;
	padding: 0 10px;
	line-height:25px;
	-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box;
}

.textarea-example .content textarea{
	height:160px; 
	resize:none; 
	overflow:hidden; 
	outline:none;
	margin: 0;
	border:none;
	background:transparent;
	box-shadow: none;
}

.textarea-example .content .textarea-wrapper{
	height:182px; 
	overflow:hidden;
	background-color: #bbb;
	background-color: rgba(255,255,255,0.6);
	-moz-box-shadow: inset -1px -1px 1px rgba(255,255,255,0.6), inset 3px 3px 20px rgba(0,0,0,0.5);
	-webkit-box-shadow: inset -1px -1px 1px rgba(255,255,255,0.6), inset 3px 3px 20px rgba(0,0,0,0.5);
	box-shadow: inset -1px -1px 1px rgba(255,255,255,0.6), inset 3px 3px 20px rgba(0,0,0,0.5);
	-webkit-border-radius: 3px; -moz-border-radius: 3px; border-radius: 3px;
}

.textarea-example .textarea-clone{
	position:absolute; 
	top:-9999px; 
	left:-9999px; 
	visibility:hidden; 
	min-height: 160px; 
	word-wrap: break-word;
	white-space: pre-wrap;
}

.textarea-example .content .textarea-wrapper .mCSB_scrollTools{ margin: 10px 5px; }

.scrollTo-demo .content{ height: 290px; }

.scrollTo-demo .demo-y{ height: 600px; }

.scrollTo-demo .demo-x{
	width: 660px;
	background-color: #252525;
}

.scrollTo-demo .demo-x p{
	float: left;
	width: 300px;
	margin-left: 30px;
	height: auto;
	padding: 5px 10px;
	background-color: $text2;
	-webkit-border-radius: 3px; -moz-border-radius: 3px; border-radius: 3px;
}

.scrollTo-demo .demo-x hr + p{ margin-left: 0; }

.scrollTo-demo .demo-yx{ background-color: #424242; }

.scrollTo-demo .demo-yx p{ width: 1000px; }

.scrollTo{ font-size: 12px; }

.scrollTo + .scrollTo{ margin-top: 20px; }

.scrollTo ul li:first-child span{
	display: block;
	padding: 3px 15px;
}

#test-id{
	background-color: #eb3755;
	color: $color2;
}

.rtl-demo #content-1{ width: 500px; }

.rtl-demo #content-1 p{ width: 1000px; }

.transitions #examples{
	-webkit-perspective: 1000;
	-moz-perspective: 1000;
}

.transitions .content{
	-webkit-transition: all .6s ease-out; 
	-moz-transition: all .6s ease-out; 
	-o-transition: all .6s ease-out; 
	transition: all .6s ease-out; 
}

@media only screen and (min-width: 1229px){
	.showcase .horizontal-images.content{ width: 1060px; }
}

@media only screen and (min-width: 1629px){
	.showcase .horizontal-images.content{ width: 700px; }
}



/*slider one ends*/

/* clearfix */
.owl-carousel .owl-wrapper:after {
content: \\".\\";
display: block;
clear: both;
visibility: hidden;
line-height: 0;
height: 0;
}
/* display none until init */
.owl-carousel{
display: none;
position: relative;
width: 100%;
}
.owl-carousel .owl-wrapper{
display: none;
position: relative;
-webkit-transform: translate3d(0px, 0px, 0px);
}
.owl-carousel .owl-wrapper-outer{
overflow: hidden;
position: relative;
width: 100%;
}
.owl-carousel .owl-wrapper-outer.autoHeight{
-webkit-transition: height 500ms ease-in-out;
-moz-transition: height 500ms ease-in-out;
-ms-transition: height 500ms ease-in-out;
-o-transition: height 500ms ease-in-out;
transition: height 500ms ease-in-out;
}

.owl-carousel .owl-item{
float: left;
}
.owl-controls .owl-page,
.owl-controls .owl-buttons div{
cursor: pointer;
}
/* fix */
.owl-carousel  .owl-wrapper,
.owl-carousel  .owl-item{
-webkit-backface-visibility: hidden;
-moz-backface-visibility:    hidden;
-ms-backface-visibility:     hidden;
-webkit-transform: translate3d(0,0,0);
-moz-transform: translate3d(0,0,0);
-ms-transform: translate3d(0,0,0);
}

#sync1 .item{
color: $text2;
-webkit-border-radius: 3px;
-moz-border-radius: 3px;
border-radius: 3px;
text-align: center;
}

.owl-controls .owl-buttons .owl-prev {
  display: inline-block;
  position: absolute;
  left: 20px;
  line-height: 24px;
  margin: -27px 0 0 -19px;
  opacity: 1;
padding: 6px $x_half;	
  top: 50%;
  font-size: 0;
  height: 38px;
  width: 38px;
background: $color5;
	opacity:0.6;
	color:$color2;
}

 .owl-controls .owl-buttons .owl-prev:before {
  font-family: \\\'icomoon\\\';
  content: \\\'\\\\f100\\\';
  font-size: 18px;

}

 .owl-controls .owl-buttons .owl-next {
  display: inline-block;
  position: absolute;
  right: 0px;
  line-height: 24px;
  margin: -27px 0 0 -19px;
  opacity: 1;
 padding: 7px 16px;
  top:50%;
  font-size: 0;
   height: 38px;
  width: 38px;
background: $color5;
	opacity:0.6;
transition: 0.5s ease-in-out;
  -webkit-transition: 0.5s ease-in-out;
  -o-transition: 0.5s ease-in-out;
  -moz-transition: 0.5s ease-in-out;
	color:$color2;	
}
.owl-controls .owl-buttons .owl-next:before {
  font-family: \\\'icomoon\\\';
  content: \\\'\\\\f101\\\';
  font-size: 18px;
}

.owl-controls .owl-buttons .owl-next:hover, .owl-controls .owl-buttons .owl-prev:hover{
color:$links;	
}

.demo_container{
padding: 0 20px 20px 20px;	
}

.item{
position:relative;	
}

.item h4{
position: absolute;
    bottom: 0px;
    font-size: 15px;
    text-transform: uppercase;
    line-height: 29px;
    padding: 10px 20px;
    display: inline;
    background: rgba(0, 0, 0, 0.5);
}

.item h4 a{
 color:$color2;
}
.item h4 a:hover{
	color:$links;	
}

.demo_container .block_title .title_clr {
    color:$links;	
}

.item .cat_title{
position: absolute;
    top:0px;
}
.item .cat_title a{
background-color: $links;	
    text-transform: uppercase;
    color: $color5;
    display: inline-block;
    font-size: 12px;
    line-height: 23px;
    padding: 0px 8px 0px 8px;
}

.item .cat_title a:hover{
background-color: $color5;
    color:$links;	
}

/*sidebar starts here*/
.sidebar .widget{
    margin-bottom: 30px;
}

.block_title .widget_title {
    color:$links;	
}

.popular {
  margin-bottom: 15px;
  padding-bottom: 15px;
  border-bottom: 1px dotted $color1;	
}
.popular:after{
content:\\"\\";
display:table;
clear:both;	
}
.popular .featured_image{
float:left;
margin-right:10px;	
}

.inner_popular {
overflow: hidden;	
}

.inner_popular h3 {
font-size: 14px;
  line-height: 23px;
	margin-bottom:5px;
  }


.inner_popular .byline{
font-size: 12px;
  color: $text1;
}

.inner_popular .byline:before, .post_date:before, .related_posts span:before, .comment_date:before, .byline .date:before{
font-family: \\\'icomoon\\\';
  content: \\\'\\\\f017\\\';
  padding-right: 4px;	
}

.recently_updated_posts ul {
  counter-reset: my-badass-counter;
	margin-left:0px;
}
.recently_updated_posts li {
  list-style: none;
  padding: 0 3px 11px 3px;
  color:$text1;
  font-size: 14px;
}

.recently_updated_posts li:before {
  content: counter(my-badass-counter);
  counter-increment: my-badass-counter;
  padding: 3px 12px 5px 0;
  font-size: 17px;
  line-height: 1em;
  color: $text1;
  font-weight: bold;
  float: left;
}

.recently_updated_posts li a {
font-size: 14px;
line-height: 24px;	
  color: $text2;
}
.recently_updated_posts li a:hover{
text-decoration:none;
color:$links;	
}

.social_follow {
display: inline-block;
}

.social_follow i{
	border-radius: 5px;
	-webkit-border-radius: 5px;
	-moz-border-radius: 5px;
    display: inline-block;
    color: $color2;
    background: $social_flw_bg;
    transition: .2s ease-in-out;
    -webkit-transition: .2s ease-in-out;
    -moz-transition: .2s ease-in-out;
    font-size: 17px;
    padding: 10px 12px;
    margin-right: 8px;
    margin-bottom: 8px;
}

.fa-facebook:before{
content:\\\'\\\\e60c\\\';	
}


.fa-facebook:hover{
background:#3D69C7;
}


.fa-twitter:before{
content:\\\'\\\\e60d\\\';	
}

.fa-twitter:hover{
background:#2EB8F3;
}

.fa-rss:before{
content:\\\'\\\\e602\\\';	
}

.fa-rss:hover{
background:#E9543F;
}

.fa-linkedin:before{
content:\\\'\\\\e608\\\';	
}

.fa-linkedin:hover{
background:#FF47A2;
}

.fa-youtube:before{
content:\\\'\\\\e603\\\';	
}


.fa-youtube:hover{
background:#4A84AE;
}


.fa-pinterest:before{
content:\\\'\\\\e609\\\';	
}


.fa-pinterest:hover{
background:#DF2F37;
}


.fa-google-plus:before{
content:\\\'\\\\e601\\\';	
}


.fa-google-plus:hover{
background:#c3391c;
}

.fa-vimeo:before{
content:\\\'\\\\e604\\\';	
}

.fa-vimeo:hover{
background:#1bb7ea;
}

.fa-tumblr:before{
content:\\\'\\\\e607\\\';	
}

.fa-tumblr:hover{
background:#2b4761;
}
.fa-dribbble:before{
content:\\\'\\\\e606\\\';	
}

.fa-dribbble:hover{
background:#E49EBE;
}
.fa-flickr:before{
content:\\\'\\\\e605\\\';	
}

.fa-flickr:hover{
background:#0063db;
}

.avt_rec {
  overflow: hidden;
  margin-bottom: 10px;
  padding-bottom: 10px;
  border-bottom: 2px dotted #e3e3e3;
}

.avt_img {
		width:16%;
  float: left;
  margin-right: 15px;
		position:relative;
}

.avt_img img{
width:50px!important;
height:50px!important;	
}

.avt_rec a{
font-size: 14px;
  line-height: 24px;	
}

.rec_aut{
overflow: hidden;
    background-color: $color3;
    padding: 10px;

}

.avt_img::before {
   content: \\" \\";
    display: block;
    width: 0;
    height: 0;
    border-top: 13px solid transparent;
    border-bottom: 14px solid transparent;
    border-right: 16px solid $color3;
    position: absolute;
    top: 28%;
    left: 100%;
    z-index: 1;
}

.newsimg_posts:after{
display:table;
clear:both;
content:\\\'\\\';	
}

.newsimg {
    float: left;
	width: 31.45%;
    margin-right: 9px;
    margin-bottom: 7px;
}

.newsimg_posts .last {
    margin-right: 0;
    float: right;
}
.sb_newmagaz_optin .block_title{
margin-bottom:0px;	
}

.sb_newmagaz_optin form{
background-color: $color3;
padding: 40px 20px;	
box-shadow: 0px 0px 5px 1px $color1;
-webkit-box-shadow:  0px 0px 5px 1px $color1;
-moz-box-shadow:  0px 0px 5px 1px $color1;
}

.sb_newmagaz_optin .names {
  position: relative;
}

.sb_newmagaz_optin input[type=\\"text\\"] {
  border: 1px solid $color1;
  padding: 12px 15px;
  color: $color4;
	font-size:14px;
  width: 100%;
  margin-bottom: 25px;
  outline: none;
  position: relative;
}

.sb_newmagaz_optin .admins:before {
  font-family: \\\'icomoon\\\';
  content: \\\'\\\\f007\\\';
  position: absolute;
  right: 12px;
  top: 8px;
}

.sb_newmagaz_optin input[type=\\"submit\\"] {
 background-color:$links;	
  color: $color5;
  padding: 7px 21px;
  border: none;
  height: 38px;
	font-size:14px;
  cursor: pointer;
transition: ease-in-out .4s;
  -webkit-transition: ease-in-out .4s;
  -moz-transition: ease-in-out .4s;	
}

.sb_newmagaz_optin input[type=\\"submit\\"]:hover{
 background-color: $color5;
color:$links;	
}

.sb_newmagaz_optin .mails:before {
  font-family: \\\'icomoon\\\';
  content: \\\'\\\\f003\\\';
  position: absolute;
  right: 12px;
  top: 8px;
}

/*sidebar ends here*/
/*footer starts here*/
.top_footer{
background-color: $ctr_hdr_bg;
    color: $color2;
    padding: 40px 20px 10px 20px;
}

.widget_recent_entries ul li a:hover{
text-decoration:none;	
}

.top_footer a, .textwidget{
	color:$ftext_clr;	
	font-size:16px;
	line-height:27px;
}

.top_footer a:hover{
color:$links;
text-decoration:none;		
}


.top_footer:after{
display:table;
clear:both;
content:\\\'\\\';	
}

.top_footer .widget{
float:left;	
width:23%;
margin-right:20px;		
}

.top_footer .widget_categories {
float:right;
margin-right:0;	
}

.top_footer .widget .widget_title{
font-size: 18px;
    line-height: 30px;
    margin-bottom: 10px;
	    padding-left: 15px;
    text-transform: uppercase;
position:relative;	
}

.top_footer .widget .widget_title:before {
    content: \\\'\\\';
    position: absolute;
   width: 4px;
    height: 15px;
    left: 0;
    top: 21%;
    background-color:$links;
}

.widget_recent_entries ul li {
    line-height: 27px;
    padding: 0 0 10px 23px;
    position: relative;
    border-bottom: 1px dotted #5B5A5A;
}

.widget_recent_entries ul li a:before{
    font-family: \\\'icomoon\\\';
    content: \\\'\\\\f054\\\';
    padding-right: 15px;
    font-size: 12px;
    position: absolute;
    top: 2px;
    left: 0;
    color: $ftext_clr;	
}


.top_footer .tagcloud a {
    font-size: 14px!important;
    background-color: $search_bg;
    padding: 0px 13px;
    display: inline-block;
    margin-bottom: 9px;
    margin-right: 5px;
}

.widget_categories .widget_title:before{
  width: 3px!important;	
}

.widget_categories ul li a:before {
    font-family: \\\'icomoon\\\';
    content: \\\'\\\\f06d\\\';
    padding-right: 8px;
}

.bottom_footer{
background-color:$tb_header_bg;
    text-align: center;
    padding: 10px 0;	
}
.bottom_footer p{
font-size: 14px;
    font-weight: bold;
    color:  $ftext_clr;	
}

/*footer ends here*/

/*landing page starts here*/
.landing_page .post_box {
    margin-bottom: 0px;
}

.landing_page .inner_content{
padding:20px 20px 20px 0;	
}

.landing_page .single_postbox{
padding-left:30px;	
}

.optin_video_box_inner:after{
display:table;
clear:both;
content:\\\'\\\';	
}

.ovb_left{
float:left;
width:50%;	
}

.ovb_right {
    float: right;
    width: 50%;
    padding: 0 45px;
}

.right_newmagaz_optin h2{
font-size: 33px;
    line-height: 45px;
    color: $text2;	
}


.right_newmagaz_optin form .names {
    width: 100%;
    margin-right: 10px;
    margin-bottom: 20px;
    position: relative;
}

.right_newmagaz_optin input[type=\\"text\\"] {
    color: $color5;
    width: 100%;
	height: 52px;
    padding: 10px 12px;
    font-size: 14px;
    line-height: 1.42857143;
    background-color: $color2;
    border: 1px solid $color1;
    outline: 0;
}

.right_newmagaz_optin .admins:before {
    font-family: \\\'icomoon\\\';
    content: \\\'\\\\f007\\\';
    position: absolute;
    right: 12px;
    top: 8px;
    color: $color5;
}

.right_newmagaz_optin .mails:before {
    font-family: \\\'icomoon\\\';
    content: \\\'\\\\f003\\\';
    position: absolute;
    right: 12px;
    top: 8px;
    color:$color5;
}

.right_newmagaz_optin input[type=\\"submit\\"] {
    color:$links;	
    background-color:$color5;
    border: 3px solid rgba(0,0,0,.15);
    border-width: 0 0 4px 0;
    width: 100%;
	height: 52px;
    display: block;
    cursor: pointer;
    padding: 16px 16px;
    font-size: 18px;
    line-height: 1.33;
    outline: 0;
    transition: ease-in-out .4s;
    -webkit-transition: ease-in-out .4s;
    -moz-transition: ease-in-out .4s;
}

.right_newmagaz_optin input[type=\\"submit\\"]:hover{
color:$color5;	
    background-color:$links;	
}

.optin_video_box_inner{
padding: 40px;
    background-color: $color3;
}

.right_newmagaz_optin p{
font-size: 16px;
    padding: 5px 0 15px 0;
    color: $text1;
}

.landing_feature_box{
padding: 0px 10px 0px 30px;
    margin-bottom: 20px;
}

.feature_box_header_para {
    margin: 10px 0 25px 0;
    text-align: center;
}

.feature_box_header_para h3{
font-size: 29px;
    line-height: 40px;
}

.feature_box_content:after{
display:table;
clear:both;
content:\\\'\\\';	
}

.column_one{
float: left;
    width: 32%;
    margin-right: 20px;	
}

.feature_box_content .ftr_last{
float:right;
margin-right:0;	
}

.column_one h4{
font-size: 23px;
    line-height: 34px;
    margin: 10px 0;	
}

.column_one p{
font-size: 17px;
    line-height: 32px;
padding-bottom:20px;
color:$text1;
}

/*landing page ends here*/

/*errorpage starts*/
.error_page {
  text-align: center;
	padding:70px 20px;
}
.error_page h2 {
  font-size: 46px;
  line-height: 58px;
}
.error_page p {
  margin: 20px 0 30px 0
}

.error_page a {
color: $color2;
padding: 14px 31px;
font-size: 15px;
font-weight: 700;
background: $text2;
text-transform: uppercase;
box-shadow: 3px 4px 4px $color1;
-webkit-box-shadow: 3px 4px 4px $color1;
-moz-box-shadow: 3px 4px 4px $color1;
}

.error_page a:hover {
 background: $links;
}
/*errorpage ends*/

/*media Starts*/

@media screen and (max-width:1200px){
.container{
width:1000px;		
	}
.first_lat_news {
    width: 49.65%;	
}
	
.btm_lat_news {
    float: left;
    width: 32.95%;
	}
.content_left{
	width:700px;	
	}
.sidebar{
width:300px;		
	}
	
.newsimg {
     margin-bottom: 9px;
    width: 31%
}	
	
.first_left_category {
    width: 49%;
    margin-right: 12px;
}	
	
.column_one {
    margin-right: 18px;
}	
	
.author_right{
width: 82%;		
}
	
.related_posts {
    margin-right: 13px;
}	
	
.right_cmt_cnt {
    width: 88%;
}	
	
.single_postbox{
	margin-bottom: 0;	
	}
	
.sixth_top_category{
	margin-right: 12px;	
	}
	
.catseven_left{
	width: 57%;	
	}
	
.c_right {
    width: 39%;	
	}
.fourth_bottom_category{
	width: 47%;	
	}
.block_title:after{
left: -5px;		
	}
	
}

@media screen and (max-width:1022px){	
.btm_header.scrolltop {
    width: 100%;
    height: 58px;
}
	
.top_right {
    height: auto;
}	
.fourth_bottom_category {
    width: 48%;
}	
	
.fourth_btm_content .last {
    float: left;
} 	
	
.fourth_category .fourth_bottom_category {
    width: 47%;
}
.container{
width:100%;		
	}	
	
.content_left{
	width:100%;
	margin-bottom:20px;
	}
	
.sidebar{
width: 55%;
    padding-left: 20px;
    float: left;		
	}	
	
.top_left {
    width: 100%;
}	
	
.top_right {
  float: none;
    margin-bottom: 10px;
    text-align: center;
}
	
.newmagaz_logo {
    float: none;
    margin-bottom: 15px;
    margin-top: 0;
}
	
.newmagaz_logo img{
margin:0 auto;		
	}
	
.btm_lat_news {
    width: 32.8%;
}	
			
.newsimg {
    margin-bottom: 9px;
    width: 14%;
}	
	
.newsimg_posts .last {
    margin-right: 9px;
    float: left;
}

.top_footer .widget_categories {
    float: left;
    margin-right: 20px;
}

.top_footer .widget {
    width: 47%;
}
	
.news-ticker_title {
    float: none;
}
	
.news-ticker {
    margin-bottom: 15px;
    text-align: center;
}
	
.column_one {
    margin-right: 14px;
}	
.optin_video_box_inner {
    padding: 20px;
	}
	
.ovb_right {
    padding: 0 0px 0 25px;
}	
	
.right_newmagaz_optin h2 {
    font-size: 28px;
    line-height: 38px
	}
	
.avt_img {
    width: 13%;
}
	
.catseven_left{
	    width: 58%;	
	}
	
.c_right {
   width: 39%;
    margin-bottom: 18px;
}	
.sixth_top_category {
    margin-right: 10px;
}	
	
.btm_header {
    height: 58px;
	}
			
/*menu control*/
.menu_control {
	background-color: $tb_header_bg;
		display: block;
		width: 100%;
		border-width: 0;
		padding: 20px 25px;
		cursor: pointer;
		-webkit-box-sizing: border-box;
		-moz-box-sizing: border-box;
		box-sizing: border-box;
		text-align: center;
	}
	
	.menu {
		display: none;
		width: 100%;
		border-width: 1px 0 0 0;
		clear: both;
	}
	.show_menu {
		display: block;
	}
.menu .sub-menu {
		
		border-top: 1px solid $color1;
		opacity: 1;
visibility: visible;
	}
	
.menu .sub-menu {
  position: static;
  display: block;
  margin: 0;
  visibility: visible;
  opacity: 1;
  width: 100%;
  -webkit-transform: initial;
  -moz-transform: initial;
  -ms-transform: initial;
  -o-transform: initial;
  transform: initial;
}	
	
	.menu li {
		width: 100%;
		float: none;
		margin-bottom: 0;
	}
	.menu .sub-menu li {
		width: 100%;
	}
	
	.menu a {
		border-width: 1px 1px 0 0;
		padding: 1em 25px;
	}
	.menu .current-menu-item > a {
		background-color: $color1;	
	}
	.menu > li > a {
		border-left-width: 1px;
  background-color: $color2;
  color: $text2;
	}
	
	.menu > li > a:hover{
		background-color: $color5;
  color: $color2;		
	}
	.menu li:first-child > a:first-child {
		border-top-width: 0;
	}
				
.squeeze_video iframe{
position:absolute;
top:0;
left:0;
width:100%;
height:100%;		
}
.squeeze_video {
float: none;
clear: both;
width: 100%;
position: relative;
padding-bottom: 56.25%;
padding-top: 25px;
height: 0;		
}
	
.single_cont_left{
padding-right:10px!important;		
	}
	
.top_header{
padding: 0 10px 0 10px; 		
	}
	
}

@media screen and (max-width:767px){
	
.first_lat_news, .btm_lat_news {
    width: 100%;
margin-bottom: 10px;		
}
	
.fourth_bottom_category{
    width: 100%;
}	
	
.first_left_category {
    width: 100%;
	 margin-bottom: 10px;	
	}
	
.first_right_category {
    float: left;
    width: 100%;
   
}	
	
#nt-title-container ul li h4{
font-size: 24px;
line-height: 32px;
}	
.second_category {
    width: 100%;
}	
.s_b_c_l {
    width: 20%;
}	
	
.s_b_c_r {
    width: 76%;
}	
	
.newsimg {
    width: 24%;
}	

.sidebar{
width:100%;		
	}
.top_footer .widget {
    width: 100%;
}	
	
.ovb_left {
    width: 100%;
}	
	
.ovb_right {
    float: left;
    width: 100%;
    padding: 15px 0;
}	
	
.column_one {
    width: 100%;
    margin-bottom: 15px;
}	
	
.post_left {
    width: 100%;	
	}	
	
.post_box {
    margin-left: 20px;
    margin-bottom: 20px;
}	
	
.single_postbox {
    margin-left: 0;
}	
	
.author_right {
    width: 71%;
}
.related_posts {
    float: none;
    width: 100%;
    margin-bottom: 15px;
}
.newmagaz_related_box .last{
	margin-bottom: 0;	
	}
	
.right_cmt_cnt {
    width: 83%;
}	
	
.single_byline {
    padding: 11px 20px;
	}
	
.avt_img {
    width: 12%;
}	
	
.fourth_top_category .featured_image {
    float: none;	
	}
	
.fourth_top_category h4{
margin-top: 10px;		
	}
	
	
.sixth_top_category {
    width: 100%;
	margin-bottom: 10px;	
	}
	
.sixth_category_inner .last{
	margin-bottom:0;	
	}
	
#demo{
float: left;		
	}
	
.content{
width: 100%;		
	}
	
.catseven_left {
	width: 100%;
    margin-right: 0;
    margin-bottom: 15px;	
	}
	
.c_right {
    width: 100%;
    margin-bottom: 15px;
}	

.post_right{
padding: 14px 20px 0px 0px;		
	}
	
.post_left{	
padding:0;	
}	
	
.fourth_category .fourth_bottom_category {
    width: 100%;
}	
	
.first_left_category h4, .second_top_category h4 {
    font-size: 18px;
    line-height: 28px;
    padding-top: 10px;
}	
	
.first_left_category p {
    font-size: 14px;
	}
	
}

@media screen and (max-width:479px){
.f_r_c_l {
    width: 34%;
}	
	
.s_b_c_l {
    width: 30%;
    margin-right: 10px;
}

.s_b_c_r {
    width: 66%;
}

.newsimg {
    width: 30%;
}	
	
.post_left {
    float: none;
    width: 100%;
}	
	
.news-ticker_content {
    width: 100%;
}	
	
.author_right {
    width: 100%;
	margin-top:5px;	
}	
	
.first_category, .fourth_category, .fifth_category{
    margin-bottom: 15px;
}	

.avt_img {
    width: 19%;
}
	
.s_b_c_r {
    width: 65%;
}	
		
}

@media screen and (max-width:319px){
.hme_pst_bx .num_comments_link {
    float: left;
}
.avt_img {
    width: 27%;
}

}
	
	.mCustomScrollBox{ /* contains plugin\\\'s markup */
		position: relative;
		overflow: hidden;
		height: 100%;
		max-width: 100%;
		outline: none;
		direction: ltr;
	}

	.mCSB_container{ /* contains the original content */
		overflow: hidden;
		width: auto;
		height: auto;
	}



/* 
------------------------------------------------------------------------------------------------------------------------
2. VERTICAL SCROLLBAR 
y-axis
------------------------------------------------------------------------------------------------------------------------
*/

	.mCSB_inside > .mCSB_container{ margin-right: 30px; }

	.mCSB_container.mCS_no_scrollbar_y.mCS_y_hidden{ margin-right: 0; } /* non-visible scrollbar */
	
	.mCS-dir-rtl > .mCSB_inside > .mCSB_container{ /* RTL direction/left-side scrollbar */
		margin-right: 0;
		margin-left: 30px;
	}
	
	.mCS-dir-rtl > .mCSB_inside > .mCSB_container.mCS_no_scrollbar_y.mCS_y_hidden{ margin-left: 0; } /* RTL direction/left-side scrollbar */

	.mCSB_scrollTools{ /* contains scrollbar markup (draggable element, dragger rail, buttons etc.) */
		position: absolute;
		width: 16px;
		height: auto;
		left: auto;
		top: 0;
		right: 0;
		bottom: 0;
	}

	.mCSB_outside + .mCSB_scrollTools{ right: -26px; } /* scrollbar position: outside */
	
	.mCS-dir-rtl > .mCSB_inside > .mCSB_scrollTools, 
	.mCS-dir-rtl > .mCSB_outside + .mCSB_scrollTools{ /* RTL direction/left-side scrollbar */
		right: auto;
		left: 0;
	}
	
	.mCS-dir-rtl > .mCSB_outside + .mCSB_scrollTools{ left: -26px; } /* RTL direction/left-side scrollbar (scrollbar position: outside) */

	.mCSB_scrollTools .mCSB_draggerContainer{ /* contains the draggable element and dragger rail markup */
		position: absolute;
		top: 0;
		left: 0;
		bottom: 0;
		right: 0; 
		height: auto;
	}

	.mCSB_scrollTools a + .mCSB_draggerContainer{ margin: 20px 0; }

	.mCSB_scrollTools .mCSB_draggerRail{
		width: 2px;
		height: 100%;
		margin: 0 auto;
		-webkit-border-radius: 16px; -moz-border-radius: 16px; border-radius: 16px;
	}

	.mCSB_scrollTools .mCSB_dragger{ /* the draggable element */
		cursor: pointer;
		width: 100%;
		height: 30px; /* minimum dragger height */
		z-index: 1;
	}

	.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ /* the dragger element */
		position: relative;
		width: 4px;
		height: 100%;
		margin: 0 auto;
		-webkit-border-radius: 16px; -moz-border-radius: 16px; border-radius: 16px;
		text-align: center;
	}
	
	.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded .mCSB_dragger_bar, 
	.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_dragger .mCSB_dragger_bar{ width: 12px; /* auto-expanded scrollbar */ }
	
	.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail{ width: 8px; /* auto-expanded scrollbar */ }

	.mCSB_scrollTools .mCSB_buttonUp,
	.mCSB_scrollTools .mCSB_buttonDown{
		display: block;
		position: absolute;
		height: 20px;
		width: 100%;
		overflow: hidden;
		margin: 0 auto;
		cursor: pointer;
	}

	.mCSB_scrollTools .mCSB_buttonDown{ bottom: 0; }



/* 
------------------------------------------------------------------------------------------------------------------------
3. HORIZONTAL SCROLLBAR 
x-axis
------------------------------------------------------------------------------------------------------------------------
*/

	.mCSB_horizontal.mCSB_inside > .mCSB_container{
		margin-right: 0;
		margin-bottom: 30px;
	}
	
	.mCSB_horizontal.mCSB_outside > .mCSB_container{ min-height: 100%; }

	.mCSB_horizontal > .mCSB_container.mCS_no_scrollbar_x.mCS_x_hidden{ margin-bottom: 0; } /* non-visible scrollbar */

	.mCSB_scrollTools.mCSB_scrollTools_horizontal{
		width: auto;
		height: 16px;
		top: auto;
		right: 0;
		bottom: 0;
		left: 0;
	}

	.mCustomScrollBox + .mCSB_scrollTools.mCSB_scrollTools_horizontal,
	.mCustomScrollBox + .mCSB_scrollTools + .mCSB_scrollTools.mCSB_scrollTools_horizontal{ bottom: -26px; } /* scrollbar position: outside */

	.mCSB_scrollTools.mCSB_scrollTools_horizontal a + .mCSB_draggerContainer{ margin: 0 20px; }

	.mCSB_scrollTools.mCSB_scrollTools_horizontal .mCSB_draggerRail{
		width: 100%;
		height: 2px;
		margin: 7px 0;
	}

	.mCSB_scrollTools.mCSB_scrollTools_horizontal .mCSB_dragger{
		width: 30px; /* minimum dragger width */
		height: 100%;
		left: 0;
	}

	.mCSB_scrollTools.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{
		width: 100%;
		height: 4px;
		margin: 6px auto;
	}
	
	.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded .mCSB_dragger_bar, 
	.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_dragger .mCSB_dragger_bar{
		height: 12px; /* auto-expanded scrollbar */
		margin: 2px auto;
	}
	
	.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail{
		height: 8px; /* auto-expanded scrollbar */
		margin: 4px 0;
	}

	.mCSB_scrollTools.mCSB_scrollTools_horizontal .mCSB_buttonLeft,
	.mCSB_scrollTools.mCSB_scrollTools_horizontal .mCSB_buttonRight{
		display: block;
		position: absolute;
		width: 20px;
		height: 100%;
		overflow: hidden;
		margin: 0 auto;
		cursor: pointer;
	}
	
	.mCSB_scrollTools.mCSB_scrollTools_horizontal .mCSB_buttonLeft{ left: 0; }

	.mCSB_scrollTools.mCSB_scrollTools_horizontal .mCSB_buttonRight{ right: 0; }



/* 
------------------------------------------------------------------------------------------------------------------------
4. VERTICAL AND HORIZONTAL SCROLLBARS 
yx-axis 
------------------------------------------------------------------------------------------------------------------------
*/

	.mCSB_container_wrapper{
		position: absolute;
		height: auto;
		width: auto;
		overflow: hidden;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		margin-right: 30px;
		margin-bottom: 30px;
	}
	
	.mCSB_container_wrapper > .mCSB_container{
		padding-right: 30px;
		padding-bottom: 30px;
	}
	
	.mCSB_vertical_horizontal > .mCSB_scrollTools.mCSB_scrollTools_vertical{ bottom: 20px; }
	
	.mCSB_vertical_horizontal > .mCSB_scrollTools.mCSB_scrollTools_horizontal{ right: 20px; }
	
	/* non-visible horizontal scrollbar */
	.mCSB_container_wrapper.mCS_no_scrollbar_x.mCS_x_hidden + .mCSB_scrollTools.mCSB_scrollTools_vertical{ bottom: 0; }
	
	/* non-visible vertical scrollbar/RTL direction/left-side scrollbar */
	.mCSB_container_wrapper.mCS_no_scrollbar_y.mCS_y_hidden + .mCSB_scrollTools ~ .mCSB_scrollTools.mCSB_scrollTools_horizontal, 
	.mCS-dir-rtl > .mCustomScrollBox.mCSB_vertical_horizontal.mCSB_inside > .mCSB_scrollTools.mCSB_scrollTools_horizontal{ right: 0; }
	
	/* RTL direction/left-side scrollbar */
	.mCS-dir-rtl > .mCustomScrollBox.mCSB_vertical_horizontal.mCSB_inside > .mCSB_scrollTools.mCSB_scrollTools_horizontal{ left: 20px; }
	
	/* non-visible scrollbar/RTL direction/left-side scrollbar */
	.mCS-dir-rtl > .mCustomScrollBox.mCSB_vertical_horizontal.mCSB_inside > .mCSB_container_wrapper.mCS_no_scrollbar_y.mCS_y_hidden + .mCSB_scrollTools ~ .mCSB_scrollTools.mCSB_scrollTools_horizontal{ left: 0; }
	
	.mCS-dir-rtl > .mCSB_inside > .mCSB_container_wrapper{ /* RTL direction/left-side scrollbar */
		margin-right: 0;
		margin-left: 30px;
	}
	
	.mCSB_container_wrapper.mCS_no_scrollbar_y.mCS_y_hidden > .mCSB_container{ 
		padding-right: 0; 
		-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box;
	}
	
	.mCSB_container_wrapper.mCS_no_scrollbar_x.mCS_x_hidden > .mCSB_container{ 
		padding-bottom: 0; 
		-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box;
	}
	
	.mCustomScrollBox.mCSB_vertical_horizontal.mCSB_inside > .mCSB_container_wrapper.mCS_no_scrollbar_y.mCS_y_hidden{
		margin-right: 0; /* non-visible scrollbar */
		margin-left: 0;
	}
	
	/* non-visible horizontal scrollbar */
	.mCustomScrollBox.mCSB_vertical_horizontal.mCSB_inside > .mCSB_container_wrapper.mCS_no_scrollbar_x.mCS_x_hidden{ margin-bottom: 0; }



/* 
------------------------------------------------------------------------------------------------------------------------
5. TRANSITIONS  
------------------------------------------------------------------------------------------------------------------------
*/

	.mCSB_scrollTools, 
	.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCSB_scrollTools .mCSB_buttonUp,
	.mCSB_scrollTools .mCSB_buttonDown,
	.mCSB_scrollTools .mCSB_buttonLeft,
	.mCSB_scrollTools .mCSB_buttonRight{
		-webkit-transition: opacity .2s ease-in-out, background-color .2s ease-in-out;
		-moz-transition: opacity .2s ease-in-out, background-color .2s ease-in-out;
		-o-transition: opacity .2s ease-in-out, background-color .2s ease-in-out;
		transition: opacity .2s ease-in-out, background-color .2s ease-in-out;
	}
	
	.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_dragger_bar, /* auto-expanded scrollbar */
	.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_draggerRail, 
	.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_dragger_bar, 
	.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_draggerRail{
		-webkit-transition: width .2s ease-out .2s, height .2s ease-out .2s, 
					margin-left .2s ease-out .2s, margin-right .2s ease-out .2s, 
					margin-top .2s ease-out .2s, margin-bottom .2s ease-out .2s,
					opacity .2s ease-in-out, background-color .2s ease-in-out; 
		-moz-transition: width .2s ease-out .2s, height .2s ease-out .2s, 
					margin-left .2s ease-out .2s, margin-right .2s ease-out .2s, 
					margin-top .2s ease-out .2s, margin-bottom .2s ease-out .2s,
					opacity .2s ease-in-out, background-color .2s ease-in-out; 
		-o-transition: width .2s ease-out .2s, height .2s ease-out .2s, 
					margin-left .2s ease-out .2s, margin-right .2s ease-out .2s, 
					margin-top .2s ease-out .2s, margin-bottom .2s ease-out .2s,
					opacity .2s ease-in-out, background-color .2s ease-in-out; 
		transition: width .2s ease-out .2s, height .2s ease-out .2s, 
					margin-left .2s ease-out .2s, margin-right .2s ease-out .2s, 
					margin-top .2s ease-out .2s, margin-bottom .2s ease-out .2s,
					opacity .2s ease-in-out, background-color .2s ease-in-out; 
	}



/* 
------------------------------------------------------------------------------------------------------------------------
6. SCROLLBAR COLORS, OPACITY AND BACKGROUNDS  
------------------------------------------------------------------------------------------------------------------------
*/

	/* 
	----------------------------------------
	6.1 THEMES 
	----------------------------------------
	*/
	
	/* default theme (\\"light\\") */

	.mCSB_scrollTools{ opacity: 0.75; 
}
	
	.mCS-autoHide > .mCustomScrollBox > .mCSB_scrollTools,
	.mCS-autoHide > .mCustomScrollBox ~ .mCSB_scrollTools{ opacity: 0;  }
	
	.mCustomScrollbar > .mCustomScrollBox > .mCSB_scrollTools.mCSB_scrollTools_onDrag,
	.mCustomScrollbar > .mCustomScrollBox ~ .mCSB_scrollTools.mCSB_scrollTools_onDrag,
	.mCustomScrollBox:hover > .mCSB_scrollTools,
	.mCustomScrollBox:hover ~ .mCSB_scrollTools,
	.mCS-autoHide:hover > .mCustomScrollBox > .mCSB_scrollTools,
	.mCS-autoHide:hover > .mCustomScrollBox ~ .mCSB_scrollTools{ opacity: 1;  }

	.mCSB_scrollTools .mCSB_draggerRail{
		background-color: #000; background-color: rgba(0,0,0,0.4);
		}

	.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		background-color: #fff; background-color: rgba(255,255,255,0.75);
		
	}

	.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{
		background-color: #fff; background-color: rgba(255,255,255,0.85);
		
	}
	.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{
		background-color: #fff; background-color: rgba(255,255,255,0.9);
		
	}

	.mCSB_scrollTools .mCSB_buttonUp,
	.mCSB_scrollTools .mCSB_buttonDown,
	.mCSB_scrollTools .mCSB_buttonLeft,
	.mCSB_scrollTools .mCSB_buttonRight{
		background-image: url(mCSB_buttons.png); /* css sprites */
		background-repeat: no-repeat;
		}

	.mCSB_scrollTools .mCSB_buttonUp{
		background-position: 0 0;
		/* 
		sprites locations 
		light: 0 0, -16px 0, -32px 0, -48px 0, 0 -72px, -16px -72px, -32px -72px
		dark: -80px 0, -96px 0, -112px 0, -128px 0, -80px -72px, -96px -72px, -112px -72px
		*/
	}

	.mCSB_scrollTools .mCSB_buttonDown{
		background-position: 0 -20px;
		/* 
		sprites locations
		light: 0 -20px, -16px -20px, -32px -20px, -48px -20px, 0 -92px, -16px -92px, -32px -92px
		dark: -80px -20px, -96px -20px, -112px -20px, -128px -20px, -80px -92px, -96px -92px, -112 -92px
		*/
	}

	.mCSB_scrollTools .mCSB_buttonLeft{
		background-position: 0 -40px;
		/* 
		sprites locations 
		light: 0 -40px, -20px -40px, -40px -40px, -60px -40px, 0 -112px, -20px -112px, -40px -112px
		dark: -80px -40px, -100px -40px, -120px -40px, -140px -40px, -80px -112px, -100px -112px, -120px -112px
		*/
	}

	.mCSB_scrollTools .mCSB_buttonRight{
		background-position: 0 -56px;
		/* 
		sprites locations 
		light: 0 -56px, -20px -56px, -40px -56px, -60px -56px, 0 -128px, -20px -128px, -40px -128px
		dark: -80px -56px, -100px -56px, -120px -56px, -140px -56px, -80px -128px, -100px -128px, -120px -128px
		*/
	}

	.mCSB_scrollTools .mCSB_buttonUp:hover,
	.mCSB_scrollTools .mCSB_buttonDown:hover,
	.mCSB_scrollTools .mCSB_buttonLeft:hover,
	.mCSB_scrollTools .mCSB_buttonRight:hover{ opacity: 0.75;  }

	.mCSB_scrollTools .mCSB_buttonUp:active,
	.mCSB_scrollTools .mCSB_buttonDown:active,
	.mCSB_scrollTools .mCSB_buttonLeft:active,
	.mCSB_scrollTools .mCSB_buttonRight:active{ opacity: 0.9; }
	

	/* theme: \\"dark\\" */

	.mCS-dark.mCSB_scrollTools .mCSB_draggerRail{ background-color: #000; background-color: rgba(0,0,0,0.15); }

	.mCS-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.75); }

	.mCS-dark.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: rgba(0,0,0,0.85); }

	.mCS-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: rgba(0,0,0,0.9); }

	.mCS-dark.mCSB_scrollTools .mCSB_buttonUp{ background-position: -80px 0; }

	.mCS-dark.mCSB_scrollTools .mCSB_buttonDown{ background-position: -80px -20px; }

	.mCS-dark.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -80px -40px; }

	.mCS-dark.mCSB_scrollTools .mCSB_buttonRight{ background-position: -80px -56px; }
	
	/* ---------------------------------------- */
	


	/* theme: \\"light-2\\", \\"dark-2\\" */

	.mCS-light-2.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-dark-2.mCSB_scrollTools .mCSB_draggerRail{
		width: 4px;
		background-color: #fff; background-color: rgba(255,255,255,0.1);
		-webkit-border-radius: 1px; -moz-border-radius: 1px; border-radius: 1px;
	}

	.mCS-light-2.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-dark-2.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		width: 4px;
		background-color: #fff; background-color: rgba(255,255,255,0.75);
		-webkit-border-radius: 1px; -moz-border-radius: 1px; border-radius: 1px;
	}

	.mCS-light-2.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-dark-2.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-light-2.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-dark-2.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{
		width: 100%;
		height: 4px;
		margin: 6px auto;
	}

	.mCS-light-2.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #fff; background-color: rgba(255,255,255,0.85); }

	.mCS-light-2.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-light-2.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #fff; background-color: rgba(255,255,255,0.9); }

	.mCS-light-2.mCSB_scrollTools .mCSB_buttonUp{ background-position: -32px 0; }

	.mCS-light-2.mCSB_scrollTools .mCSB_buttonDown{	background-position: -32px -20px; }

	.mCS-light-2.mCSB_scrollTools .mCSB_buttonLeft{	background-position: -40px -40px; }

	.mCS-light-2.mCSB_scrollTools .mCSB_buttonRight{ background-position: -40px -56px; }
	
	
	/* theme: \\"dark-2\\" */

	.mCS-dark-2.mCSB_scrollTools .mCSB_draggerRail{
		background-color: #000; background-color: rgba(0,0,0,0.1);
		-webkit-border-radius: 1px; -moz-border-radius: 1px; border-radius: 1px;
	}

	.mCS-dark-2.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		background-color: #000; background-color: rgba(0,0,0,0.75);
		-webkit-border-radius: 1px; -moz-border-radius: 1px; border-radius: 1px;
	}

	.mCS-dark-2.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.85); }

	.mCS-dark-2.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-dark-2.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.9); }

	.mCS-dark-2.mCSB_scrollTools .mCSB_buttonUp{ background-position: -112px 0; }

	.mCS-dark-2.mCSB_scrollTools .mCSB_buttonDown{ background-position: -112px -20px; }

	.mCS-dark-2.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -120px -40px; }

	.mCS-dark-2.mCSB_scrollTools .mCSB_buttonRight{	background-position: -120px -56px; }
	
	/* ---------------------------------------- */
	


	/* theme: \\"light-thick\\", \\"dark-thick\\" */

	.mCS-light-thick.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-dark-thick.mCSB_scrollTools .mCSB_draggerRail{
		width: 4px;
		background-color: #fff; background-color: rgba(255,255,255,0.1);
		-webkit-border-radius: 2px; -moz-border-radius: 2px; border-radius: 2px;
	}

	.mCS-light-thick.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-dark-thick.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		width: 6px;
		background-color: #fff; background-color: rgba(255,255,255,0.75);
		-webkit-border-radius: 2px; -moz-border-radius: 2px; border-radius: 2px;
	}

	.mCS-light-thick.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-dark-thick.mCSB_scrollTools_horizontal .mCSB_draggerRail{
		width: 100%;
		height: 4px;
		margin: 6px 0;
	}

	.mCS-light-thick.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-dark-thick.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{
		width: 100%;
		height: 6px;
		margin: 5px auto;
	}

	.mCS-light-thick.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #fff; background-color: rgba(255,255,255,0.85); }

	.mCS-light-thick.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-light-thick.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #fff; background-color: rgba(255,255,255,0.9); }

	.mCS-light-thick.mCSB_scrollTools .mCSB_buttonUp{ background-position: -16px 0; }

	.mCS-light-thick.mCSB_scrollTools .mCSB_buttonDown{	background-position: -16px -20px; }

	.mCS-light-thick.mCSB_scrollTools .mCSB_buttonLeft{	background-position: -20px -40px; }

	.mCS-light-thick.mCSB_scrollTools .mCSB_buttonRight{ background-position: -20px -56px; }


	/* theme: \\"dark-thick\\" */
	
	.mCS-dark-thick.mCSB_scrollTools .mCSB_draggerRail{
		background-color: #000; background-color: rgba(0,0,0,0.1);
		-webkit-border-radius: 2px; -moz-border-radius: 2px; border-radius: 2px;
	}

	.mCS-dark-thick.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		background-color: #000; background-color: rgba(0,0,0,0.75);
		-webkit-border-radius: 2px; -moz-border-radius: 2px; border-radius: 2px;
	}

	.mCS-dark-thick.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.85); }

	.mCS-dark-thick.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-dark-thick.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.9); }

	.mCS-dark-thick.mCSB_scrollTools .mCSB_buttonUp{ background-position: -96px 0; }

	.mCS-dark-thick.mCSB_scrollTools .mCSB_buttonDown{ background-position: -96px -20px; }

	.mCS-dark-thick.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -100px -40px; }

	.mCS-dark-thick.mCSB_scrollTools .mCSB_buttonRight{	background-position: -100px -56px; }
	
	/* ---------------------------------------- */
	


	/* theme: \\"light-thin\\", \\"dark-thin\\" */
	
	.mCS-light-thin.mCSB_scrollTools .mCSB_draggerRail{ background-color: #fff; background-color: rgba(255,255,255,0.1); }

	.mCS-light-thin.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-dark-thin.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ width: 2px; }

	.mCS-light-thin.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-dark-thin.mCSB_scrollTools_horizontal .mCSB_draggerRail{ width: 100%; }

	.mCS-light-thin.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-dark-thin.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{
		width: 100%;
		height: 2px;
		margin: 7px auto;
	}


	/* theme \\"dark-thin\\" */
	
	.mCS-dark-thin.mCSB_scrollTools .mCSB_draggerRail{ background-color: #000; background-color: rgba(0,0,0,0.15); }

	.mCS-dark-thin.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.75); }
	
	.mCS-dark-thin.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.85); }
	
	.mCS-dark-thin.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-dark-thin.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.9); }
	
	.mCS-dark-thin.mCSB_scrollTools .mCSB_buttonUp{	background-position: -80px 0; }

	.mCS-dark-thin.mCSB_scrollTools .mCSB_buttonDown{ background-position: -80px -20px; }

	.mCS-dark-thin.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -80px -40px; }

	.mCS-dark-thin.mCSB_scrollTools .mCSB_buttonRight{ background-position: -80px -56px; }
	
	/* ---------------------------------------- */
	
	
	
	/* theme \\"rounded\\", \\"rounded-dark\\", \\"rounded-dots\\", \\"rounded-dots-dark\\" */
	
	.mCS-rounded.mCSB_scrollTools .mCSB_draggerRail{ background-color: #fff; background-color: rgba(255,255,255,0.15); }
	
	.mCS-rounded.mCSB_scrollTools .mCSB_dragger, 
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_dragger, 
	.mCS-rounded-dots.mCSB_scrollTools .mCSB_dragger, 
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_dragger{ height: 14px; }
	
	.mCS-rounded.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-rounded-dots.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		width: 14px;
		margin: 0 1px;
	}
	
	.mCS-rounded.mCSB_scrollTools_horizontal .mCSB_dragger, 
	.mCS-rounded-dark.mCSB_scrollTools_horizontal .mCSB_dragger, 
	.mCS-rounded-dots.mCSB_scrollTools_horizontal .mCSB_dragger, 
	.mCS-rounded-dots-dark.mCSB_scrollTools_horizontal .mCSB_dragger{ width: 14px; }
	
	.mCS-rounded.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-rounded-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-rounded-dots.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-rounded-dots-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{
		height: 14px;
		margin: 1px 0;
	}
	
	.mCS-rounded.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded .mCSB_dragger_bar, 
	.mCS-rounded.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-rounded-dark.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded .mCSB_dragger_bar, 
	.mCS-rounded-dark.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_dragger .mCSB_dragger_bar{
		width: 16px; /* auto-expanded scrollbar */
		height: 16px;
		margin: -1px 0;
	}
	
	.mCS-rounded.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCS-rounded.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail, 
	.mCS-rounded-dark.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCS-rounded-dark.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail{ width: 4px; /* auto-expanded scrollbar */ }
	
	.mCS-rounded.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded .mCSB_dragger_bar, 
	.mCS-rounded.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-rounded-dark.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded .mCSB_dragger_bar, 
	.mCS-rounded-dark.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_dragger .mCSB_dragger_bar{
		height: 16px; /* auto-expanded scrollbar */
		width: 16px;
		margin: 0 -1px;
	}
	
	.mCS-rounded.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCS-rounded.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail, 
	.mCS-rounded-dark.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCS-rounded-dark.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail{
		height: 4px; /* auto-expanded scrollbar */
		margin: 6px 0;
	}
	
	.mCS-rounded.mCSB_scrollTools .mCSB_buttonUp{ background-position: 0 -72px; }
	
	.mCS-rounded.mCSB_scrollTools .mCSB_buttonDown{ background-position: 0 -92px; }
	
	.mCS-rounded.mCSB_scrollTools .mCSB_buttonLeft{ background-position: 0 -112px; }
	
	.mCS-rounded.mCSB_scrollTools .mCSB_buttonRight{ background-position: 0 -128px; }
	
	
	/* theme \\"rounded-dark\\", \\"rounded-dots-dark\\" */
	
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.75); }
	
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_draggerRail{ background-color: #000; background-color: rgba(0,0,0,0.15); }
	
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar, 
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.85); }
	
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar, 
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.9); }
	
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_buttonUp{ background-position: -80px -72px; }
	
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_buttonDown{ background-position: -80px -92px; }
	
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -80px -112px; }
	
	.mCS-rounded-dark.mCSB_scrollTools .mCSB_buttonRight{ background-position: -80px -128px; }
	
	
	/* theme \\"rounded-dots\\", \\"rounded-dots-dark\\" */
	
	.mCS-rounded-dots.mCSB_scrollTools_vertical .mCSB_draggerRail, 
	.mCS-rounded-dots-dark.mCSB_scrollTools_vertical .mCSB_draggerRail{ width: 4px; }
	
	.mCS-rounded-dots.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-rounded-dots.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-rounded-dots-dark.mCSB_scrollTools_horizontal .mCSB_draggerRail{
		background-color: transparent;
		background-position: center;
	}
	
	.mCS-rounded-dots.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_draggerRail{
		background-image: url(\\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAANElEQVQYV2NkIAAYiVbw//9/Y6DiM1ANJoyMjGdBbLgJQAX/kU0DKgDLkaQAvxW4HEvQFwCRcxIJK1XznAAAAABJRU5ErkJggg==\\");
		background-repeat: repeat-y;
		opacity: 0.3;
		}
	
	.mCS-rounded-dots.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-rounded-dots-dark.mCSB_scrollTools_horizontal .mCSB_draggerRail{
		height: 4px;
		margin: 6px 0;
		background-repeat: repeat-x;
	}
	
	.mCS-rounded-dots.mCSB_scrollTools .mCSB_buttonUp{ background-position: -16px -72px; }
	
	.mCS-rounded-dots.mCSB_scrollTools .mCSB_buttonDown{ background-position: -16px -92px; }
	
	.mCS-rounded-dots.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -20px -112px; }
	
	.mCS-rounded-dots.mCSB_scrollTools .mCSB_buttonRight{ background-position: -20px -128px; }
	
	
	/* theme \\"rounded-dots-dark\\" */
	
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_draggerRail{
		background-image: url(\\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAALElEQVQYV2NkIAAYSVFgDFR8BqrBBEifBbGRTfiPZhpYjiQFBK3A6l6CvgAAE9kGCd1mvgEAAAAASUVORK5CYII=\\");
	}
	
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_buttonUp{ background-position: -96px -72px; }
	
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_buttonDown{ background-position: -96px -92px; }
	
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -100px -112px; }
	
	.mCS-rounded-dots-dark.mCSB_scrollTools .mCSB_buttonRight{ background-position: -100px -128px; }
	
	/* ---------------------------------------- */
	
	
	
	/* theme \\"3d\\", \\"3d-dark\\", \\"3d-thick\\", \\"3d-thick-dark\\" */
	
	.mCS-3d.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-thick.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		background-repeat: repeat-y;
		background-image: -moz-linear-gradient(left, rgba(255,255,255,0.5) 0%, rgba(255,255,255,0) 100%);
		background-image: -webkit-gradient(linear, left top, right top, color-stop(0%,rgba(255,255,255,0.5)), color-stop(100%,rgba(255,255,255,0)));
		background-image: -webkit-linear-gradient(left, rgba(255,255,255,0.5) 0%,rgba(255,255,255,0) 100%);
		background-image: -o-linear-gradient(left, rgba(255,255,255,0.5) 0%,rgba(255,255,255,0) 100%);
		background-image: -ms-linear-gradient(left, rgba(255,255,255,0.5) 0%,rgba(255,255,255,0) 100%);
		background-image: linear-gradient(to right, rgba(255,255,255,0.5) 0%,rgba(255,255,255,0) 100%);
	}
	
	.mCS-3d.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-thick.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-thick-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{
		background-repeat: repeat-x;
		background-image: -moz-linear-gradient(top, rgba(255,255,255,0.5) 0%, rgba(255,255,255,0) 100%);
		background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(255,255,255,0.5)), color-stop(100%,rgba(255,255,255,0)));
		background-image: -webkit-linear-gradient(top, rgba(255,255,255,0.5) 0%,rgba(255,255,255,0) 100%);
		background-image: -o-linear-gradient(top, rgba(255,255,255,0.5) 0%,rgba(255,255,255,0) 100%);
		background-image: -ms-linear-gradient(top, rgba(255,255,255,0.5) 0%,rgba(255,255,255,0) 100%);
		background-image: linear-gradient(to bottom, rgba(255,255,255,0.5) 0%,rgba(255,255,255,0) 100%);
	}
	
	
	/* theme \\"3d\\", \\"3d-dark\\" */
	
	.mCS-3d.mCSB_scrollTools_vertical .mCSB_dragger, 
	.mCS-3d-dark.mCSB_scrollTools_vertical .mCSB_dragger{ height: 70px; }
	
	.mCS-3d.mCSB_scrollTools_horizontal .mCSB_dragger, 
	.mCS-3d-dark.mCSB_scrollTools_horizontal .mCSB_dragger{ width: 70px; }
	
	.mCS-3d.mCSB_scrollTools, 
	.mCS-3d-dark.mCSB_scrollTools{
		opacity: 1;
	}
	
	.mCS-3d.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-3d.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-dark.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-3d-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ -webkit-border-radius: 16px; -moz-border-radius: 16px; border-radius: 16px; }
	
	.mCS-3d.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-3d-dark.mCSB_scrollTools .mCSB_draggerRail{
		width: 8px;
		background-color: #000; background-color: rgba(0,0,0,0.2);
		box-shadow: inset 1px 0 1px rgba(0,0,0,0.5), inset -1px 0 1px rgba(255,255,255,0.2);
	}
	
	.mCS-3d.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 	 
	.mCS-3d.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar, 
	.mCS-3d.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-3d.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar, 
	.mCS-3d-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-dark.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar, 
	.mCS-3d-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-3d-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #555; }

	.mCS-3d.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ width: 8px; }

	.mCS-3d.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-3d-dark.mCSB_scrollTools_horizontal .mCSB_draggerRail{
		width: 100%;
		height: 8px;
		margin: 4px 0;
		box-shadow: inset 0 1px 1px rgba(0,0,0,0.5), inset 0 -1px 1px rgba(255,255,255,0.2);
	}

	.mCS-3d.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{
		width: 100%;
		height: 8px;
		margin: 4px auto;
	}
	
	.mCS-3d.mCSB_scrollTools .mCSB_buttonUp{ background-position: -32px -72px; }
	
	.mCS-3d.mCSB_scrollTools .mCSB_buttonDown{ background-position: -32px -92px; }
	
	.mCS-3d.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -40px -112px; }
	
	.mCS-3d.mCSB_scrollTools .mCSB_buttonRight{ background-position: -40px -128px; }
	
	
	/* theme \\"3d-dark\\" */
	
	.mCS-3d-dark.mCSB_scrollTools .mCSB_draggerRail{
		background-color: #000; background-color: rgba(0,0,0,0.1);
		box-shadow: inset 1px 0 1px rgba(0,0,0,0.1);
	}
	
	.mCS-3d-dark.mCSB_scrollTools_horizontal .mCSB_draggerRail{ box-shadow: inset 0 1px 1px rgba(0,0,0,0.1); }
	
	.mCS-3d-dark.mCSB_scrollTools .mCSB_buttonUp{ background-position: -112px -72px; }

	.mCS-3d-dark.mCSB_scrollTools .mCSB_buttonDown{ background-position: -112px -92px; }

	.mCS-3d-dark.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -120px -112px; }

	.mCS-3d-dark.mCSB_scrollTools .mCSB_buttonRight{	background-position: -120px -128px; }
	
	/* ---------------------------------------- */
	
	
	
	/* theme: \\"3d-thick\\", \\"3d-thick-dark\\" */
	
	.mCS-3d-thick.mCSB_scrollTools, 
	.mCS-3d-thick-dark.mCSB_scrollTools{
		opacity: 1;
	}
	
	.mCS-3d-thick.mCSB_scrollTools, 
	.mCS-3d-thick-dark.mCSB_scrollTools, 
	.mCS-3d-thick.mCSB_scrollTools .mCSB_draggerContainer, 
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_draggerContainer{ -webkit-border-radius: 7px; -moz-border-radius: 7px; border-radius: 7px; }
	
	.mCS-3d-thick.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ -webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px; }
	
	.mCSB_inside + .mCS-3d-thick.mCSB_scrollTools_vertical, 
	.mCSB_inside + .mCS-3d-thick-dark.mCSB_scrollTools_vertical{ right: 1px; }
	
	.mCS-3d-thick.mCSB_scrollTools_vertical, 
	.mCS-3d-thick-dark.mCSB_scrollTools_vertical{ box-shadow: inset 1px 0 1px rgba(0,0,0,0.1), inset 0 0 14px rgba(0,0,0,0.5); }
	
	.mCS-3d-thick.mCSB_scrollTools_horizontal, 
	.mCS-3d-thick-dark.mCSB_scrollTools_horizontal{
		bottom: 1px;
		box-shadow: inset 0 1px 1px rgba(0,0,0,0.1), inset 0 0 14px rgba(0,0,0,0.5);
	}
	
	.mCS-3d-thick.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		box-shadow: inset 1px 0 0 rgba(255,255,255,0.4);
		width: 12px;
		margin: 2px;
		position: absolute;
		height: auto;
		top: 0;
		bottom: 0;
		left: 0;
		right: 0;
	}
	
	.mCS-3d-thick.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-thick-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{ box-shadow: inset 0 1px 0 rgba(255,255,255,0.4); }
	
	.mCS-3d-thick.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar,  
	.mCS-3d-thick.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar, 
	.mCS-3d-thick.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-3d-thick.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #555; }
	
	.mCS-3d-thick.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-3d-thick-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{
		height: 12px;
		width: auto;
	}
	
	.mCS-3d-thick.mCSB_scrollTools .mCSB_draggerContainer{
		background-color: #000; background-color: rgba(0,0,0,0.05);
		box-shadow: inset 1px 1px 16px rgba(0,0,0,0.1);
	}
	
	.mCS-3d-thick.mCSB_scrollTools .mCSB_draggerRail{ background-color: transparent; }
	
	.mCS-3d-thick.mCSB_scrollTools .mCSB_buttonUp{ background-position: -32px -72px; }
	
	.mCS-3d-thick.mCSB_scrollTools .mCSB_buttonDown{ background-position: -32px -92px; }

	.mCS-3d-thick.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -40px -112px; }

	.mCS-3d-thick.mCSB_scrollTools .mCSB_buttonRight{	background-position: -40px -128px; }
	
	
	/* theme: \\"3d-thick-dark\\" */
	
	.mCS-3d-thick-dark.mCSB_scrollTools{ box-shadow: inset 0 0 14px rgba(0,0,0,0.2); }
	
	.mCS-3d-thick-dark.mCSB_scrollTools_horizontal{ box-shadow: inset 0 1px 1px rgba(0,0,0,0.1), inset 0 0 14px rgba(0,0,0,0.2); }
	
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ box-shadow: inset 1px 0 0 rgba(255,255,255,0.4), inset -1px 0 0 rgba(0,0,0,0.2); }
	 
	.mCS-3d-thick-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{ box-shadow: inset 0 1px 0 rgba(255,255,255,0.4), inset 0 -1px 0 rgba(0,0,0,0.2); }
	
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar,  
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar, 
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #777; }
	
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_draggerContainer{
		background-color: #fff; background-color: rgba(0,0,0,0.05);
		box-shadow: inset 1px 1px 16px rgba(0,0,0,0.1);
	}
	
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_draggerRail{ background-color: transparent; }
	
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_buttonUp{ background-position: -112px -72px; }
	
	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_buttonDown{ background-position: -112px -92px; }

	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -120px -112px; }

	.mCS-3d-thick-dark.mCSB_scrollTools .mCSB_buttonRight{	background-position: -120px -128px; }
	
	/* ---------------------------------------- */
	
	
	
	/* theme: \\"minimal\\", \\"minimal-dark\\" */
	
	.mCSB_outside + .mCS-minimal.mCSB_scrollTools_vertical, 
	.mCSB_outside + .mCS-minimal-dark.mCSB_scrollTools_vertical{
		right: 0; 
		margin: 12px 0; 
	}
	
	.mCustomScrollBox.mCS-minimal + .mCSB_scrollTools.mCSB_scrollTools_horizontal, 
	.mCustomScrollBox.mCS-minimal + .mCSB_scrollTools + .mCSB_scrollTools.mCSB_scrollTools_horizontal, 
	.mCustomScrollBox.mCS-minimal-dark + .mCSB_scrollTools.mCSB_scrollTools_horizontal, 
	.mCustomScrollBox.mCS-minimal-dark + .mCSB_scrollTools + .mCSB_scrollTools.mCSB_scrollTools_horizontal{
		bottom: 0; 
		margin: 0 12px; 
	}
	
	/* RTL direction/left-side scrollbar */
	.mCS-dir-rtl > .mCSB_outside + .mCS-minimal.mCSB_scrollTools_vertical, 
	.mCS-dir-rtl > .mCSB_outside + .mCS-minimal-dark.mCSB_scrollTools_vertical{
		left: 0; 
		right: auto;
	}
	
	.mCS-minimal.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-minimal-dark.mCSB_scrollTools .mCSB_draggerRail{ background-color: transparent; }
	
	.mCS-minimal.mCSB_scrollTools_vertical .mCSB_dragger, 
	.mCS-minimal-dark.mCSB_scrollTools_vertical .mCSB_dragger{ height: 50px; }
	
	.mCS-minimal.mCSB_scrollTools_horizontal .mCSB_dragger, 
	.mCS-minimal-dark.mCSB_scrollTools_horizontal .mCSB_dragger{ width: 50px; }
	
	.mCS-minimal.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		background-color: #fff; background-color: rgba(255,255,255,0.2);
	}
	
	.mCS-minimal.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-minimal.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{
		background-color: #fff; background-color: rgba(255,255,255,0.5);
	}
	
	
	/* theme: \\"minimal-dark\\" */
	
	.mCS-minimal-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{
		background-color: #000; background-color: rgba(0,0,0,0.2);
	}
	
	.mCS-minimal-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-minimal-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{
		background-color: #000; background-color: rgba(0,0,0,0.5);
	}
	
	/* ---------------------------------------- */
	
	
	
	/* theme \\"light-3\\", \\"dark-3\\" */
	
	.mCS-light-3.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-dark-3.mCSB_scrollTools .mCSB_draggerRail{
		width: 6px;
		background-color: #000; background-color: rgba(0,0,0,0.2);
	}

	.mCS-light-3.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-dark-3.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ width: 6px; }

	.mCS-light-3.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-dark-3.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-light-3.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-dark-3.mCSB_scrollTools_horizontal .mCSB_draggerRail{
		width: 100%;
		height: 6px;
		margin: 5px 0;
	}
	
	.mCS-light-3.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCS-light-3.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail, 
	.mCS-dark-3.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCS-dark-3.mCSB_scrollTools_vertical.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail{
		width: 12px;
	}
	
	.mCS-light-3.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCS-light-3.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail, 
	.mCS-dark-3.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_dragger.mCSB_dragger_onDrag_expanded + .mCSB_draggerRail, 
	.mCS-dark-3.mCSB_scrollTools_horizontal.mCSB_scrollTools_onDrag_expand .mCSB_draggerContainer:hover .mCSB_draggerRail{
		height: 12px;
		margin: 2px 0;
	}
	
	.mCS-light-3.mCSB_scrollTools .mCSB_buttonUp{ background-position: -32px -72px; }
	
	.mCS-light-3.mCSB_scrollTools .mCSB_buttonDown{ background-position: -32px -92px; }
	
	.mCS-light-3.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -40px -112px; }
	
	.mCS-light-3.mCSB_scrollTools .mCSB_buttonRight{ background-position: -40px -128px; }
	
	
	/* theme \\"dark-3\\" */
	
	.mCS-dark-3.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.75); }

	.mCS-dark-3.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.85); }

	.mCS-dark-3.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-dark-3.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.9); }
	
	.mCS-dark-3.mCSB_scrollTools .mCSB_draggerRail{ background-color: #000; background-color: rgba(0,0,0,0.1); }
	
	.mCS-dark-3.mCSB_scrollTools .mCSB_buttonUp{ background-position: -112px -72px; }

	.mCS-dark-3.mCSB_scrollTools .mCSB_buttonDown{ background-position: -112px -92px; }

	.mCS-dark-3.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -120px -112px; }

	.mCS-dark-3.mCSB_scrollTools .mCSB_buttonRight{	background-position: -120px -128px; }
	
	/* ---------------------------------------- */
	
	
	
	/* theme \\"inset\\", \\"inset-dark\\", \\"inset-2\\", \\"inset-2-dark\\", \\"inset-3\\", \\"inset-3-dark\\" */
	
	.mCS-inset.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-inset-dark.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-inset-2.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-inset-3.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_draggerRail{
		width: 12px;
		background-color: #000; background-color: rgba(0,0,0,0.2);
	}

	.mCS-inset.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-2.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-3.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ 
		width: 6px;
		margin: 3px 5px;
		position: absolute;
		height: auto;
		top: 0;
		bottom: 0;
		left: 0;
		right: 0;
	}

	.mCS-inset.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-2.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-2-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-3.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-3-dark.mCSB_scrollTools_horizontal .mCSB_dragger .mCSB_dragger_bar{
		height: 6px;
		margin: 5px 3px;
		position: absolute;
		width: auto;
		top: 0;
		bottom: 0;
		left: 0;
		right: 0;
	}
	
	.mCS-inset.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-inset-dark.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-inset-2.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-inset-2-dark.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-inset-3.mCSB_scrollTools_horizontal .mCSB_draggerRail, 
	.mCS-inset-3-dark.mCSB_scrollTools_horizontal .mCSB_draggerRail{
		width: 100%;
		height: 12px;
		margin: 2px 0;
	}
	
	.mCS-inset.mCSB_scrollTools .mCSB_buttonUp, 
	.mCS-inset-2.mCSB_scrollTools .mCSB_buttonUp, 
	.mCS-inset-3.mCSB_scrollTools .mCSB_buttonUp{ background-position: -32px -72px; }
	
	.mCS-inset.mCSB_scrollTools .mCSB_buttonDown, 
	.mCS-inset-2.mCSB_scrollTools .mCSB_buttonDown, 
	.mCS-inset-3.mCSB_scrollTools .mCSB_buttonDown{ background-position: -32px -92px; }
	
	.mCS-inset.mCSB_scrollTools .mCSB_buttonLeft, 
	.mCS-inset-2.mCSB_scrollTools .mCSB_buttonLeft, 
	.mCS-inset-3.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -40px -112px; }
	
	.mCS-inset.mCSB_scrollTools .mCSB_buttonRight, 
	.mCS-inset-2.mCSB_scrollTools .mCSB_buttonRight, 
	.mCS-inset-3.mCSB_scrollTools .mCSB_buttonRight{ background-position: -40px -128px; }
	
	
	/* theme \\"inset-dark\\", \\"inset-2-dark\\", \\"inset-3-dark\\" */
	
	.mCS-inset-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.75); }

	.mCS-inset-dark.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.85); }

	.mCS-inset-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-inset-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.9); }
	
	.mCS-inset-dark.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_draggerRail{ background-color: #000; background-color: rgba(0,0,0,0.1); }
	
	.mCS-inset-dark.mCSB_scrollTools .mCSB_buttonUp, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_buttonUp, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_buttonUp{ background-position: -112px -72px; }

	.mCS-inset-dark.mCSB_scrollTools .mCSB_buttonDown, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_buttonDown, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_buttonDown{ background-position: -112px -92px; }

	.mCS-inset-dark.mCSB_scrollTools .mCSB_buttonLeft, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_buttonLeft, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_buttonLeft{ background-position: -120px -112px; }

	.mCS-inset-dark.mCSB_scrollTools .mCSB_buttonRight, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_buttonRight, 
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_buttonRight{	background-position: -120px -128px; }
	
	
	/* theme \\"inset-2\\", \\"inset-2-dark\\" */
	
	.mCS-inset-2.mCSB_scrollTools .mCSB_draggerRail, 
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_draggerRail{
		background-color: transparent;
		border-width: 1px;
		border-style: solid;
		border-color: #fff;
		border-color: rgba(255,255,255,0.2);
		-webkit-box-sizing: border-box; -moz-box-sizing: border-box; box-sizing: border-box;
	}
	
	.mCS-inset-2-dark.mCSB_scrollTools .mCSB_draggerRail{ border-color: #000; border-color: rgba(0,0,0,0.2); }
	
	
	/* theme \\"inset-3\\", \\"inset-3-dark\\" */
	
	.mCS-inset-3.mCSB_scrollTools .mCSB_draggerRail{ background-color: #fff; background-color: rgba(255,255,255,0.6); }
	
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_draggerRail{ background-color: #000; background-color: rgba(0,0,0,0.6); }
	
	.mCS-inset-3.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.75); }
	
	.mCS-inset-3.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.85); }
	
	.mCS-inset-3.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-inset-3.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #000; background-color: rgba(0,0,0,0.9); }
	
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_dragger .mCSB_dragger_bar{ background-color: #fff; background-color: rgba(255,255,255,0.75); }
	
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_dragger:hover .mCSB_dragger_bar{ background-color: #fff; background-color: rgba(255,255,255,0.85); }
	
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_dragger:active .mCSB_dragger_bar,
	.mCS-inset-3-dark.mCSB_scrollTools .mCSB_dragger.mCSB_dragger_onDrag .mCSB_dragger_bar{ background-color: #fff; background-color: rgba(255,255,255,0.9); }
	
	/* ---------------------------------------- */',
  'css_editor' => '.grt {
	width: $w_content - 2 * $x_single - 1;
	margin: 0 auto;
	font-family: $font;
	-webkit-font-smoothing: subpixel-antialiased !important;
}
/*---:[ links ]:---*/
.grt a {
	color: $links;
	text-decoration: none;
}
.grt p a {
	text-decoration: underline;
}
.grt p a:hover {
	text-decoration: none;
}
/*---:[ typography ]:---*/
.grt, .grt h3 {
	font-size: $f_text;
	line-height: $h_text;
}
.grt h2 {
	$subhead
	margin-top: $x_3over2;
	margin-bottom: $x_half;
}
.grt h2, .grt h3 {
	color: $subhead_color;
}
.grt h3 {
	font-weight: bold;
}
.grt .small, .grt .caption {
	font-size: $f_aux;
	line-height: $h_aux;
}
.grt .drop_cap {
	font-size: $x_double;
	line-height: 1em;
	margin-right: 0.15em;
	float: left;
}
.grt p, .grt ul, .grt ol, .grt blockquote, .grt pre, .grt dl, .grt dd, .grt .center, .grt .block, .grt .aligncenter, .grt .alignnone, .grt .post_image, .grt .post_image_box, .grt .wp-post-image, .grt .caption, .grt .wp-caption, .grt .alert, .grt .note, .grt .box, .grt .footnotes {
	margin-bottom: $x_single;
}
.grt ul, .grt ol, .grt .stack {
	margin-left: $x_single;
}
.grt ul ul, .grt ul ol, .grt ol ul, .grt ol ol, .wp-caption p, .grt .alert p:last-child, .grt .note p:last-child, .grt .box p:last-child, .grt blockquote.right p, .grt blockquote.left p, .grt .footnotes p:last-child {
	margin-bottom: 0;
}
.grt .left, .grt .alignleft, .grt .ad_left {
	margin-bottom: $x_single;
	margin-right: $x_single;
}
.grt .right, .grt .alignright, .grt .ad {
	margin-bottom: $x_single;
	margin-left: $x_single;
}
.grt .caption {
	margin-top: -$x_half;
	color: $text2;
}
.grt .footnotes p {
	margin-bottom: $x_half;
}
.grt ul {
	list-style-type: square;
}
.grt li a {
	text-decoration: underline;
}
.grt li a:hover {
	text-decoration: none;
}
.grt blockquote {
	$blockquote
	margin-left: $x_half;
	padding-left: $x_half;
	border-left: 1px solid $color1;
}
.grt code {
	$code
}
.grt pre {
	$pre
	background-color: $color2;
	padding: $x_half;
	-webkit-tab-size: 4;
	-moz-tab-size: 4;
	tab-size: 4;
}
.grt .frame, .grt .post_image_box, .grt .wp-caption {
	border: 1px solid $color1;
	background-color: $color2;
	padding: $x_half;
}
.grt .wp-caption img, .grt .post_image_box .post_image, .grt .thumb {
	margin-bottom: $x_half;
}
.wp-caption.aligncenter img {
	margin-right: auto;
	margin-left: auto;
}
.wp-caption .wp-caption-text .wp-smiley {
	display: inline;
	margin-bottom: 0;
}
.grt .wp-caption p {
	font-size: $f_aux;
	line-height: $h_aux;
}
.grt .alert, .grt .note, .grt .box {
	padding: $x_half;
}
.grt .alert {
	background-color: #ff9;
	border: 1px solid #e6e68a;
}
.grt .note {
	background-color: $color2;
	border: 1px solid $color1;
}
$_links = $links;
.grt .box {
	background-color: scale-color($_links, $lightness: 90%);
	border: 1px solid scale-color($_links, $lightness: -10%);
}
.grt .footnotes {
	font-size: $f_aux;
	line-height: $h_aux;
	border-top: 1px dotted $color1;
	padding-top: $x_single;
}
.grt .footnotes, .grt sub, .grt sup {
	color: $text2;
}
.grt blockquote.right, .grt blockquote.left {
	$pullquote
	width: 45%;
	margin-bottom: $x_half;
}
.grt blockquote.right, .grt blockquote.left { 
	padding-left: 0;
	border: 0;
}',
  'boxes' => 
  array (
    'thesis_html_container' => 
    array (
      'thesis_html_container_1438599248' => 
      array (
        'class' => 'top_header container',
        '_name' => 'Top Header',
      ),
      'thesis_html_container_1438599279' => 
      array (
        'class' => 'main_container',
        '_name' => 'Main Container',
      ),
      'thesis_html_container_1438599308' => 
      array (
        'class' => 'center_header container',
        '_id' => 'header',
        '_name' => 'Center Header',
      ),
      'thesis_html_container_1438599332' => 
      array (
        'class' => 'btm_header container',
        '_name' => 'Bottom Header',
      ),
      'thesis_html_container_1438665528' => 
      array (
        'class' => 'header',
        '_name' => 'Header',
      ),
      'thesis_html_container_1438666111' => 
      array (
        'class' => 'top_left',
        '_name' => 'Top Left',
      ),
      'thesis_html_container_1438666139' => 
      array (
        'class' => 'top_right',
        '_name' => 'Top Right',
      ),
      'thesis_html_container_1438674902' => 
      array (
        'class' => 'content_section',
        '_name' => 'Content Section',
      ),
      'thesis_html_container_1438674951' => 
      array (
        'class' => 'inner_content container',
        '_name' => 'Inner Content',
      ),
      'thesis_html_container_1438682089' => 
      array (
        'class' => 'content_left ',
        '_name' => 'Content Left',
      ),
      'thesis_html_container_1438682116' => 
      array (
        'class' => 'sidebar',
        '_id' => 'sidebar',
        '_name' => 'Sidebar',
      ),
      'thesis_html_container_1438682239' => 
      array (
        'class' => 'container_one',
        '_name' => 'Container One',
      ),
      'thesis_html_container_1438686602' => 
      array (
        'class' => 'sec_third_category',
        '_name' => 'Second Third category',
      ),
      'thesis_html_container_1438766338' => 
      array (
        'class' => 'footer',
        '_name' => 'Footer',
      ),
      'thesis_html_container_1438766423' => 
      array (
        'class' => 'inner_footer container',
        '_name' => 'Inner Footer',
      ),
      'thesis_html_container_1438766482' => 
      array (
        'class' => 'top_footer',
        '_name' => 'Top Footer',
      ),
      'thesis_html_container_1438766513' => 
      array (
        'class' => 'bottom_footer',
        '_name' => 'Bottom Footer',
      ),
      'thesis_html_container_1438775360' => 
      array (
        'class' => 'post_left',
        '_name' => 'Post Left',
      ),
      'thesis_html_container_1438775392' => 
      array (
        'class' => 'post_right',
        '_name' => 'Post Right',
      ),
      'thesis_html_container_1438775697' => 
      array (
        'class' => 'hme_byline',
        '_name' => 'Home Byline',
      ),
      'thesis_html_container_1438837423' => 
      array (
        'class' => 'hmepost_btm',
        '_name' => 'Homepost Bottom',
      ),
      'thesis_html_container_1438855633' => 
      array (
        'class' => 'single_byline',
        '_name' => 'Single Byline',
      ),
      'thesis_html_container_1438855746' => 
      array (
        'class' => 'comments',
        '_id' => 'post_comments',
        '_name' => 'Comments',
      ),
      'thesis_html_container_1438855849' => 
      array (
        'class' => 'cmt_date',
        '_name' => 'Comment Date',
      ),
      'thesis_html_container_1438855959' => 
      array (
        'class' => 'right_cmt_cnt',
        '_name' => 'Right Comment Content',
      ),
      'thesis_html_container_1438855964' => 
      array (
        'class' => 'cmt_cont',
        '_name' => 'Comment Cont',
      ),
      'thesis_html_container_1438856430' => 
      array (
        'class' => 'prev_next',
        '_name' => 'Prev/Next',
      ),
      'thesis_html_container_1438858424' => 
      array (
        'class' => 'author_right',
        '_name' => 'Author Right',
      ),
      'thesis_html_container_1438861079' => 
      array (
        'class' => 'comments',
        '_id' => 'page_comments',
        '_name' => 'Page Comments',
      ),
      'thesis_html_container_1438925459' => 
      array (
        'class' => 'block_title',
        '_name' => 'Comment Block Title',
      ),
      'thesis_html_container_1438930076' => 
      array (
        'class' => 'landing_optin_video container',
        '_name' => 'Landing optin',
      ),
      'thesis_html_container_1439365414' => 
      array (
        'class' => 'single_header',
        '_name' => 'Single Header',
      ),
      'thesis_html_container_1439370805' => 
      array (
        'class' => 'single_cont_left',
        '_name' => 'Single Content Left',
      ),
      'thesis_html_container_1452329597' => 
      array (
        'class' => 'newmagaz_logo',
        '_name' => 'Newmagaz Logo',
      ),
    ),
    'newmagaz_search' => 
    array (
      'newmagaz_search' => 
      array (
        'searchcheck' => 
        array (
          'searchoptions' => true,
        ),
      ),
    ),
    'thesis_wp_nav_menu' => 
    array (
      'thesis_wp_nav_menu_1438666176' => 
      array (
        'menu' => '3',
        'control' => 
        array (
          'yes' => true,
        ),
        '_name' => 'Nav Menu',
      ),
    ),
    'newmagaz_logo' => 
    array (
      'newmagaz_logo_1438666679' => 
      array (
        'logo_img' => 'http://newmagaz.buythesisskins.com/wp-content/uploads/2015/08/neww.png',
        'logo_width' => '220',
        'logo_height' => '65',
        '_name' => 'Newmagaz Logo Box',
      ),
    ),
    'newmagaz_header_advertisement' => 
    array (
      'newmagaz_header_advertisement' => 
      array (
        'headercheck' => 
        array (
          'searchoptions' => true,
        ),
        'link' => '<img alt=\'Header Ad\' src=\'http://newmagaz.buythesisskins.com/wp-content/uploads/2015/08/adv1.jpg\'/>',
      ),
    ),
    'newmagaz_breaking_news' => 
    array (
      'newmagaz_breaking_news' => 
      array (
        'tickercheck' => 
        array (
          'timeoptions' => true,
        ),
      ),
    ),
    'newmagaz_latest_news' => 
    array (
      'newmagaz_latest_news' => 
      array (
        'latnewscheck' => 
        array (
          'latnewsoptions' => true,
        ),
      ),
    ),
    'newmagaz_sidebar_advertisement' => 
    array (
      'newmagaz_sidebar_advertisement' => 
      array (
        'headercheck' => 
        array (
          'searchoptions' => true,
        ),
        'link' => '<img  alt=\'Sidebar Ad\' src=\'http://newmagaz.buythesisskins.com/wp-content/uploads/2015/08/350x250.gif\'/>',
      ),
    ),
    'newmagaz_first_category' => 
    array (
      'newmagaz_first_category' => 
      array (
        'firstccheck' => 
        array (
          'firstcoptions' => true,
        ),
        'afirstbox' => '4',
        'rdtext' => 'Read more',
      ),
    ),
    'newmagaz_second_category' => 
    array (
      'newmagaz_second_category' => 
      array (
        'firstccheck' => 
        array (
          'firstcoptions' => true,
        ),
        'asecondbox' => '9',
      ),
    ),
    'newmagaz_third_category' => 
    array (
      'newmagaz_third_category' => 
      array (
        'firstccheck' => 
        array (
          'firstcoptions' => true,
        ),
        'asecondbox' => '5',
      ),
    ),
    'newmagaz_content_advertisement' => 
    array (
      'newmagaz_content_advertisement' => 
      array (
        'headercheck' => 
        array (
          'searchoptions' => true,
        ),
        'link' => '<img alt=\'Content Ad\' src=\'http://newmagaz.buythesisskins.com/wp-content/uploads/2015/08/adv1.jpg\'>',
      ),
    ),
    'newmagaz_fourth_category' => 
    array (
      'newmagaz_fourth_category' => 
      array (
        'firstccheck' => 
        array (
          'firstcoptions' => true,
        ),
        'afourthbox' => '8',
      ),
    ),
    'newmagaz_fifth_category' => 
    array (
      'newmagaz_fifth_category' => 
      array (
        'firstccheck' => 
        array (
          'firstcoptions' => true,
        ),
        'afourthbox' => '11',
      ),
    ),
    'newmagaz_random_box' => 
    array (
      'newmagaz_random_box' => 
      array (
        'randomcheck' => 
        array (
          'randomoptions' => true,
        ),
      ),
    ),
    'newmagaz_popular_posts' => 
    array (
      'newmagaz_popular_posts' => 
      array (
        'popularcheck' => 
        array (
          'popularoptions' => true,
        ),
      ),
    ),
    'newmagaz_recently_updated_posts' => 
    array (
      'newmagaz_recently_updated_posts' => 
      array (
        'popularcheck' => 
        array (
          'popularoptions' => true,
        ),
      ),
    ),
    'newmagaz_recent_comments_box' => 
    array (
      'newmagaz_recent_comments_box' => 
      array (
        'recentcheck' => 
        array (
          'recentoptions' => true,
        ),
      ),
    ),
    'thesis_comment_form' => 
    array (
      'thesis_comment_form_1438764460' => 
      array (
        '_name' => 'Comment Form',
      ),
      'thesis_comment_form_1438855733' => 
      array (
        '_name' => 'Comment Form',
      ),
    ),
    'thesis_comments' => 
    array (
      'thesis_comments_1438764470' => 
      array (
        '_name' => 'Comment List',
      ),
      'thesis_comments_1438855738' => 
      array (
        '_name' => 'Comment List',
      ),
    ),
    'thesis_comments_nav' => 
    array (
      'thesis_comments_nav_1438766502' => 
      array (
      ),
    ),
    'thesis_wp_widgets' => 
    array (
      'thesis_wp_widgets_1438766601' => 
      array (
        'class' => 'footer_widgets',
        'title_tag' => 'h3',
        'div' => 'div',
        '_name' => 'Footer Widgets',
      ),
    ),
    'thesis_attribution' => 
    array (
      'thesis_attribution' => 
      array (
        'text' => 'copyrights @ 2015 buythesisskins.com',
      ),
    ),
    'newmagaz_photostream_box' => 
    array (
      'newmagaz_photostream_box' => 
      array (
        'popularcheck' => 
        array (
          'popularoptions' => true,
        ),
        'title' => 'News in Pictures',
      ),
    ),
    'newmagaz_sidebar_optin_box' => 
    array (
      'newmagaz_sidebar_optin_box' => 
      array (
        'optincheck' => 
        array (
          'optinchecktext' => true,
        ),
        'optin_header' => 'LOGIN',
        'name_text' => 'Enter Your Name',
        'email_text' => 'Enter Your Email',
      ),
    ),
    'newmagaz_404_errorpage' => 
    array (
      'newmagaz_404_errorpage' => 
      array (
        'content' => 'Sorry, but the page you are looking for has moved or no longer exists',
        'home_title' => 'back to Home',
      ),
    ),
    'thesis_post_box' => 
    array (
      'thesis_post_box_1438775342' => 
      array (
        'class' => 'grt hme_pst_bx',
        'schema' => 'article',
        '_name' => 'Home Post Box',
      ),
      'thesis_post_box_1438855228' => 
      array (
        'class' => 'grt single_postbox',
        'schema' => 'article',
        '_name' => 'Single Post Box',
      ),
    ),
    'newmagaz_featured_image' => 
    array (
      'newmagaz_featured_image_1438775416' => 
      array (
        '_name' => 'Newmagaz Featured Image',
      ),
    ),
    'thesis_post_date' => 
    array (
      'thesis_post_box_1438775342_thesis_post_date' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_post_date' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_post_author' => 
    array (
      'thesis_post_box_1438775342_thesis_post_author' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_post_author' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_post_author_avatar' => 
    array (
      'thesis_post_box_1438775342_thesis_post_author_avatar' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_post_author_avatar' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_post_author_description' => 
    array (
      'thesis_post_box_1438775342_thesis_post_author_description' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_post_author_description' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_post_num_comments' => 
    array (
      'thesis_post_box_1438775342_thesis_post_num_comments' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_post_num_comments' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_post_categories' => 
    array (
      'thesis_post_box_1438775342_thesis_post_categories' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_post_categories' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_post_tags' => 
    array (
      'thesis_post_box_1438775342_thesis_post_tags' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_post_tags' => 
      array (
        'intro' => 'TAGS:',
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_post_image' => 
    array (
      'thesis_post_box_1438775342_thesis_post_image' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_post_image' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_post_thumbnail' => 
    array (
      'thesis_post_box_1438775342_thesis_post_thumbnail' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_post_thumbnail' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_wp_featured_image' => 
    array (
      'thesis_post_box_1438775342_thesis_wp_featured_image' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438775342',
      ),
      'thesis_post_box_1438855228_thesis_wp_featured_image' => 
      array (
        '_id' => 'loop',
        '_parent' => 'thesis_post_box_1438855228',
      ),
    ),
    'thesis_post_headline' => 
    array (
      'thesis_post_box_1438775342_thesis_post_headline' => 
      array (
        'html' => 'h2',
        'link' => 
        array (
          'on' => true,
        ),
        '_parent' => 'thesis_post_box_1438775342',
      ),
    ),
    'thesis_comment_author' => 
    array (
      'thesis_comments_1438855738_thesis_comment_author' => 
      array (
        '_id' => 'comments',
        '_parent' => 'thesis_comments_1438855738',
      ),
    ),
    'thesis_comment_date' => 
    array (
      'thesis_comments_1438855738_thesis_comment_date' => 
      array (
        '_id' => 'comments',
        '_parent' => 'thesis_comments_1438855738',
      ),
    ),
    'newmagaz_related_box' => 
    array (
      'newmagaz_related_box' => 
      array (
        'relatedcheck' => 
        array (
          'soption' => true,
        ),
      ),
    ),
    'newmagaz_social_sharing_box' => 
    array (
      'newmagaz_social_sharing_box' => 
      array (
        'sharecheck' => 
        array (
          'socialcheckoptions' => true,
        ),
      ),
    ),
    'newmagaz_landing_optin_with_video_box' => 
    array (
      'newmagaz_landing_optin_with_video_box' => 
      array (
        'firstcheck' => 
        array (
          'popularoptions' => true,
        ),
        'ovb_link' => '<iframe width="560" height="315" src="https://www.youtube.com/embed/3A-PnzkYqn0" style=\'border:0;\' allowfullscreen></iframe>',
        'ovb_title' => 'Gourmet catering for all ',
        'content' => 'With contemporary, hand-crafted decor and embellishments.',
      ),
    ),
    'newmagaz_landing_box_feature' => 
    array (
      'newmagaz_landing_box_feature' => 
      array (
        'firstlandingcheck' => 
        array (
          'popularoptions' => true,
        ),
        'feature_title' => 'You bring the guests - We\'ll do the rest.',
        'featureimg_link1' => 'http://newmagaz.buythesisskins.com/wp-content/uploads/2015/08/fetr.jpg',
        'sub_title1' => 'Gourmet, Seasonal Fare',
        'feature_para1' => 'Our team of distinguished gourmands craft a tailor-made menu to meet your party needs. Our flexible menus cater for all dietary requirements.',
        'readmore1' => 'View more',
        'featureimg_link2' => 'http://newmagaz.buythesisskins.com/wp-content/uploads/2015/08/cater3.jpg',
        'sub_title2' => 'Decor & Presentation',
        'feature_para2' => 'Our team of distinguished gourmands craft a tailor-made menu to meet your party needs. Our flexible menus cater for all dietary requirements.',
        'readmore2' => 'View more',
        'featureimg_link3' => 'http://newmagaz.buythesisskins.com/wp-content/uploads/2015/08/cater2.jpg',
        'sub_title3' => 'Decor & Presentation',
        'feature_para3' => 'Our team of distinguished gourmands craft a tailor-made menu to meet your party needs. Our flexible menus cater for all dietary requirements.',
        'readmore3' => 'View more',
      ),
    ),
    'newmagaz_scripts' => 
    array (
      'newmagaz_scripts' => 
      array (
        'background_image' => 'http://localhost/newmagaz/wp-content/uploads/2015/08/dandelion-yellow-flower-hd-wallpaper.jpg',
      ),
    ),
    'newmagaz_page_navigation' => 
    array (
      'newmagaz_page_navigation' => 
      array (
        'paginationcheck' => 
        array (
          'nav1rchecktext' => true,
        ),
      ),
    ),
    'newmagaz_sixth_category' => 
    array (
      'newmagaz_sixth_category' => 
      array (
        'firstccheck' => 
        array (
          'firstcoptions' => true,
        ),
        'asixthbox' => '12',
      ),
    ),
    'newmagaz_seventh_category' => 
    array (
      'newmagaz_seventh_category' => 
      array (
        'firstccheck' => 
        array (
          'firstcoptions' => true,
        ),
        'cfirstbox' => '7',
        'resizer_width1' => '470',
        'resizer_height1' => '326',
        'resizer_width2' => '324',
        'resizer_height2' => '156',
      ),
    ),
    'thesis_comment_avatar' => 
    array (
      'thesis_comments_1438855738_thesis_comment_avatar' => 
      array (
        '_id' => 'comments',
        '_parent' => 'thesis_comments_1438855738',
      ),
    ),
    'bts_author_box_title' => 
    array (
      'bts_author_box_bts_author_box_title' => 
      array (
        'author_name' => 
        array (
          'enable' => true,
        ),
        '_parent' => 'bts_author_box',
      ),
    ),
    'bts_author_username' => 
    array (
      'bts_author_box_bts_author_username' => 
      array (
        'occupations' => 
        array (
          'enable' => true,
        ),
        '_parent' => 'bts_author_box',
      ),
    ),
  ),
  'vars' => 
  array (
    'var_1438596789' => 
    array (
      'name' => 'Author Avatar',
      'ref' => 'avatar',
      'css' => 'width: 81px;
	height: 81px;',
    ),
    'var_1438596802' => 
    array (
      'name' => 'Author Description Avatar',
      'ref' => 'bio_avatar',
      'css' => 'width: 84px;
	height: 84px;',
    ),
    'var_1438596826' => 
    array (
      'name' => 'Blockquote',
      'ref' => 'blockquote',
      'css' => 'color: #333333;',
    ),
    'var_1438596847' => 
    array (
      'name' => 'Code',
      'ref' => 'code',
      'css' => 'font-family: Consolas, Menlo, Monaco, Courier, Verdana, sans-serif;',
    ),
    'var_1438596868' => 
    array (
      'name' => 'Color 1',
      'ref' => 'color1',
      'css' => '#DDDDDD',
    ),
    'var_1438596895' => 
    array (
      'name' => 'Color 2',
      'ref' => 'color2',
      'css' => '#FFFFFF',
    ),
    'var_1438596916' => 
    array (
      'name' => 'Color 3',
      'ref' => 'color3',
      'css' => '#F5F5F5',
    ),
    'var_1438596933' => 
    array (
      'name' => 'Content Column',
      'ref' => 'column1',
      'css' => 'float: left;
	padding: 0 20px 0 0;',
    ),
    'var_1438596950' => 
    array (
      'name' => 'Sidebar Column',
      'ref' => 'column2',
      'css' => 'width: $w_sidebar;
	float: right;
	padding: 0 20px 0 0;',
    ),
    'var_1438596967' => 
    array (
      'name' => 'Comment Avatar',
      'ref' => 'comment_avatar',
      'css' => 'width: 56px;
	height: 56px;',
    ),
    'var_1438596986' => 
    array (
      'name' => 'Font: Primary',
      'ref' => 'font',
      'css' => '"Helvetica Neue", Helvetica, Arial, sans-serif',
    ),
    'var_1438597006' => 
    array (
      'name' => 'Font Size: Auxiliary',
      'ref' => 'f_aux',
      'css' => '13px',
    ),
    'var_1438597023' => 
    array (
      'name' => 'Font Size: Sub-headline',
      'ref' => 'f_subhead',
      'css' => '20px',
    ),
    'var_1438597042' => 
    array (
      'name' => 'Font Size: Text',
      'ref' => 'f_text',
      'css' => '16px',
    ),
    'var_1438597063' => 
    array (
      'name' => 'Headline',
      'ref' => 'headline',
      'css' => 'font-size: 38px;
	line-height: 57px;',
    ),
    'var_1438597088' => 
    array (
      'name' => 'Headline Color',
      'ref' => 'headline_color',
      'css' => '#333',
    ),
    'var_1438597189' => 
    array (
      'name' => 'Line Height: Auxiliary Text',
      'ref' => 'h_aux',
      'css' => '24px',
    ),
    'var_1438597214' => 
    array (
      'name' => 'Line Height: Text',
      'ref' => 'h_text',
      'css' => '28px',
    ),
    'var_1438597235' => 
    array (
      'name' => 'Links',
      'ref' => 'links',
      'css' => '#FFD540',
    ),
    'var_1438597253' => 
    array (
      'name' => 'Nav Menu',
      'ref' => 'menu',
      'css' => 'font-family: "Open Sans", sans-serif;
	font-size: 14px;
	line-height: 21px;',
    ),
    'var_1438597269' => 
    array (
      'name' => 'Pre-formatted Code',
      'ref' => 'pre',
      'css' => 'font-family: Consolas, Menlo, Monaco, Courier, Verdana, sans-serif;',
    ),
    'var_1438597289' => 
    array (
      'name' => 'Pullquote',
      'ref' => 'pullquote',
      'css' => 'font-size: 26px;
	line-height: 37px;',
    ),
    'var_1438597305' => 
    array (
      'name' => 'Sidebar',
      'ref' => 'sidebar',
      'css' => 'font-size: 13px;
	line-height: 20px;',
    ),
    'var_1438597331' => 
    array (
      'name' => 'Sidebar Heading',
      'ref' => 'sidebar_heading',
      'css' => 'font-size: 21px;
	line-height: 30px;',
    ),
    'var_1438597761' => 
    array (
      'name' => 'Sub-headline',
      'ref' => 'subhead',
      'css' => 'font-size: 24px;
	line-height: 39px;',
    ),
    'var_1438597802' => 
    array (
      'name' => 'Sub-headline Color',
      'ref' => 'subhead_color',
      'css' => '#333',
    ),
    'var_1438597830' => 
    array (
      'name' => 'Navigation Submenu',
      'ref' => 'submenu',
      'css' => '196px',
    ),
    'var_1438597848' => 
    array (
      'name' => 'Sidebar Spacing: 1.5',
      'ref' => 's_x_3over2',
      'css' => '30px',
    ),
    'var_1438597871' => 
    array (
      'name' => 'Sidebar Spacing: Double',
      'ref' => 's_x_double',
      'css' => '40px',
    ),
    'var_1438597889' => 
    array (
      'name' => 'Sidebar Spacing: Half',
      'ref' => 's_x_half',
      'css' => '10px',
    ),
    'var_1438597906' => 
    array (
      'name' => 'Sidebar Spacing: Single',
      'ref' => 's_x_single',
      'css' => '20px',
    ),
    'var_1438597922' => 
    array (
      'name' => 'Tagline',
      'ref' => 'tagline',
      'css' => 'font-size: 16px;
	color: #333333;',
    ),
    'var_1438597939' => 
    array (
      'name' => 'Primary Text Color',
      'ref' => 'text1',
      'css' => '#888888',
    ),
    'var_1438597954' => 
    array (
      'name' => 'Secondary Text Color',
      'ref' => 'text2',
      'css' => '#333333',
    ),
    'var_1438597971' => 
    array (
      'name' => 'Site Title',
      'ref' => 'title',
      'css' => 'font-size: 42px;',
    ),
    'var_1438597987' => 
    array (
      'name' => 'Site Title Color',
      'ref' => 'title_color',
      'css' => '#888888',
    ),
    'var_1438598003' => 
    array (
      'name' => 'Width: Content',
      'ref' => 'w_content',
      'css' => '850px',
    ),
    'var_1438598019' => 
    array (
      'name' => 'Width: Sidebar',
      'ref' => 'w_sidebar',
      'css' => '350px',
    ),
    'var_1438598037' => 
    array (
      'name' => 'Width: Total',
      'ref' => 'w_total',
      'css' => '1200px',
    ),
    'var_1438598061' => 
    array (
      'name' => 'Spacing: 1.5',
      'ref' => 'x_3over2',
      'css' => '42px',
    ),
    'var_1438598080' => 
    array (
      'name' => 'Spacing: Double',
      'ref' => 'x_double',
      'css' => '56px',
    ),
    'var_1438598096' => 
    array (
      'name' => 'Spacing: Half',
      'ref' => 'x_half',
      'css' => '14px',
    ),
    'var_1438598118' => 
    array (
      'name' => 'Spacing: Single',
      'ref' => 'x_single',
      'css' => '28px',
    ),
    'var_1438598134' => 
    array (
      'name' => 'Clearfix',
      'ref' => 'z_clearfix',
      'css' => 'content: \\".\\"; display: block; height: 0; clear: both; visibility: hidden;',
    ),
    'var_1438945521' => 
    array (
      'name' => 'Color5',
      'ref' => 'color5',
      'css' => '#212121',
    ),
    'var_1438947096' => 
    array (
      'name' => 'Top Bottom Header BG',
      'ref' => 'tb_header_bg',
      'css' => '#393939',
    ),
    'var_1438947220' => 
    array (
      'name' => 'Center Header BG',
      'ref' => 'ctr_hdr_bg',
      'css' => '#232323',
    ),
    'var_1438947778' => 
    array (
      'name' => 'Color4',
      'ref' => 'color4',
      'css' => '#555555',
    ),
    'var_1439012717' => 
    array (
      'name' => 'Socila follow BG',
      'ref' => 'social_flw_bg',
      'css' => '#BBBBBB',
    ),
    'var_1439013430' => 
    array (
      'name' => 'Footer Text Color',
      'ref' => 'ftext_clr',
      'css' => '#999999',
    ),
    'var_1439013625' => 
    array (
      'name' => 'Title1',
      'ref' => 'blk_title1',
      'css' => '#EF4D4E',
    ),
    'var_1439013660' => 
    array (
      'name' => 'Title2',
      'ref' => 'blk_title2',
      'css' => '#A9C056',
    ),
    'var_1439013688' => 
    array (
      'name' => 'Title3',
      'ref' => 'blk_title3',
      'css' => '#27AAC5',
    ),
    'var_1439013711' => 
    array (
      'name' => 'Title4',
      'ref' => 'blk_title4',
      'css' => '#9B59B6',
    ),
    'var_1439013732' => 
    array (
      'name' => 'Title5',
      'ref' => 'blk_title5',
      'css' => '#FF9C31',
    ),
    'var_1439015049' => 
    array (
      'name' => 'Post BG',
      'ref' => 'post_bg',
      'css' => '#F8F8F8',
    ),
    'var_1439015129' => 
    array (
      'name' => 'Sb Border',
      'ref' => 'sb_border',
      'css' => '#EAEAEA',
    ),
    'var_1439015186' => 
    array (
      'name' => 'Body BG',
      'ref' => 'body_bg',
      'css' => '#E7E7E7',
    ),
    'var_1439883240' => 
    array (
      'name' => 'Block Title6',
      'ref' => 'blk_title6',
      'css' => '#46BFA9',
    ),
    'var_1441175232' => 
    array (
      'name' => 'Search Background Color',
      'ref' => 'search_bg',
      'css' => '#444444',
    ),
  ),
  'templates' => 
  array (
    'home' => 
    array (
      'options' => 
      array (
        'thesis_js' => 
        array (
          'libs' => 
          array (
            'jquery' => true,
          ),
          'head_scripts' => '<link href=\'https://fonts.googleapis.com/css?family=Roboto+Slab\' rel=\'stylesheet\' type=\'text/css\'>',
        ),
        'thesis_wp_loop' => 
        array (
          'posts_per_page' => '6',
        ),
      ),
      'boxes' => 
      array (
        'thesis_html_body' => 
        array (
          0 => 'newmagaz_scripts',
          1 => 'thesis_html_container_1438599279',
        ),
        'thesis_html_container_1438599279' => 
        array (
          0 => 'thesis_html_container_1438665528',
          1 => 'thesis_html_container_1438674902',
          2 => 'thesis_html_container_1438766338',
        ),
        'thesis_html_container_1438665528' => 
        array (
          0 => 'thesis_html_container_1438599248',
          1 => 'thesis_html_container_1438599308',
          2 => 'thesis_html_container_1438599332',
        ),
        'thesis_html_container_1438599248' => 
        array (
          0 => 'thesis_html_container_1438666111',
          1 => 'thesis_html_container_1438666139',
        ),
        'thesis_html_container_1438666111' => 
        array (
          0 => 'newmagaz_breaking_news',
        ),
        'thesis_html_container_1438666139' => 
        array (
          0 => 'newmagaz_search',
        ),
        'thesis_html_container_1438599308' => 
        array (
          0 => 'thesis_html_container_1452329597',
          1 => 'newmagaz_header_advertisement',
        ),
        'thesis_html_container_1452329597' => 
        array (
          0 => 'thesis_site_title',
          1 => 'thesis_site_tagline',
        ),
        'thesis_html_container_1438599332' => 
        array (
          0 => 'thesis_wp_nav_menu_1438666176',
        ),
        'thesis_html_container_1438674902' => 
        array (
          0 => 'thesis_html_container_1438674951',
        ),
        'thesis_html_container_1438674951' => 
        array (
          0 => 'thesis_html_container_1438682239',
          1 => 'newmagaz_random_box',
        ),
        'thesis_html_container_1438682239' => 
        array (
          0 => 'thesis_html_container_1438682089',
          1 => 'thesis_html_container_1438682116',
        ),
        'thesis_html_container_1438682089' => 
        array (
          0 => 'thesis_wp_loop',
          1 => 'newmagaz_page_navigation',
        ),
        'thesis_wp_loop' => 
        array (
          0 => 'thesis_post_box_1438775342',
        ),
        'thesis_post_box_1438775342' => 
        array (
          0 => 'thesis_html_container_1438775360',
          1 => 'thesis_html_container_1438775392',
        ),
        'thesis_html_container_1438775360' => 
        array (
          0 => 'newmagaz_featured_image_1438775416',
        ),
        'thesis_html_container_1438775392' => 
        array (
          0 => 'thesis_post_box_1438775342_thesis_post_categories',
          1 => 'thesis_post_box_1438775342_thesis_post_headline',
          2 => 'thesis_html_container_1438775697',
          3 => 'thesis_post_box_1438775342_thesis_post_excerpt',
          4 => 'thesis_html_container_1438837423',
        ),
        'thesis_html_container_1438775697' => 
        array (
          0 => 'thesis_post_box_1438775342_thesis_post_author',
          1 => 'thesis_post_box_1438775342_thesis_post_date',
        ),
        'thesis_html_container_1438837423' => 
        array (
          0 => 'newmagaz_readmore',
          1 => 'thesis_post_box_1438775342_thesis_post_num_comments',
        ),
        'thesis_html_container_1438682116' => 
        array (
          0 => 'newmagaz_popular_posts',
          1 => 'newmagaz_recently_updated_posts',
          2 => 'newmagaz_sidebar_advertisement',
          3 => 'newmagaz_social_follow',
          4 => 'newmagaz_recent_comments_box',
          5 => 'newmagaz_photostream_box',
          6 => 'newmagaz_sidebar_optin_box',
        ),
        'thesis_html_container_1438766338' => 
        array (
          0 => 'thesis_html_container_1438766423',
        ),
        'thesis_html_container_1438766423' => 
        array (
          0 => 'thesis_html_container_1438766482',
          1 => 'thesis_html_container_1438766513',
        ),
        'thesis_html_container_1438766482' => 
        array (
          0 => 'thesis_wp_widgets_1438766601',
        ),
        'thesis_html_container_1438766513' => 
        array (
          0 => 'thesis_attribution',
        ),
      ),
    ),
    'front' => 
    array (
      'options' => 
      array (
        'thesis_js' => 
        array (
          'libs' => 
          array (
            'jquery' => true,
          ),
          'head_scripts' => '<link href=\'https://fonts.googleapis.com/css?family=Roboto+Slab\' rel=\'stylesheet\' type=\'text/css\'>',
        ),
      ),
      'boxes' => 
      array (
        'thesis_html_body' => 
        array (
          0 => 'newmagaz_scripts',
          1 => 'thesis_html_container_1438599279',
        ),
        'thesis_html_container_1438599279' => 
        array (
          0 => 'thesis_html_container_1438665528',
          1 => 'thesis_html_container_1438674902',
          2 => 'thesis_html_container_1438766338',
        ),
        'thesis_html_container_1438665528' => 
        array (
          0 => 'thesis_html_container_1438599248',
          1 => 'thesis_html_container_1438599308',
          2 => 'thesis_html_container_1438599332',
        ),
        'thesis_html_container_1438599248' => 
        array (
          0 => 'thesis_html_container_1438666111',
          1 => 'thesis_html_container_1438666139',
        ),
        'thesis_html_container_1438666111' => 
        array (
          0 => 'newmagaz_breaking_news',
        ),
        'thesis_html_container_1438666139' => 
        array (
          0 => 'newmagaz_search',
        ),
        'thesis_html_container_1438599308' => 
        array (
          0 => 'thesis_html_container_1452329597',
          1 => 'newmagaz_header_advertisement',
        ),
        'thesis_html_container_1452329597' => 
        array (
          0 => 'thesis_site_title',
          1 => 'thesis_site_tagline',
        ),
        'thesis_html_container_1438599332' => 
        array (
          0 => 'thesis_wp_nav_menu_1438666176',
        ),
        'thesis_html_container_1438674902' => 
        array (
          0 => 'thesis_html_container_1438674951',
        ),
        'thesis_html_container_1438674951' => 
        array (
          0 => 'newmagaz_latest_news',
          1 => 'thesis_html_container_1438682239',
          2 => 'newmagaz_random_box',
        ),
        'thesis_html_container_1438682239' => 
        array (
          0 => 'thesis_html_container_1438682089',
          1 => 'thesis_html_container_1438682116',
        ),
        'thesis_html_container_1438682089' => 
        array (
          0 => 'newmagaz_first_category',
          1 => 'newmagaz_sixth_category',
          2 => 'thesis_html_container_1438686602',
          3 => 'newmagaz_content_advertisement',
          4 => 'newmagaz_seventh_category',
          5 => 'newmagaz_fourth_category',
          6 => 'newmagaz_fifth_category',
        ),
        'thesis_html_container_1438686602' => 
        array (
          0 => 'newmagaz_second_category',
          1 => 'newmagaz_third_category',
        ),
        'thesis_html_container_1438682116' => 
        array (
          0 => 'newmagaz_popular_posts',
          1 => 'newmagaz_recently_updated_posts',
          2 => 'newmagaz_sidebar_advertisement',
          3 => 'newmagaz_social_follow',
          4 => 'newmagaz_recent_comments_box',
          5 => 'newmagaz_photostream_box',
          6 => 'newmagaz_sidebar_optin_box',
        ),
        'thesis_html_container_1438766338' => 
        array (
          0 => 'thesis_html_container_1438766423',
        ),
        'thesis_html_container_1438766423' => 
        array (
          0 => 'thesis_html_container_1438766482',
          1 => 'thesis_html_container_1438766513',
        ),
        'thesis_html_container_1438766482' => 
        array (
          0 => 'thesis_wp_widgets_1438766601',
        ),
        'thesis_html_container_1438766513' => 
        array (
          0 => 'thesis_attribution',
        ),
      ),
    ),
    'single' => 
    array (
      'options' => 
      array (
        'thesis_js' => 
        array (
          'libs' => 
          array (
            'jquery' => true,
          ),
          'head_scripts' => '<link href=\'https://fonts.googleapis.com/css?family=Roboto+Slab\' rel=\'stylesheet\' type=\'text/css\'>',
        ),
      ),
      'boxes' => 
      array (
        'thesis_html_body' => 
        array (
          0 => 'newmagaz_scripts',
          1 => 'thesis_html_container_1438599279',
        ),
        'thesis_html_container_1438599279' => 
        array (
          0 => 'thesis_html_container_1438665528',
          1 => 'thesis_html_container_1438674902',
          2 => 'thesis_html_container_1438766338',
        ),
        'thesis_html_container_1438665528' => 
        array (
          0 => 'thesis_html_container_1438599248',
          1 => 'thesis_html_container_1438599308',
          2 => 'thesis_html_container_1438599332',
        ),
        'thesis_html_container_1438599248' => 
        array (
          0 => 'thesis_html_container_1438666111',
          1 => 'thesis_html_container_1438666139',
        ),
        'thesis_html_container_1438666111' => 
        array (
          0 => 'newmagaz_breaking_news',
        ),
        'thesis_html_container_1438666139' => 
        array (
          0 => 'newmagaz_search',
        ),
        'thesis_html_container_1438599308' => 
        array (
          0 => 'thesis_html_container_1452329597',
          1 => 'newmagaz_header_advertisement',
        ),
        'thesis_html_container_1452329597' => 
        array (
          0 => 'thesis_site_title',
          1 => 'thesis_site_tagline',
        ),
        'thesis_html_container_1438599332' => 
        array (
          0 => 'thesis_wp_nav_menu_1438666176',
        ),
        'thesis_html_container_1438674902' => 
        array (
          0 => 'thesis_html_container_1438674951',
        ),
        'thesis_html_container_1438674951' => 
        array (
          0 => 'thesis_html_container_1438682239',
          1 => 'newmagaz_random_box',
        ),
        'thesis_html_container_1438682239' => 
        array (
          0 => 'thesis_wp_loop',
        ),
        'thesis_wp_loop' => 
        array (
          0 => 'thesis_post_box_1438855228',
        ),
        'thesis_post_box_1438855228' => 
        array (
          0 => 'newmagaz_breadcrumbs',
          1 => 'thesis_html_container_1438856430',
          2 => 'thesis_post_box_1438855228_thesis_post_categories',
          3 => 'thesis_html_container_1439365414',
          4 => 'thesis_html_container_1438682089',
          5 => 'thesis_html_container_1438682116',
        ),
        'thesis_html_container_1438856430' => 
        array (
          0 => 'thesis_previous_post_link',
          1 => 'thesis_next_post_link',
        ),
        'thesis_html_container_1439365414' => 
        array (
          0 => 'thesis_post_box_1438855228_thesis_post_headline',
          1 => 'thesis_html_container_1438855633',
        ),
        'thesis_html_container_1438855633' => 
        array (
          0 => 'thesis_post_box_1438855228_thesis_post_author',
          1 => 'thesis_post_box_1438855228_thesis_post_date',
          2 => 'thesis_post_box_1438855228_thesis_post_num_comments',
          3 => 'thesis_post_box_1438855228_thesis_post_edit',
        ),
        'thesis_html_container_1438682089' => 
        array (
          0 => 'thesis_html_container_1439370805',
        ),
        'thesis_html_container_1439370805' => 
        array (
          0 => 'thesis_post_box_1438855228_thesis_post_content',
          1 => 'thesis_post_box_1438855228_thesis_post_tags',
          2 => 'newmagaz_social_sharing_box',
          3 => 'bts_author_box',
          4 => 'newmagaz_related_box',
          5 => 'thesis_html_container_1438855746',
        ),
        'bts_author_box' => 
        array (
          0 => 'bts_author_box_bts_author_box_title',
          1 => 'bts_author_box_bts_author_avatar',
          2 => 'thesis_html_container_1438858424',
        ),
        'thesis_html_container_1438858424' => 
        array (
          0 => 'bts_author_box_bts_author_username',
          1 => 'bts_author_box_bts_author_description',
          2 => 'bts_author_box_bts_twitter_id',
          3 => 'bts_author_box_bts_facebook',
          4 => 'bts_author_box_bts_gplus',
        ),
        'thesis_html_container_1438855746' => 
        array (
          0 => 'thesis_comment_form_1438855733',
          1 => 'thesis_comments_1438855738',
        ),
        'thesis_comment_form_1438855733' => 
        array (
          0 => 'thesis_html_container_1438925459',
          1 => 'thesis_comment_form_1438855733_thesis_comment_form_cancel',
          2 => 'thesis_comment_form_1438855733_thesis_comment_form_name',
          3 => 'thesis_comment_form_1438855733_thesis_comment_form_email',
          4 => 'thesis_comment_form_1438855733_thesis_comment_form_url',
          5 => 'thesis_comment_form_1438855733_thesis_comment_form_comment',
          6 => 'thesis_comment_form_1438855733_thesis_comment_form_submit',
        ),
        'thesis_html_container_1438925459' => 
        array (
          0 => 'thesis_comment_form_1438855733_thesis_comment_form_title',
        ),
        'thesis_comments_1438855738' => 
        array (
          0 => 'thesis_html_container_1438855964',
        ),
        'thesis_html_container_1438855964' => 
        array (
          0 => 'thesis_comments_1438855738_thesis_comment_avatar',
          1 => 'thesis_html_container_1438855959',
        ),
        'thesis_html_container_1438855959' => 
        array (
          0 => 'thesis_comments_1438855738_thesis_comment_author',
          1 => 'thesis_html_container_1438855849',
          2 => 'thesis_comments_1438855738_thesis_comment_text',
          3 => 'thesis_comments_1438855738_thesis_comment_reply',
        ),
        'thesis_html_container_1438855849' => 
        array (
          0 => 'thesis_comments_1438855738_thesis_comment_date',
          1 => 'thesis_comments_1438855738_thesis_comment_edit',
        ),
        'thesis_html_container_1438682116' => 
        array (
          0 => 'newmagaz_popular_posts',
          1 => 'newmagaz_recently_updated_posts',
          2 => 'newmagaz_sidebar_advertisement',
          3 => 'newmagaz_social_follow',
          4 => 'newmagaz_recent_comments_box',
          5 => 'newmagaz_photostream_box',
          6 => 'newmagaz_sidebar_optin_box',
        ),
        'thesis_html_container_1438766338' => 
        array (
          0 => 'thesis_html_container_1438766423',
        ),
        'thesis_html_container_1438766423' => 
        array (
          0 => 'thesis_html_container_1438766482',
          1 => 'thesis_html_container_1438766513',
        ),
        'thesis_html_container_1438766482' => 
        array (
          0 => 'thesis_wp_widgets_1438766601',
        ),
        'thesis_html_container_1438766513' => 
        array (
          0 => 'thesis_attribution',
        ),
      ),
    ),
    'fourohfour' => 
    array (
      'options' => 
      array (
        'thesis_js' => 
        array (
          'libs' => 
          array (
            'jquery' => true,
          ),
          'head_scripts' => '<link href=\'https://fonts.googleapis.com/css?family=Roboto+Slab\' rel=\'stylesheet\' type=\'text/css\'>',
        ),
      ),
      'boxes' => 
      array (
        'thesis_html_body' => 
        array (
          0 => 'newmagaz_scripts',
          1 => 'thesis_html_container_1438599279',
        ),
        'thesis_html_container_1438599279' => 
        array (
          0 => 'thesis_html_container_1438665528',
          1 => 'thesis_html_container_1438674902',
          2 => 'thesis_html_container_1438766338',
        ),
        'thesis_html_container_1438665528' => 
        array (
          0 => 'thesis_html_container_1438599248',
          1 => 'thesis_html_container_1438599308',
          2 => 'thesis_html_container_1438599332',
        ),
        'thesis_html_container_1438599248' => 
        array (
          0 => 'thesis_html_container_1438666111',
          1 => 'thesis_html_container_1438666139',
        ),
        'thesis_html_container_1438666111' => 
        array (
          0 => 'newmagaz_breaking_news',
        ),
        'thesis_html_container_1438666139' => 
        array (
          0 => 'newmagaz_search',
        ),
        'thesis_html_container_1438599308' => 
        array (
          0 => 'thesis_html_container_1452329597',
          1 => 'newmagaz_header_advertisement',
        ),
        'thesis_html_container_1452329597' => 
        array (
          0 => 'thesis_site_title',
          1 => 'thesis_site_tagline',
        ),
        'thesis_html_container_1438599332' => 
        array (
          0 => 'thesis_wp_nav_menu_1438666176',
        ),
        'thesis_html_container_1438674902' => 
        array (
          0 => 'thesis_html_container_1438674951',
        ),
        'thesis_html_container_1438674951' => 
        array (
          0 => 'newmagaz_404_errorpage',
        ),
        'thesis_html_container_1438766338' => 
        array (
          0 => 'thesis_html_container_1438766423',
        ),
        'thesis_html_container_1438766423' => 
        array (
          0 => 'thesis_html_container_1438766482',
          1 => 'thesis_html_container_1438766513',
        ),
        'thesis_html_container_1438766482' => 
        array (
          0 => 'thesis_wp_widgets_1438766601',
        ),
        'thesis_html_container_1438766513' => 
        array (
          0 => 'thesis_attribution',
        ),
      ),
    ),
    'page' => 
    array (
      'options' => 
      array (
        'thesis_js' => 
        array (
          'libs' => 
          array (
            'jquery' => true,
          ),
          'head_scripts' => '<link href=\'https://fonts.googleapis.com/css?family=Roboto+Slab\' rel=\'stylesheet\' type=\'text/css\'>',
        ),
      ),
      'boxes' => 
      array (
        'thesis_html_body' => 
        array (
          0 => 'newmagaz_scripts',
          1 => 'thesis_html_container_1438599279',
        ),
        'thesis_html_container_1438599279' => 
        array (
          0 => 'thesis_html_container_1438665528',
          1 => 'thesis_html_container_1438674902',
          2 => 'thesis_html_container_1438766338',
        ),
        'thesis_html_container_1438665528' => 
        array (
          0 => 'thesis_html_container_1438599248',
          1 => 'thesis_html_container_1438599308',
          2 => 'thesis_html_container_1438599332',
        ),
        'thesis_html_container_1438599248' => 
        array (
          0 => 'thesis_html_container_1438666111',
          1 => 'thesis_html_container_1438666139',
        ),
        'thesis_html_container_1438666111' => 
        array (
          0 => 'newmagaz_breaking_news',
        ),
        'thesis_html_container_1438666139' => 
        array (
          0 => 'newmagaz_search',
        ),
        'thesis_html_container_1438599308' => 
        array (
          0 => 'thesis_html_container_1452329597',
          1 => 'newmagaz_header_advertisement',
        ),
        'thesis_html_container_1452329597' => 
        array (
          0 => 'thesis_site_title',
          1 => 'thesis_site_tagline',
        ),
        'thesis_html_container_1438599332' => 
        array (
          0 => 'thesis_wp_nav_menu_1438666176',
        ),
        'thesis_html_container_1438674902' => 
        array (
          0 => 'thesis_html_container_1438674951',
        ),
        'thesis_html_container_1438674951' => 
        array (
          0 => 'thesis_html_container_1438682239',
          1 => 'newmagaz_random_box',
        ),
        'thesis_html_container_1438682239' => 
        array (
          0 => 'thesis_wp_loop',
        ),
        'thesis_wp_loop' => 
        array (
          0 => 'thesis_post_box_1438855228',
        ),
        'thesis_post_box_1438855228' => 
        array (
          0 => 'newmagaz_breadcrumbs',
          1 => 'thesis_post_box_1438855228_thesis_post_categories',
          2 => 'thesis_html_container_1439365414',
          3 => 'thesis_html_container_1438682089',
          4 => 'thesis_html_container_1438682116',
        ),
        'thesis_html_container_1439365414' => 
        array (
          0 => 'thesis_post_box_1438855228_thesis_post_headline',
          1 => 'thesis_html_container_1438855633',
        ),
        'thesis_html_container_1438855633' => 
        array (
          0 => 'thesis_post_box_1438855228_thesis_post_author',
          1 => 'thesis_post_box_1438855228_thesis_post_date',
          2 => 'thesis_post_box_1438855228_thesis_post_num_comments',
          3 => 'thesis_post_box_1438855228_thesis_post_edit',
        ),
        'thesis_html_container_1438682089' => 
        array (
          0 => 'thesis_html_container_1439370805',
        ),
        'thesis_html_container_1439370805' => 
        array (
          0 => 'thesis_post_box_1438855228_thesis_post_content',
          1 => 'thesis_post_box_1438855228_thesis_post_tags',
          2 => 'thesis_html_container_1438861079',
        ),
        'thesis_html_container_1438861079' => 
        array (
          0 => 'thesis_comment_form_1438855733',
          1 => 'thesis_comments_1438855738',
        ),
        'thesis_comment_form_1438855733' => 
        array (
          0 => 'thesis_html_container_1438925459',
          1 => 'thesis_comment_form_1438855733_thesis_comment_form_cancel',
          2 => 'thesis_comment_form_1438855733_thesis_comment_form_name',
          3 => 'thesis_comment_form_1438855733_thesis_comment_form_email',
          4 => 'thesis_comment_form_1438855733_thesis_comment_form_url',
          5 => 'thesis_comment_form_1438855733_thesis_comment_form_comment',
          6 => 'thesis_comment_form_1438855733_thesis_comment_form_submit',
        ),
        'thesis_html_container_1438925459' => 
        array (
          0 => 'thesis_comment_form_1438855733_thesis_comment_form_title',
        ),
        'thesis_comments_1438855738' => 
        array (
          0 => 'thesis_html_container_1438855964',
        ),
        'thesis_html_container_1438855964' => 
        array (
          0 => 'thesis_comments_1438855738_thesis_comment_avatar',
          1 => 'thesis_html_container_1438855959',
        ),
        'thesis_html_container_1438855959' => 
        array (
          0 => 'thesis_comments_1438855738_thesis_comment_author',
          1 => 'thesis_html_container_1438855849',
          2 => 'thesis_comments_1438855738_thesis_comment_text',
          3 => 'thesis_comments_1438855738_thesis_comment_reply',
        ),
        'thesis_html_container_1438855849' => 
        array (
          0 => 'thesis_comments_1438855738_thesis_comment_date',
          1 => 'thesis_comments_1438855738_thesis_comment_edit',
        ),
        'thesis_html_container_1438682116' => 
        array (
          0 => 'newmagaz_popular_posts',
          1 => 'newmagaz_recently_updated_posts',
          2 => 'newmagaz_sidebar_advertisement',
          3 => 'newmagaz_social_follow',
          4 => 'newmagaz_recent_comments_box',
          5 => 'newmagaz_photostream_box',
          6 => 'newmagaz_sidebar_optin_box',
        ),
        'thesis_html_container_1438766338' => 
        array (
          0 => 'thesis_html_container_1438766423',
        ),
        'thesis_html_container_1438766423' => 
        array (
          0 => 'thesis_html_container_1438766482',
          1 => 'thesis_html_container_1438766513',
        ),
        'thesis_html_container_1438766482' => 
        array (
          0 => 'thesis_wp_widgets_1438766601',
        ),
        'thesis_html_container_1438766513' => 
        array (
          0 => 'thesis_attribution',
        ),
      ),
    ),
    'archive' => 
    array (
      'options' => 
      array (
        'thesis_js' => 
        array (
          'libs' => 
          array (
            'jquery' => true,
          ),
          'head_scripts' => '<link href=\'https://fonts.googleapis.com/css?family=Roboto+Slab\' rel=\'stylesheet\' type=\'text/css\'>',
        ),
        'thesis_wp_loop' => 
        array (
          'posts_per_page' => '6',
        ),
      ),
      'boxes' => 
      array (
        'thesis_html_body' => 
        array (
          0 => 'newmagaz_scripts',
          1 => 'thesis_html_container_1438599279',
        ),
        'thesis_html_container_1438599279' => 
        array (
          0 => 'thesis_html_container_1438665528',
          1 => 'thesis_html_container_1438674902',
          2 => 'thesis_html_container_1438766338',
        ),
        'thesis_html_container_1438665528' => 
        array (
          0 => 'thesis_html_container_1438599248',
          1 => 'thesis_html_container_1438599308',
          2 => 'thesis_html_container_1438599332',
        ),
        'thesis_html_container_1438599248' => 
        array (
          0 => 'thesis_html_container_1438666111',
          1 => 'thesis_html_container_1438666139',
        ),
        'thesis_html_container_1438666111' => 
        array (
          0 => 'newmagaz_breaking_news',
        ),
        'thesis_html_container_1438666139' => 
        array (
          0 => 'newmagaz_search',
        ),
        'thesis_html_container_1438599308' => 
        array (
          0 => 'thesis_html_container_1452329597',
          1 => 'newmagaz_header_advertisement',
        ),
        'thesis_html_container_1452329597' => 
        array (
          0 => 'thesis_site_title',
          1 => 'thesis_site_tagline',
        ),
        'thesis_html_container_1438599332' => 
        array (
          0 => 'thesis_wp_nav_menu_1438666176',
        ),
        'thesis_html_container_1438674902' => 
        array (
          0 => 'thesis_html_container_1438674951',
        ),
        'thesis_html_container_1438674951' => 
        array (
          0 => 'thesis_html_container_1438682239',
          1 => 'newmagaz_random_box',
        ),
        'thesis_html_container_1438682239' => 
        array (
          0 => 'thesis_html_container_1438682089',
          1 => 'thesis_html_container_1438682116',
        ),
        'thesis_html_container_1438682089' => 
        array (
          0 => 'thesis_archive_title',
          1 => 'thesis_wp_loop',
          2 => 'newmagaz_page_navigation',
        ),
        'thesis_wp_loop' => 
        array (
          0 => 'thesis_post_box_1438775342',
        ),
        'thesis_post_box_1438775342' => 
        array (
          0 => 'thesis_html_container_1438775360',
          1 => 'thesis_html_container_1438775392',
        ),
        'thesis_html_container_1438775360' => 
        array (
          0 => 'newmagaz_featured_image_1438775416',
        ),
        'thesis_html_container_1438775392' => 
        array (
          0 => 'thesis_post_box_1438775342_thesis_post_categories',
          1 => 'thesis_post_box_1438775342_thesis_post_headline',
          2 => 'thesis_html_container_1438775697',
          3 => 'thesis_post_box_1438775342_thesis_post_excerpt',
          4 => 'thesis_html_container_1438837423',
        ),
        'thesis_html_container_1438775697' => 
        array (
          0 => 'thesis_post_box_1438775342_thesis_post_author',
          1 => 'thesis_post_box_1438775342_thesis_post_date',
        ),
        'thesis_html_container_1438837423' => 
        array (
          0 => 'newmagaz_readmore',
          1 => 'thesis_post_box_1438775342_thesis_post_num_comments',
        ),
        'thesis_html_container_1438682116' => 
        array (
          0 => 'newmagaz_popular_posts',
          1 => 'newmagaz_recently_updated_posts',
          2 => 'newmagaz_sidebar_advertisement',
          3 => 'newmagaz_social_follow',
          4 => 'newmagaz_recent_comments_box',
          5 => 'newmagaz_photostream_box',
          6 => 'newmagaz_sidebar_optin_box',
        ),
        'thesis_html_container_1438766338' => 
        array (
          0 => 'thesis_html_container_1438766423',
        ),
        'thesis_html_container_1438766423' => 
        array (
          0 => 'thesis_html_container_1438766482',
          1 => 'thesis_html_container_1438766513',
        ),
        'thesis_html_container_1438766482' => 
        array (
          0 => 'thesis_wp_widgets_1438766601',
        ),
        'thesis_html_container_1438766513' => 
        array (
          0 => 'thesis_attribution',
        ),
      ),
    ),
    'custom_1438921001' => 
    array (
      'title' => 'Landing Page One',
      'options' => 
      array (
        'thesis_html_body' => 
        array (
          'class' => 'landing_page',
        ),
        'thesis_js' => 
        array (
          'libs' => 
          array (
            'jquery' => true,
          ),
          'head_scripts' => '<link href=\'https://fonts.googleapis.com/css?family=Roboto+Slab\' rel=\'stylesheet\' type=\'text/css\'>',
        ),
      ),
      'boxes' => 
      array (
        'thesis_html_body' => 
        array (
          0 => 'newmagaz_scripts',
          1 => 'thesis_html_container_1438599279',
        ),
        'thesis_html_container_1438599279' => 
        array (
          0 => 'thesis_html_container_1438665528',
          1 => 'thesis_html_container_1438674902',
          2 => 'thesis_html_container_1438766338',
        ),
        'thesis_html_container_1438665528' => 
        array (
          0 => 'thesis_html_container_1438599248',
          1 => 'thesis_html_container_1438599308',
          2 => 'thesis_html_container_1438599332',
        ),
        'thesis_html_container_1438599248' => 
        array (
          0 => 'thesis_html_container_1438666111',
          1 => 'thesis_html_container_1438666139',
        ),
        'thesis_html_container_1438666111' => 
        array (
          0 => 'newmagaz_breaking_news',
        ),
        'thesis_html_container_1438666139' => 
        array (
          0 => 'newmagaz_search',
        ),
        'thesis_html_container_1438599308' => 
        array (
          0 => 'thesis_html_container_1452329597',
          1 => 'newmagaz_header_advertisement',
        ),
        'thesis_html_container_1452329597' => 
        array (
          0 => 'thesis_site_title',
          1 => 'thesis_site_tagline',
        ),
        'thesis_html_container_1438599332' => 
        array (
          0 => 'thesis_wp_nav_menu_1438666176',
        ),
        'thesis_html_container_1438674902' => 
        array (
          0 => 'thesis_html_container_1438930076',
          1 => 'thesis_html_container_1438674951',
        ),
        'thesis_html_container_1438930076' => 
        array (
          0 => 'newmagaz_landing_optin_with_video_box',
        ),
        'thesis_html_container_1438674951' => 
        array (
          0 => 'newmagaz_landing_box_feature',
          1 => 'thesis_post_box_1438855228',
        ),
        'thesis_post_box_1438855228' => 
        array (
          0 => 'thesis_post_box_1438855228_thesis_post_headline',
          1 => 'thesis_post_box_1438855228_thesis_post_content',
        ),
        'thesis_html_container_1438766338' => 
        array (
          0 => 'thesis_html_container_1438766423',
        ),
        'thesis_html_container_1438766423' => 
        array (
          0 => 'thesis_html_container_1438766482',
          1 => 'thesis_html_container_1438766513',
        ),
        'thesis_html_container_1438766482' => 
        array (
          0 => 'thesis_wp_widgets_1438766601',
        ),
        'thesis_html_container_1438766513' => 
        array (
          0 => 'thesis_attribution',
        ),
      ),
    ),
    'custom_1438938323' => 
    array (
      'title' => 'Landing Page Two',
      'options' => 
      array (
        'thesis_html_body' => 
        array (
          'class' => 'landing_page',
        ),
        'thesis_js' => 
        array (
          'libs' => 
          array (
            'jquery' => true,
          ),
          'head_scripts' => '<link href=\'https://fonts.googleapis.com/css?family=Roboto+Slab\' rel=\'stylesheet\' type=\'text/css\'>',
        ),
      ),
      'boxes' => 
      array (
        'thesis_html_body' => 
        array (
          0 => 'newmagaz_scripts',
          1 => 'thesis_html_container_1438599279',
        ),
        'thesis_html_container_1438599279' => 
        array (
          0 => 'thesis_html_container_1438665528',
          1 => 'thesis_html_container_1438674902',
          2 => 'thesis_html_container_1438766338',
        ),
        'thesis_html_container_1438665528' => 
        array (
          0 => 'thesis_html_container_1438599248',
          1 => 'thesis_html_container_1438599308',
          2 => 'thesis_html_container_1438599332',
        ),
        'thesis_html_container_1438599248' => 
        array (
          0 => 'thesis_html_container_1438666111',
          1 => 'thesis_html_container_1438666139',
        ),
        'thesis_html_container_1438666111' => 
        array (
          0 => 'newmagaz_breaking_news',
        ),
        'thesis_html_container_1438666139' => 
        array (
          0 => 'newmagaz_search',
        ),
        'thesis_html_container_1438599308' => 
        array (
          0 => 'thesis_html_container_1452329597',
          1 => 'newmagaz_header_advertisement',
        ),
        'thesis_html_container_1452329597' => 
        array (
          0 => 'thesis_site_title',
          1 => 'thesis_site_tagline',
        ),
        'thesis_html_container_1438599332' => 
        array (
          0 => 'thesis_wp_nav_menu_1438666176',
        ),
        'thesis_html_container_1438674902' => 
        array (
          0 => 'thesis_html_container_1438930076',
          1 => 'thesis_html_container_1438674951',
        ),
        'thesis_html_container_1438930076' => 
        array (
          0 => 'newmagaz_landing_optin_with_video_box',
        ),
        'thesis_html_container_1438674951' => 
        array (
          0 => 'thesis_post_box_1438855228',
        ),
        'thesis_post_box_1438855228' => 
        array (
          0 => 'thesis_post_box_1438855228_thesis_post_headline',
          1 => 'thesis_post_box_1438855228_thesis_post_content',
        ),
        'thesis_html_container_1438766338' => 
        array (
          0 => 'thesis_html_container_1438766423',
        ),
        'thesis_html_container_1438766423' => 
        array (
          0 => 'thesis_html_container_1438766482',
          1 => 'thesis_html_container_1438766513',
        ),
        'thesis_html_container_1438766482' => 
        array (
          0 => 'thesis_wp_widgets_1438766601',
        ),
        'thesis_html_container_1438766513' => 
        array (
          0 => 'thesis_attribution',
        ),
      ),
    ),
  ),
  '_design' => 
  array (
    'body_bg' => 'E7E7E7',
    'blk_title1' => 'EF4D4E',
    'blk_title2' => 'A9C056',
    'blk_title3' => '27AAC5',
    'blk_title4' => '9B59B6',
    'blk_title5' => 'FF9C31',
    'blk_title6' => '46BFA9',
    'sb_border' => 'EAEAEA',
    'font' => 
    array (
      'family' => 'helvetica',
    ),
    'headline' => 
    array (
      'font-size' => '38',
      'color' => '333',
    ),
    'subhead' => 
    array (
      'font-size' => '24',
      'color' => '333',
    ),
    'menu' => 
    array (
      'font-family' => 'Open Sans',
      'font-size' => '14',
    ),
  ),
  '_display' => 
  array (
    'loop' => 
    array (
      'display' => 
      array (
        'avatar' => true,
        'description' => true,
        'cats' => true,
        'tags' => true,
      ),
    ),
    'misc' => 
    array (
      'display' => 
      array (
        'braces' => false,
      ),
    ),
  ),
);
}
