<?php
/*
Name: NewMagaz
Author: buythesisskins.com
Description: NewMagaz for Thesis 2.1
Version: 1
Class: newmagaz
*/
class newmagaz extends thesis_skin {

public function boxes() {
return array(
'newmagaz_logo',
'newmagaz_featured_image',
'newmagaz_search',
'newmagaz_readmore',
'newmagaz_header_advertisement',
'newmagaz_breaking_news',
'newmagaz_scripts',
'newmagaz_latest_news',
'newmagaz_first_category',
'newmagaz_second_category',
'newmagaz_third_category',
'newmagaz_content_advertisement',
'newmagaz_fourth_category',
'newmagaz_fifth_category',
'newmagaz_sixth_category',
'newmagaz_seventh_category',
'newmagaz_random_box',
'newmagaz_sidebar_advertisement',
'newmagaz_popular_posts',
'newmagaz_recently_updated_posts',
'newmagaz_social_follow',
'newmagaz_recent_comments_box',
'newmagaz_photostream_box',
'newmagaz_sidebar_optin_box',
'newmagaz_social_sharing_box',
'newmagaz_page_navigation',
'newmagaz_landing_optin_with_video_box',
'newmagaz_landing_box_feature',
'newmagaz_related_box',
'newmagaz_404_errorpage',
'newmagaz_breadcrumbs',
'bts_author_box',
);	
}

/*
	Skin API $functionality array. Enable or disable certain Skin features with ease.
	— (documentation link needed)
	*/
	public $functionality = array(
		
		'editor_grt' => true,
		'fonts_google' => true,
		'header_image' => true);
		
	/*
	Skin API pseudo-constructor; place hooks, filters, and other initializations here.
	— http://diythemes.com/thesis/rtfm/api/skin/#section-construct
	*/
	protected function construct() {
		
		global $thesis;
		// logo functionality and integration
		$this->pfied_logo = $thesis->api->get_option("{$this->_class}_logo");
		add_filter('thesis_skin_menu', array($this, 'add_menu'), 11);
		add_filter('thesis_quicklaunch_menu', array($this, 'add_quicklaunch'), 11);
		if (!empty($_GET['canvas']) && $_GET['canvas'] == "{$this->_class}_logo") {
			add_action('admin_init', array($this, '_init_header_image'));
			add_action('thesis_admin_canvas', array($this, 'logo_admin'));
		}
		add_action("admin_post_{$this->_class}_logo", array($this, 'save_logo'));
		add_filter('thesis_site_title', array($this, 'logo'));
	
		// implement display options that do not follow the normal pattern
		if (!empty($this->display['misc']['display']['braces'])) {
			add_filter('thesis_post_num_comments', array($this, 'num_comments'));
			add_filter('thesis_comments_intro', array($this, 'comments_intro'));
		}
		// the previous/next links (found on home, archive, and single templates) require special filtering based on page context
		add_filter('thesis_html_container_prev_next_show', array($this, 'prev_next'));
		// hook header image into the proper location for this Skin
		add_action('hook_bottom_header', array($this, 'header_image'));
	}
	
	// Logo functionality
	public function add_menu($menu) {
		$menu["{$this->_class}_logo"] = array(
			'text' => __('Logo', 'thesis_newmagaz'),
			'url' => admin_url("admin.php?page=thesis&canvas={$this->_class}_logo"));
		return $menu;
	}

	public function add_quicklaunch($menu) {
		$menu["{$this->_class}_logo"] = array(
			'text' => __('Logo', 'thesis_newmagaz'),
			'url' => "admin.php?page=thesis&canvas={$this->_class}_logo");
		return $menu;
	}

	public function logo_admin() {
		$action = "{$this->_class}_logo";
		echo
			"\t\t<h3>". __('NewMagaz Skin Logo', 'thesis_newmagaz'). "</h3>\n".
			"\t\t<div class=\"option_item\" id=\"t_header_image_container\">\n".
			(!empty($this->pfied_logo) ?
			"\t\t\t<img src=\"". esc_url($this->pfied_logo['src']). "\" height=\"". (int) $this->pfied_logo['height']. "\" width=\"". (int) $this->pfied_logo['width']. "\"/>\n".
			"\t\t\t<p style=\"font-size: 14px; color: #888;\">". sprintf(__('Current image is %1$dpx wide by %2$dpx tall.', 'thesis_newmagaz'), (int) $this->pfied_logo['width'], (int) $this->pfied_logo['height']). "</p>\n" : '').
			"\t\t</div>\n".
			"\t\t<p>\n".
			"\t\t<button id=\"choose-from-library-link\" data-style=\"save button\" data-update-link=\"". esc_url(add_query_arg(array('action' => $action, '_wpnonce' => wp_create_nonce($action)), admin_url("admin-post.php"))). "\" data-choose=\"". __('Select a Logo', 'thesis_newmagaz'). "\" data-update=\"". __('Set Logo', 'thesis_newmagaz'). "\">". __('Select Logo', 'thesis_newmagaz'). "</button>\n".
			(!empty($this->pfied_logo) ?
			"\t\t<a id=\"t_delete_header_image\" data-style=\"button delete\" class=\"t_inline_delete_button\" href=\"". esc_url(add_query_arg(array('action' => $action, '_wpnonce' => wp_create_nonce($action), 'delete' => 'true'), admin_url("admin-post.php"))). "\">". __('Remove Logo', 'thesis_newmagaz'). "</a>\n" : '').
			"\t\t</p>\n";
	}

	public function save_logo() {
		global $thesis;
		$thesis->wp->check('edit_theme_options');
		$thesis->wp->nonce($_GET['_wpnonce'], "{$this->_class}_logo");
		if (!empty($_GET['delete']) && $_GET['delete'] === 'true') {
			delete_option("{$this->_class}_logo");
			$this->pfied_logo = array();
		}
		else {
			$id = (int) $_GET['file'];
			$image = wp_get_attachment_metadata($id);
			update_option("{$this->_class}_logo", $this->pfied_logo = array(
				'src' => esc_url_raw(wp_get_attachment_url($id)),
				'height' => (int) $image['height'],
				'width' => (int) $image['width'],
				'id' => $id));
		}
		wp_cache_flush();
		$this->_write_css();
		wp_redirect(admin_url("admin.php?page=thesis&canvas={$this->_class}_logo"));
		exit;
	}

	public function logo($title) {
		
		if (empty($this->pfied_logo)) return  $title;
		return "<img id=\"thesis_logo_image\" src=\"". esc_url($this->pfied_logo['src']). "\" alt=\"$title\" width=\"{$this->pfied_logo['width']}\" height=\"{$this->pfied_logo['height']}\" title=\"". __('click to go home', 'thesis_newmagaz'). "\" /></a>\n";
	}

/*---:[ Implement non-standard display options ]:---*/

	/*
	The following is a special filter to prevent the prev/next container from showing if the query only has 1 page of results.
	*/
	public function prev_next() {
		global $wp_query;
		return (($wp_query->is_home || $wp_query->is_archive || $wp_query->is_search) && $wp_query->max_num_pages > 1) || ($wp_query->is_single && !empty($this->display['misc']['display']['prev_next'])) ? true : false;
	}

	public function num_comments($content) {
		return "<span class=\"bracket\">{</span> $content <span class=\"bracket\">}</span>";
	}

	public function comments_intro($text) {
		return "<span class=\"bracket\">{</span> $text <span class=\"bracket\">}</span>";
	}
	
	
/*---:[ Skin Display Options ]:---*/

	/*
	Skin API method for initiating display options; return an array in Thesis Options API array format.
	— Display options: http://diythemes.com/thesis/rtfm/api/skin/#section-display
	— Options API array format: http://diythemes.com/thesis/rtfm/api/options/array-format/
	*/
	protected function display() {
		return array( // use an options object set for simplified display controls
			'display' => array(
				'type' => 'object_set',
				'select' => __('Select content to display:', 'thesis_newmagaz'),
				'objects' => array(
					'site' => array(
						'type' => 'object',
						'label' => __('Site Title &amp; Tagline', 'thesis_newmagaz'),
						'fields' => array(
							'display' => array(
								'type' => 'checkbox',
								'options' => array(
									'title' => __('Site title', 'thesis_newmagaz'),
									'tagline' => __('Site tagline', 'thesis_newmagaz')),
								'default' => array(
									'title' => true,
									'tagline' => true)))),
					'loop' => array(
						'type' => 'object',
						'label' => __('Post/Page Output', 'thesis_newmagaz'),
						'fields' => array(
							'display' => array(
								'type' => 'checkbox',
								'options' => array(
									'author' => __('Author', 'thesis_newmagaz'),
									'avatar' => __('Author avatar', 'thesis_newmagaz'),
									'description' => __('Author description (Single template)', 'thesis_newmagaz'),
									'date' => __('Date', 'thesis_newmagaz'),
									'wp_featured_image' => __('WP featured image', 'thesis_newmagaz'),
									'image' => __('Thesis post image (Single, Page, and Landing Page templates)', 'thesis_newmagaz'),
									'thumbnail' => __('Thesis thumbnail image (Home template)', 'thesis_newmagaz'),
									'num_comments' => __('Number of comments (Home and Archive templates)', 'thesis_newmagaz'),
									'cats' => __('Categories', 'thesis_newmagaz'),
									'tags' => __('Tags', 'thesis_newmagaz')),
								'default' => array(
									'author' => true,
									'date' => true,
									'wp_featured_image' => true,
									'num_comments' => true)))),
					'comments' => array(
						'type' => 'object',
						'label' => __('Comments', 'thesis_newmagaz'),
						'fields' => array(
							'display' => array(
								'type' => 'checkbox',
								'options' => array(
									'post' => __('Comments on posts', 'thesis_newmagaz'),
									'page' => __('Comments on pages', 'thesis_newmagaz'),
									'date' => __('Comment date', 'thesis_newmagaz'),
									'avatar' => __('Comment avatar', 'thesis_newmagaz')),
								'default' => array(
									'post' => true,
									'date' => true,
									'avatar' => true)))),
					'sidebar' => array(
						'type' => 'object',
						'label' => __('Sidebar', 'thesis_newmagaz'),
						'fields' => array(
							'display' => array(
								'type' => 'checkbox',
								'options' => array(
									'sidebar' => __('Sidebar', 'thesis_newmagaz'),
									'text' => __('Sidebar Text Box', 'thesis_newmagaz'),
									'widgets' => __('Sidebar Widgets', 'thesis_newmagaz')),
								'default' => array(
									'sidebar' => true,
									'text' => true,
									'widgets' => true)))),
					'misc' => array(
						'type' => 'object',
						'label' => __('Miscellaneous', 'thesis_newmagaz'),
						'fields' => array(
							'display' => array(
								'type' => 'checkbox',
								'options' => array(
									'braces' => __('Iconic Classic Responsive Skin curly braces', 'thesis_newmagaz'),
									'prev_next' => __('Previous/next post links (single template)', 'thesis_newmagaz'),
									'attribution' => __('Skin attribution', 'thesis_newmagaz'),
									'wp_admin' => __('WP admin link', 'thesis_newmagaz')),
								'default' => array(
									'braces' => true,
									'prev_next' => true,
									'attribution' => true,
									'wp_admin' => true)))))));
	}
	
/*
	Skin API method for automatic show/hide handling of elements with display options.
	Display options are defined in the display() method below.
	— (documentation link needed)
	*/
	public function display_elements() {
		return array( // Display options with filter references
			'site' => array(
				'title' => 'thesis_site_title',
				'tagline' => 'thesis_site_tagline'),
			'loop' => array( // 'loop' has been added as a programmatic ID to these Boxes
				'author' => 'thesis_post_author_loop',
				'avatar' => 'thesis_post_author_avatar_loop',
				'description' => 'thesis_post_author_description_loop',
				'date' => 'thesis_post_date_loop',
				'wp_featured_image' => 'thesis_wp_featured_image_loop',
				'cats' => 'thesis_post_categories_loop',
				'tags' => 'thesis_post_tags_loop',
				'num_comments' => 'thesis_post_num_comments_loop',
				'image' => 'thesis_post_image_loop',
				'thumbnail' => 'thesis_post_thumbnail_loop'),
			'comments' => array( // 'comments' has been added as a programmatic ID to the date and avatar Boxes
				'post' => 'thesis_html_container_post_comments',
				'page' => 'thesis_html_container_page_comments',
				'date' => 'thesis_comment_date_comments',
				'avatar' => 'thesis_comment_avatar_comments'),
			'sidebar' => array( // 'sidebar' is the hook name for 'sidebar' and the programmatic ID for text and widgets
				'sidebar' => 'thesis_html_container_sidebar',
				'text' => 'thesis_text_box_sidebar',
				'widgets' => 'thesis_wp_widgets_sidebar'),
			'misc' => array(
				'attribution' => 'thesis_attribution',
				'wp_admin' => 'thesis_wp_admin'));
	}	
	
	
/*---:[ Skin Design Options ]:---*/

	/*
	Skin API method for initiating design options; return an array in Thesis Options API array format.
	— Design options: http://diythemes.com/thesis/rtfm/api/skin/#section-design
	— Options API array format: http://diythemes.com/thesis/rtfm/api/options/array-format/
	*/
	protected function design() {
		$css = $this->css_tools->options; // shorthand for all options available in the CSS API
		$fsc = $nav = $this->css_tools->font_size_color(); // the CSS API contains shorthand for font, size, and color options
		unset($nav['color']); // remove nav text color control
		$links['default'] = 'FFD540'; // default link color
		$links['gray'] = $this->color->gray($links['default']); // array of 'hex' and 'rgb' values
		return array(
			'colors' => $this->color_scheme(array( // the Skin API contains a color_scheme() method for easy implementation
				'id' => 'colors',
				'colors' => array(
					'text1' => __('Primary Text', 'thesis_newmagaz'),
					'text2' => __('Secondary Text', 'thesis_newmagaz'),
					'links' => __('Links', 'thesis_newmagaz'),
					'color1' => __('Borders &amp; Highlights', 'thesis_newmagaz'),
					'color2' => __('title BG color', 'thesis_newmagaz'),
					'color3' => __('Land  optin BG color', 'thesis_newmagaz'),
					'color4' => __('Byline Text color', 'thesis_newmagaz'),
					'color5' => __('Readmore hvr bg color', 'thesis_newmagaz'),
					'tb_header_bg' => __('Top Bottom Header BG color', 'thesis_newmagaz'),
					'search_bg' => __('Search BackGround color', 'thesis_newmagaz'),
					'ctr_hdr_bg' => __('Center Header BG color', 'thesis_newmagaz'),
					'body_bg' => __('Body Background color', 'thesis_newmagaz'),
					'post_bg' => __('Post Box BackGround color', 'thesis_newmagaz'),
					'social_flw_bg' => __('Social follow Background  color', 'thesis_newmagaz'),
					'ftext_clr' => __('Top Footer content text color', 'thesis_newmagaz'),
					'blk_title1' => __('First Category Title BackGround color', 'thesis_newmagaz'),
					'blk_title2' => __('Second Category Title BackGround color', 'thesis_newmagaz'),
					'blk_title3' => __('Third Category Title BackGround color', 'thesis_newmagaz'),
					'blk_title4' => __('Fourth Category Title BackGround color', 'thesis_newmagaz'),
					'blk_title5' => __('Fifth Category Title BackGround color', 'thesis_newmagaz'),
					'blk_title6' => __('Sixth Category Title BackGround color', 'thesis_newmagaz'),
					'sb_border' => __('Postbox border color', 'thesis_newmagaz')),
					
				'default' => array(
					'text1' => '888888',
					'text2' => '333333',
					'links' => $links['default'],
					'color1' => 'DDDDDD',
					'color2' => 'FFFFFF',
					'color3' => 'F5F5F5',
					'color4' => '555555',
					'color5' => '212121',
					'tb_header_bg' => '393939',
					'search_bg' => '444444',
					'ctr_hdr_bg' => '232323',
					'body_bg' => 'e7e7e7',
					'post_bg' => 'F8F8F8',
					'social_flw_bg' => 'BBBBBB',
					'ftext_clr' => '999999',
					'blk_title1' => 'ef4d4e',
					'blk_title2' => 'a9c056',
					'blk_title3' => '27aac5',
					'blk_title4' => '9b59b6',
					'blk_title5' => 'ff9c31',
					'blk_title6' => '46bfa9',
					'sb_border' => 'eaeaea'),
					
					
				'scale' => array(
					'links' => $links['gray']['hex'],
					'color1' => 'DDDDDD',
					'color2' => 'FFFFFF',
					'color3' => 'F5F5F5',
					'color4' => '555555',
					'color5' => '212121',
					'tb_header_bg' => '393939',
					'search_bg' => '444444',
					'ctr_hdr_bg' => '232323',
					'body_bg' => 'e7e7e7',
					'post_bg' => 'F8F8F8',
					'social_flw_bg' => 'BBBBBB',
					'ftext_clr' => '999999',
					'blk_title1' => 'ef4d4e',
					'blk_title2' => 'a9c056',
					'blk_title3' => '27aac5',
					'blk_title4' => '9b59b6',
					'blk_title5' => 'ff9c31',
					'blk_title6' => '46bfa9',
					'sb_border' => 'eaeaea'))),
			'elements' => array( // this is an object set containing all other design options for this Skin
				'type' => 'object_set',
				'label' => __('Layout, Fonts, Sizes, and Colors', 'thesis_newmagaz'),
				'select' => __('Select a design element to edit:', 'thesis_newmagaz'),
				'objects' => array(
					'layout' => array(
						'type' => 'object',
						'label' => __('Layout &amp; Dimensions', 'thesis_newmagaz'),
						'fields' => array(
							'columns' => array(
								'type' => 'select',
								'label' => __('Layout', 'thesis_newmagaz'),
								'options' => array(
									1 => __('1 column', 'thesis_newmagaz'),
									2 => __('2 columns', 'thesis_newmagaz')),
								'default' => 2,
								'dependents' => array(2)),
							'order' => array(
								'type' => 'radio',
								'options' => array(
									'' => __('Content on the left', 'thesis_newmagaz'),
									'right' => __('Content on the right', 'thesis_newmagaz')),
								'parent' => array(
									'columns' => 2)),
							'width-content' => array(
								'type' => 'text',
								'width' => 'tiny',
								'label' => __('Content Width', 'thesis_newmagaz'),
								'tooltip' => __('The default content column width is 617px. The value you enter here is the entire width of the column, including padding and borders. The resulting width of your text in this column is based on your selected font and font size. We recommend using Chrome Developer Tools or Firebug for Firefox to inspect the text width if you need to achieve a precise value.', 'thesis_newmagaz'),
								'description' => 'px',
								'default' => 850),
							'width-sidebar' => array(
								'type' => 'text',
								'width' => 'tiny',
								'label' => __('Sidebar Width', 'thesis_newmagaz'),
								'tooltip' => __('The default sidebar column width is 280px. The value you enter here is the entire width of the column, including padding. The resulting width of your text in this column is based on your selected font and font size. We recommend using Chrome Developer Tools or Firebug for Firefox to inspect the text width if you need to achieve a precise value.', 'thesis_newmagaz'),
								'description' => 'px',
								'default' => 350,
								'parent' => array(
									'columns' => 2)))),
					'font' => array(
						'type' => 'object',
						'label' => __('Font &amp; Size (Primary)', 'thesis_newmagaz'),
						'fields' => array(
							'family' => array_merge($css['font']['fields']['font-family'], array('default' => 'georgia')),
							'size' => array_merge($css['font']['fields']['font-size'], array('default' => 16)))),
					'headline' => array(
						'type' => 'group',
						'label' => __('Headlines', 'thesis_newmagaz'),
						'fields' => $fsc),
					'subhead' => array(
						'type' => 'group',
						'label' => __('Sub-headlines', 'thesis_newmagaz'),
						'fields' => $fsc),
					
					'menu' => array(
						'type' => 'object',
						'label' => __('Nav Menu', 'thesis_newmagaz'),
						'fields' => $nav))));
	}
	
	
	
		/*
	Skin API method for modifying CSS variables each time CSS is saved.
	Return an array of CSS variables, including units (if necessary), with their new values.
	Any variables not included in the return array will not be modified.
	— http://diythemes.com/thesis/rtfm/api/skin/#section-variables
	*/
	public function css_variables() {
		global $thesis;
		$columns = !empty($this->design['layout']['columns']) && is_numeric($this->design['layout']['columns']) ?
			$this->design['layout']['columns'] : 2;
		$order = !empty($this->design['layout']['order']) && $this->design['layout']['order'] == 'right' ? true : false;
		$px['w_content'] = !empty($this->design['layout']['width-content']) && is_numeric($this->design['layout']['width-content']) ?
			abs($this->design['layout']['width-content']) : 850;
		$px['w_sidebar'] = !empty($this->design['layout']['width-sidebar']) && is_numeric($this->design['layout']['width-sidebar']) ?
			abs($this->design['layout']['width-sidebar']) : 350;
		$px['w_total'] = $px['w_content'] + ($columns == 2 ? $px['w_sidebar'] : 0);
		$vars['font'] = $this->fonts->family($font = !empty($this->design['font']['family']) ? $this->design['font']['family'] : 'georgia');
		$s['content'] = !empty($this->design['font']['size']) ? $this->design['font']['size'] : 16;
		// Determine typographical scale based on primary font size
		$f['content'] = $this->typography->scale($s['content']);
		/*
		The final line height, $h['content'], is calculated in 3 iterations:
		1. Get the optimal line height for the current font and size
		2. Get an adjusted line height using optimal spacing for the current font and size
		3. Adjust the line height a final time with adjusted spacing for the current font and size
		Both the line height, $h['content'], and layout spacing, $x['content'], are calculated below:
		*/
		$x['content'] = $this->typography->space($h['content'] = $this->typography->height($s['content'], ($w['content'] = $px['w_content'] - ($adjust = round(2 * $this->typography->height($s['content'], $px['w_content'] - ($first = round(2 * $this->typography->height($s['content'], false, $font), 0)) - 1, $font), 0)) - 1), $font));
		// Determine sidebar font, size, typographical scale, and spacing
		$sidebar_font = !empty($this->design['sidebar']['font']) ? $this->design['sidebar']['font'] : $font;
		$s['sidebar'] = !empty($this->design['sidebar']['font-size']) && is_numeric($this->design['sidebar']['font-size']) ?
			$this->design['sidebar']['font-size'] : $f['content']['f6'];
		$f['sidebar'] = $this->typography->scale($s['sidebar']);
		$x['sidebar'] = $this->typography->space($h['sidebar'] = $this->typography->height($s['sidebar'], ($w['sidebar'] = $px['w_sidebar'] - 2 * $x['content']['x1']), $sidebar_font));
		// Set up an array containing numerical values that require a unit for CSS output
		$px['f_text'] = $f['content']['f5'];
		$px['f_aux'] = $f['content']['f6'];
		$px['f_subhead'] = $f['content']['f4'];
		$px['h_text'] = round($h['content'], 0);
		$px['h_aux'] = round($this->typography->height($f['content']['f6'], $w['content'], $font), 0);
		foreach ($x['content'] as $dim => $value)
			$px["x_$dim"] = $value;
		foreach ($x['sidebar'] as $dim => $value)
			$px["s_x_$dim"] = $value;
		// Add the 'px' unit to the $px array constructed above
		$vars = is_array($px) ? array_merge($vars, $this->css_tools->unit($px)) : $vars;
		// Use the Colors API to set up proper CSS color references
		foreach (array('text1', 'text2', 'border_color', 'links', 'color1', 'color2','color3','color4', 'color5', 'tb_header_bg', 'search_bg', 'ctr_hdr_bg', 'menu_border', 'body_bg', 'post_bg', 'hover', 'social_flw_bg', 'ftext_clr', 'blk_title1', 'blk_title2', 'blk_title3', 'blk_title4', 'blk_title5', 'blk_title6', 'sb_border') as $color)
			$vars[$color] = !empty($this->design[$color]) ? $this->color->css($this->design[$color]) : false;
		// Set up a modification array for individual typograhical overrides
		$elements = array(
			'menu' => array(
				'font-family' => false,
				'font-size' => $f['content']['f6']),
			'title' => array(
				'font-family' => false,
				'font-size' => $f['content']['f1']),
			'tagline' => array(
				'font-family' => false,
				'font-size' => $f['content']['f5'],
				'color' => !empty($vars['text2']) ? $vars['text2'] : false),
			'headline' => array(
				'font-family' => false,
				'font-size' => $f['content']['f3']),
			'subhead' => array(
				'font-family' => false,
				'font-size' => $f['content']['f4']),
			'blockquote' => array(
				'font-family' => false,
				'font-size' => false,
				'color' => !empty($vars['text2']) ? $vars['text2'] : false),
			'code' => array(
				'font-family' => 'consolas',
				'font-size' => false,
				'color' => false),
			'pre' => array(
				'font-family' => 'consolas',
				'font-size' => false,
				'color' => false),
			'sidebar' => array(
				'font-family' => false,
				'font-size' => $f['sidebar']['f5'],
				'color' => false),
			'sidebar_heading' => array(
				'font-family' => false,
				'font-size' => $f['sidebar']['f3'],
				'color' => false));
		// Loop through the modification array to see if any fonts, sizes, or colors need to be overridden
		foreach ($elements as $name => $element) {
			foreach ($element as $p => $def)
				$e[$name][$p] = $p == 'font-family' ?
					(!empty($this->design[$name][$p]) ?
						"$p: ". $this->fonts->family($family[$name] = $this->design[$name][$p]). ';' : (!empty($def) ?
						"$p: ". $this->fonts->family($family[$name] = $def). ';' : false)) : ($p == 'font-size' ?
					(!empty($this->design[$name][$p]) && is_numeric($this->design[$name][$p]) ?
						"$p: ". ($size[$name] = $this->design[$name][$p]). "px;" : (!empty($def) ?
						"$p: ". ($size[$name] = $def). "px;" : false)) : ($p == 'color' ?
					(!empty($this->design[$name][$p]) ?
						"$p: ". $this->color->css($this->design[$name][$p]). ';' : (!empty($def) ?
						"$p: $def;" : false)) : false));
			$e[$name] = array_filter($e[$name]);
		}
		foreach (array_filter($e) as $name => $element)
			$vars[$name] = implode("\n\t", $element);
		// Override content elements
		foreach (array('headline', 'subhead', 'blockquote', 'pre') as $name)
			if (!empty($size[$name]))
				$vars[$name] .= "\n\tline-height: ". ($line[$name] = round($this->typography->height($size[$name], $w['content'], !empty($family[$name]) ? $family[$name] : $font), 0)). "px;";
		// Override sidebar elements
		foreach (array('sidebar', 'sidebar_heading') as $name)
			if (!empty($size[$name]))
				$vars[$name] .= "\n\tline-height: ". round($this->typography->height($size[$name], $w['sidebar'], !empty($family[$name]) ? $family[$name] : $sidebar_font), 0). "px;";
		// Determine multi-use color variables
		foreach (array('title', 'headline', 'subhead') as $name)
			$vars["{$name}_color"] = !empty($this->design[$name]['color']) ?
				$this->color->css($this->design[$name]['color']) : (!empty($vars['text1']) ? $vars['text1'] : false);
		// Set up property-value variables, which, unlike the other variables above, contain more than just a CSS value
		$vars['column1'] =
			"float: ". ($columns == 2 ? ($order ? 'right' : 'left') : 'none'). ";\n\t".
			"padding: ". ($columns == 2 ? ($order ? '0 20px 0 0px' : '0 20px 0 0') : '0'). ";";
		$vars['column2'] =
			"width: ". ($columns == 2 ? '$w_sidebar' : '100%'). ";\n\t".
			"float: ". ($columns == 2 ? ($order ? 'left' : 'right') : 'none'). ";\n\t".
			"padding: ". ($columns == 2 ? ($order ? '0 0px 0 20px' : '0 20px 0 0') : '0'). ';'. ($columns == 1 ?
			"\n\tborder-top: 3px double \$color1;" : '');
		$vars['submenu'] = ($w_submenu = ((!empty($size['menu']) ? $size['menu'] : $px['f_aux']) * 14)). "px";
		$vars['menu'] .= "\n\tline-height: ". round($this->typography->height((!empty($size['menu']) ? $size['menu'] : $px['f_aux']), $w_submenu, !empty($family['menu']) ? $family['menu'] : $font)). "px;";
		$vars['pullquote'] =
			"font-size: ". $f['content']['f3']. "px;\n\t".
			"line-height: ". round($this->typography->height($f['content']['f3'], round(0.45 * $w['content'], 0), !empty($family['blockquote']) ? $family['blockquote'] : $font), 0). "px;";
		$vars['avatar'] =
			"width: ". ($avatar = $line['headline'] + $px['h_aux']). "px;\n\t".
			"height: {$avatar}px;";
		$vars['comment_avatar'] =
			"width: ". (2 * $px['h_text']). "px;\n\t".
			"height: ". (2 * $px['h_text']). "px;";
		foreach (array(2, 3, 4) as $factor)
			if (($bio_size = $factor * $px['h_text']) <= 96)
				$bio = $bio_size;
		$vars['bio_avatar'] =
			"width: {$bio}px;\n\t".
			"height: {$bio}px;";
		return array_filter($vars); // Filter the array to remove any null elements
	}

	
/*---:[ Implement a user-added Header Image ]:---*/

	/*
	Output user header image by referencing the Skin API header image object and its associated html() method.
	— (documentation link needed)
	*/
	public function header_image() {
		$this->header_image->html();
	}

	/*
	Skin API method for filtering the CSS output whenever the stylesheet is rewritten.
	In this case, we are adding some CSS if the user has selected a header image.]
	*/
	public function filter_css($css) {
		return $css. (!empty($this->header_image->image) ?
		"\n.center_header .newmagaz_logo,.header_advertisement {\n".
		"\tdisplay:none;\n".
		"}\n".
		"\n#thesis_header_image{\n".
		"\tpadding-top:20px;clear:both;\n".
		"}\n".
		".header{\n".
		"\theight: auto;\n".
		"}\n" : '');
	}	

	public function thesis_meta_viewport() { // Skin API method for adding viewport meta to the HTML <head>
		return 'width=device-width';
	}


}


function catch_that_image() {
        global $post, $posts;
        $first_img = '';
        ob_start();
        ob_end_clean();
        $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
        if(count($matches [1]))$first_img = $matches [1] [0];
        return $first_img;
}

/*function new_excerpt_length($length) {
    return 10;
}
add_filter('excerpt_length', 'new_excerpt_length');*/

function limit_words($string, $word_limit)
{
  $words = explode(' ', $string, ($word_limit + 1));
  if(count($words) > $word_limit)
  array_pop($words);
  return implode(' ', $words);
}

function new_excerpt_length($length) {
    return 20;
}
add_filter('excerpt_length', 'new_excerpt_length');

function string_limit_words($string, $word_limit)
{
  $words = explode(' ', $string, ($word_limit + 1));
  if(count($words) > $word_limit)
  array_pop($words);
  return implode(' ', $words);
}

add_theme_support( 'post-thumbnails' );

function replace_content($text)
{
$alt = get_the_author_meta( 'display_name' );
$text = str_replace('alt=\'\'', 'alt=\'Avatar for '.$alt.'\' title=\'Gravatar for '.$alt.'\'',$text);
return $text;
}
add_filter('get_avatar','replace_content');
